/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class StringValidator
extends PatternValidator
implements TypeValidator {
    private static final String PRESERVE = "preserve";
    private static final String REPLACE = "replace";
    private static final String COLLAPSE = "collapse";
    private String fixed = null;
    private boolean required = false;
    private int _length = 0;
    private int minLength = 0;
    private int maxLength = -1;
    private String _whiteSpace = "preserve";

    public void setFixed(String fixedValue) {
        this.fixed = fixedValue;
    }

    public void setFixedValue(String fixedValue) {
        this.setFixed(fixedValue);
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setLength(int length) {
        this._length = length;
        this.setMaxLength(length);
        this.setMinLength(length);
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setWhiteSpace(String value) {
        if (value.equals(PRESERVE)) {
            this._whiteSpace = value;
        } else if (value.equals(REPLACE)) {
            this._whiteSpace = value;
        } else if (value.equals(COLLAPSE)) {
            this._whiteSpace = value;
        } else {
            System.out.println("Warning : " + value + " is a bad entry for the whiteSpace value");
            this._whiteSpace = value;
        }
    }

    public String normalize(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return value;
        }
        char[] chars = value.toCharArray();
        int length = chars.length;
        block3: for (int i = 0; i < length; ++i) {
            switch (chars[i]) {
                case '\t': 
                case '\n': 
                case '\r': {
                    chars[i] = 32;
                    continue block3;
                }
            }
        }
        if (this._whiteSpace.equals(COLLAPSE)) {
            char[] temp = new char[chars.length];
            int temp_count = 0;
            int i = 0;
            while (i < length - 1) {
                if (chars[i] == ' ') {
                    temp[temp_count] = chars[i];
                    ++temp_count;
                    ++i;
                    while (i < length - 1 && chars[i] == ' ') {
                        ++i;
                    }
                    continue;
                }
                temp[temp_count] = chars[i];
                ++temp_count;
                ++i;
            }
            if (chars[i] != ' ') {
                temp[temp_count] = chars[i];
            }
            length = ++temp_count;
            chars = temp;
        }
        return new String(chars, 0, length);
    }

    @Override
    public void validate(String value, ValidationContext context) throws ValidationException {
        if (value == null) {
            if (this.required && !this.isNillable()) {
                String err = "this is a required field and cannot be null.";
                throw new ValidationException(err);
            }
        } else {
            if (this.fixed != null && !this.fixed.equals(value)) {
                String err = "strings of this type must be equal to the fixed value of " + this.fixed;
                throw new ValidationException(err);
            }
            int len = value.length();
            if (this._length > 0 && len != this._length) {
                String err = "strings of this type must have a length of " + this._length;
                throw new ValidationException(err);
            }
            if (this.minLength > 0 && len < this.minLength) {
                String err = "strings of this type must have a minimum length of " + this.minLength;
                throw new ValidationException(err);
            }
            if (this.maxLength >= 0 && len > this.maxLength) {
                String err = "strings of this type must have a maximum length of " + this.maxLength;
                throw new ValidationException(err);
            }
            if (this.hasPattern()) {
                super.validate(value, context);
            }
            if (!this._whiteSpace.equals(PRESERVE)) {
                this.normalize(value);
            }
        }
    }

    public void validate(Object object) throws ValidationException {
        this.validate(object, (ValidationContext)null);
    }

    @Override
    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            if (this.required) {
                String err = "this is a required field and cannot be null.";
                throw new ValidationException(err);
            }
        } else {
            this.validate(object.toString(), context);
        }
    }
}

