/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.StringValidator;
import org.exolab.castor.xml.validators.ValidationUtils;

public class NameValidator
extends StringValidator {
    public static final short NCNAME = 0;
    public static final short NMTOKEN = 1;
    public static final short CDATA = 2;
    private short type = 0;
    private boolean required = false;

    public NameValidator() {
    }

    public NameValidator(short type) {
        this.type = type;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public void validate(String value, ValidationContext context) throws ValidationException {
        super.validate(value, context);
        switch (this.type) {
            case 2: {
                if (ValidationUtils.isCDATA(value)) break;
                Object err = "\"";
                err = (String)err + value + "\" is not a valid CDATA.";
                throw new ValidationException((String)err);
            }
            case 1: {
                if (ValidationUtils.isNMToken(value)) break;
                Object err = "\"";
                err = (String)err + value + "\" is not a valid NMToken.";
                throw new ValidationException((String)err);
            }
            default: {
                if (ValidationUtils.isNCName(value)) break;
                Object err = "\"";
                err = (String)err + value + "\" is not a valid NCName.";
                throw new ValidationException((String)err);
            }
        }
    }

    @Override
    public void validate(Object object) throws ValidationException {
        this.validate(object, (ValidationContext)null);
    }

    @Override
    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object != null) {
            this.validate(object.toString(), context);
        } else {
            this.validate(null, context);
        }
    }
}

