/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class LongValidator
extends PatternValidator
implements TypeValidator {
    private boolean useMin = false;
    private boolean useMax = false;
    private boolean useFixed = false;
    private long min = 0L;
    private long max = 0L;
    private long fixed = 0L;

    public void clearFixed() {
        this.useFixed = false;
    }

    public void clearMax() {
        this.useMax = false;
    }

    public void clearMin() {
        this.useMin = false;
    }

    public Long getFixed() {
        if (this.useFixed) {
            return new Long(this.fixed);
        }
        return null;
    }

    public Long getMaxInclusive() {
        if (this.useMax) {
            return new Long(this.max);
        }
        return null;
    }

    public Long getMinInclusive() {
        if (this.useMin) {
            return new Long(this.min);
        }
        return null;
    }

    public boolean hasFixed() {
        return this.useFixed;
    }

    public void setFixed(long fixedValue) {
        this.useFixed = true;
        this.fixed = fixedValue;
    }

    public void setMinExclusive(long minValue) {
        this.useMin = true;
        this.min = minValue + 1L;
    }

    public void setMinInclusive(long minValue) {
        this.useMin = true;
        this.min = minValue;
    }

    public void setMaxExclusive(long maxValue) {
        this.useMax = true;
        this.max = maxValue - 1L;
    }

    public void setMaxInclusive(long maxValue) {
        this.useMax = true;
        this.max = maxValue;
    }

    public void validate(long value, ValidationContext context) throws ValidationException {
        if (this.useFixed) {
            if (value != this.fixed) {
                String err = value + " is not equal to the fixed value of " + this.fixed;
                throw new ValidationException(err);
            }
            return;
        }
        if (this.useMin && value < this.min) {
            String err = value + " is less than the minimum allowable ";
            err = err + "value of " + this.min;
            throw new ValidationException(err);
        }
        if (this.useMax && value > this.max) {
            String err = value + " is greater than the maximum allowable ";
            err = err + "value of " + this.max;
            throw new ValidationException(err);
        }
        if (this.hasPattern()) {
            super.validate(Long.toString(value), context);
        }
    }

    public void validate(Object object) throws ValidationException {
        this.validate(object, (ValidationContext)null);
    }

    @Override
    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            String err = "LongValidator cannot validate a null object.";
            throw new ValidationException(err);
        }
        long value = 0L;
        try {
            value = (Long)object;
        }
        catch (Exception ex) {
            Object err = "Expecting a Long, received instead: ";
            err = (String)err + object.getClass().getName();
            throw new ValidationException((String)err);
        }
        this.validate(value, context);
    }
}

