/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class FloatValidator
extends PatternValidator
implements TypeValidator {
    private boolean _isFixed = false;
    private float _fixed = 0.0f;
    private boolean _isThereMinInclusive = false;
    private float _minInclusive = 0.0f;
    private boolean _isThereMaxInclusive = false;
    private float _maxInclusive = 0.0f;
    private boolean _isThereMinExclusive = false;
    private float _minExclusive = 0.0f;
    private boolean _isThereMaxExclusive = false;
    private float _maxExclusive = 0.0f;

    public void setFixed(float fixed) {
        this._fixed = fixed;
        this._isFixed = true;
    }

    public void setMinExclusive(float minValue) {
        this._minExclusive = minValue;
        this._isThereMinExclusive = true;
    }

    public void setMinInclusive(float minValue) {
        this._minInclusive = minValue;
        this._isThereMinInclusive = true;
    }

    public void setMaxExclusive(float maxValue) {
        this._maxExclusive = maxValue;
        this._isThereMaxExclusive = true;
    }

    public void setMaxInclusive(float maxValue) {
        this._maxInclusive = maxValue;
        this._isThereMaxInclusive = true;
    }

    public void setFixed(Float fixed) {
        this.setFixed(fixed.floatValue());
    }

    public void setMinExclusive(Float minValue) {
        this.setMinExclusive(minValue.floatValue());
    }

    public void setMinInclusive(Float minValue) {
        this.setMinInclusive(minValue.floatValue());
    }

    public void setMaxExclusive(Float maxValue) {
        this.setMaxExclusive(maxValue.floatValue());
    }

    public void setMaxInclusive(Float maxValue) {
        this.setMaxInclusive(maxValue.floatValue());
    }

    public void validate(float d, ValidationContext context) throws ValidationException {
        if (this._isFixed && d != this._fixed) {
            String err = d + " is not equal to the fixed value of ";
            err = err + this._fixed;
            throw new ValidationException(err);
        }
        if (this._isThereMinInclusive && d < this._minInclusive) {
            String err = d + " is less than the minimum allowable ";
            err = err + "value of " + this._minInclusive;
            throw new ValidationException(err);
        }
        if (this._isThereMinExclusive && d <= this._minExclusive) {
            String err = d + " is less than the minimum allowable ";
            err = err + "value of " + this._minExclusive;
            throw new ValidationException(err);
        }
        if (this._isThereMaxInclusive && d > this._maxInclusive) {
            String err = d + " is greater than the maximum allowable ";
            err = err + "value of " + this._maxInclusive;
            throw new ValidationException(err);
        }
        if (this._isThereMaxExclusive && d >= this._maxExclusive) {
            String err = d + " is greater than the maximum allowable ";
            err = err + "value of " + this._maxExclusive;
            throw new ValidationException(err);
        }
        if (this.hasPattern()) {
            super.validate(Float.toString(d), context);
        }
    }

    public void validate(Object object) throws ValidationException {
        this.validate(object, (ValidationContext)null);
    }

    @Override
    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            String err = "FloatValidator cannot validate a null object.";
            throw new ValidationException(err);
        }
        float value = 0.0f;
        try {
            value = new Float(object.toString()).floatValue();
        }
        catch (Exception ex) {
            Object err = "Expecting a float, received instead: ";
            err = (String)err + object.getClass().getName();
            throw new ValidationException((String)err);
        }
        this.validate(value, context);
    }
}

