/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import org.apache.xml.serialize.Serializer;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AppInfo;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.BlockList;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.FinalList;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.IdentityConstraint;
import org.exolab.castor.xml.schema.IdentityField;
import org.exolab.castor.xml.schema.IdentitySelector;
import org.exolab.castor.xml.schema.KeyRef;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.RedefineSchema;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleContent;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Union;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.simpletypes.ListType;
import org.exolab.castor.xml.util.AnyNode2SAX;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class SchemaWriter {
    private static final String ANNOTATION = "annotation";
    private static final String APPINFO = "appinfo";
    private static final String ATTRIBUTE = "attribute";
    private static final String ATTRIBUTE_GROUP = "attributeGroup";
    private static final String COMPLEX_TYPE = "complexType";
    private static final String DOCUMENTATION = "documentation";
    private static final String ELEMENT = "element";
    private static final String GROUP = "group";
    private static final String RESTRICTION = "restriction";
    private static final String SCHEMA = "schema";
    private static final String SIMPLE_TYPE = "simpleType";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VALUE = "value";
    private static final String VALUE_FALSE = "false";
    private static final String VALUE_TRUE = "true";
    private static final String CDATA = "CDATA";
    private static final String XMLNS_PREFIX = "xmlns:";
    private static final String XMLNS_DEFAULT = "xmlns";
    private static final String DEFAULT_PREFIX = "xsd";
    private DocumentHandler _handler = null;
    private AttributeListImpl _atts = new AttributeListImpl();
    public static boolean enable = false;

    public SchemaWriter(Writer writer) throws IOException {
        Serializer serializer = LocalConfiguration.getInstance().getSerializer();
        if (serializer == null) {
            throw new IOException("Unable to obtain serailizer");
        }
        serializer.setOutputCharStream(writer);
        DocumentHandler handler = serializer.asDocumentHandler();
        if (handler == null) {
            Object err = "The following serializer is not SAX capable: ";
            err = (String)err + serializer.getClass().getName();
            err = (String)err + "; cannot proceed.";
            throw new IOException((String)err);
        }
        this._handler = handler;
    }

    public SchemaWriter(DocumentHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("DocumentHandler must not be null.");
        }
        this._handler = handler;
    }

    public void write(Schema schema) throws SAXException {
        if (schema == null) {
            throw new IllegalArgumentException("Schema must not be null.");
        }
        this.processSchema(schema);
    }

    private void processAnnotated(Annotated annotated, String schemaPrefix) throws SAXException {
        Enumeration enumeration = annotated.getAnnotations();
        while (enumeration.hasMoreElements()) {
            this.processAnnotation((Annotation)enumeration.nextElement(), schemaPrefix);
        }
    }

    private void processAnnotation(Annotation annotation, String schemaPrefix) throws SAXException {
        this._atts.clear();
        String ELEM_ANNOTATION = schemaPrefix + ANNOTATION;
        this._handler.startElement(ELEM_ANNOTATION, this._atts);
        Enumeration enumeration = annotation.getAppInfo();
        String ELEM_APPINFO = schemaPrefix + APPINFO;
        while (enumeration.hasMoreElements()) {
            AppInfo app = (AppInfo)enumeration.nextElement();
            String source = app.getSource();
            if (source != null) {
                this._atts.addAttribute("source", CDATA, source);
            }
            this._handler.startElement(ELEM_APPINFO, this._atts);
            Enumeration anyNodes = app.getObjects();
            while (anyNodes.hasMoreElements()) {
                Object obj = anyNodes.nextElement();
                if (obj instanceof AnyNode) {
                    AnyNode2SAX anyNode2SAX = new AnyNode2SAX((AnyNode)obj);
                    anyNode2SAX.setDocumentHandler(this._handler);
                    anyNode2SAX.start();
                    continue;
                }
                char[] chars = obj.toString().toCharArray();
                this._handler.characters(chars, 0, chars.length);
            }
            this._handler.endElement(ELEM_APPINFO);
        }
        enumeration = annotation.getDocumentation();
        String ELEM_DOCUMENTATION = schemaPrefix + DOCUMENTATION;
        while (enumeration.hasMoreElements()) {
            Documentation doc = (Documentation)enumeration.nextElement();
            String source = doc.getSource();
            if (source != null) {
                this._atts.addAttribute("source", CDATA, source);
            }
            this._handler.startElement(ELEM_DOCUMENTATION, this._atts);
            Enumeration anyNodes = doc.getObjects();
            while (anyNodes.hasMoreElements()) {
                Object obj = anyNodes.nextElement();
                if (obj instanceof AnyNode) {
                    AnyNode2SAX anyNode2SAX = new AnyNode2SAX((AnyNode)obj);
                    anyNode2SAX.setDocumentHandler(this._handler);
                    anyNode2SAX.start();
                    continue;
                }
                char[] chars = obj.toString().toCharArray();
                this._handler.characters(chars, 0, chars.length);
            }
            this._handler.endElement(ELEM_DOCUMENTATION);
        }
        this._handler.endElement(ELEM_ANNOTATION);
    }

    private void processAttribute(AttributeDecl attribute, String schemaPrefix) throws SAXException {
        String ELEM_ATTRIBUTE = schemaPrefix + ATTRIBUTE;
        this._atts.clear();
        boolean isReference = attribute.isReference();
        if (!isReference) {
            this._atts.addAttribute(ATTR_NAME, CDATA, attribute.getName());
        } else {
            this._atts.addAttribute("ref", CDATA, attribute.getReferenceName());
        }
        boolean hasAnonymousType = false;
        SimpleType type = attribute.getSimpleType();
        if (!isReference && type != null) {
            if (type.getName() != null) {
                Object typeName = type.getName();
                if (((String)typeName).indexOf(58) < 0) {
                    if (type.isBuiltInType()) {
                        typeName = schemaPrefix + (String)typeName;
                    } else {
                        String prefix;
                        String namespace = type.getSchema().getTargetNamespace();
                        if (namespace == null) {
                            namespace = "";
                        }
                        if ((prefix = this.getNSPrefix(attribute.getSchema(), namespace)) != null && prefix.length() > 0) {
                            typeName = prefix + ":" + (String)typeName;
                        }
                    }
                }
                this._atts.addAttribute(ATTR_TYPE, CDATA, (String)typeName);
            } else {
                hasAnonymousType = true;
            }
        }
        if (attribute.isDefault()) {
            this._atts.addAttribute("default", CDATA, attribute.getDefaultValue());
        } else if (attribute.isFixed()) {
            this._atts.addAttribute("fixed", CDATA, attribute.getFixedValue());
        }
        if (attribute.getForm() != null) {
            this._atts.addAttribute("form", CDATA, attribute.getForm().toString());
        }
        if (attribute.getId() != null) {
            this._atts.addAttribute("id", CDATA, attribute.getId());
        }
        if (attribute.isRequired()) {
            this._atts.addAttribute("use", CDATA, "required");
        } else if (attribute.isProhibited()) {
            this._atts.addAttribute("use", CDATA, "prohibited");
        }
        this._handler.startElement(ELEM_ATTRIBUTE, this._atts);
        this.processAnnotated(attribute, schemaPrefix);
        if (hasAnonymousType) {
            this.processSimpleType(type, schemaPrefix);
        }
        this._handler.endElement(ELEM_ATTRIBUTE);
    }

    private void processAttributeGroup(AttributeGroup attGroup, String schemaPrefix) throws SAXException {
        String ELEM_ATTRIBUTE_GROUP = schemaPrefix + ATTRIBUTE_GROUP;
        this._atts.clear();
        boolean isReference = attGroup instanceof AttributeGroupReference;
        if (!isReference) {
            this._atts.addAttribute(ATTR_NAME, CDATA, ((AttributeGroupDecl)attGroup).getName());
        } else {
            this._atts.addAttribute("ref", CDATA, ((AttributeGroupReference)attGroup).getReference());
        }
        if (attGroup.getId() != null) {
            this._atts.addAttribute("id", CDATA, attGroup.getId());
        }
        this._handler.startElement(ELEM_ATTRIBUTE_GROUP, this._atts);
        this.processAnnotated(attGroup, schemaPrefix);
        if (!isReference) {
            AttributeGroupDecl group = (AttributeGroupDecl)attGroup;
            Enumeration enumeration = group.getLocalAttributes();
            while (enumeration.hasMoreElements()) {
                this.processAttribute((AttributeDecl)enumeration.nextElement(), schemaPrefix);
            }
            enumeration = group.getLocalAttributeGroupReferences();
            while (enumeration.hasMoreElements()) {
                this.processAttributeGroup((AttributeGroup)enumeration.nextElement(), schemaPrefix);
            }
            if (group.getAnyAttribute() != null) {
                this.processWildcard(group.getAnyAttribute(), schemaPrefix);
            }
        }
        this._handler.endElement(ELEM_ATTRIBUTE_GROUP);
    }

    private void processComplexType(ComplexType complexType, String schemaPrefix) throws SAXException {
        String ELEMENT_NAME = schemaPrefix + COMPLEX_TYPE;
        this._atts.clear();
        if (complexType.isTopLevel()) {
            this._atts.addAttribute(ATTR_NAME, CDATA, complexType.getName());
            if (complexType.isAbstract()) {
                this._atts.addAttribute("abstract", CDATA, VALUE_TRUE);
            }
            if (complexType.getBlock() != null) {
                this._atts.addAttribute("block", CDATA, complexType.getBlock().toString());
            }
            if (complexType.getFinal() != null) {
                this._atts.addAttribute("final", CDATA, complexType.getFinal().toString());
            }
        }
        if (complexType.getId() != null) {
            this._atts.addAttribute("id", CDATA, complexType.getId());
        }
        if (complexType.getContentType() == ContentType.mixed) {
            this._atts.addAttribute("mixed", CDATA, VALUE_TRUE);
        }
        this._handler.startElement(ELEMENT_NAME, this._atts);
        this.processAnnotated(complexType, schemaPrefix);
        String ELEM_CONTENT = null;
        String ELEM_DERIVATION = null;
        XMLType baseType = complexType.getBaseType();
        if (baseType != null) {
            ELEM_CONTENT = complexType.isSimpleContent() ? schemaPrefix + "simpleContent" : schemaPrefix + "complexContent";
            this._atts.clear();
            if (complexType.isComplexContent() && complexType.getContentType() == ContentType.mixed) {
                this._atts.addAttribute("mixed", CDATA, VALUE_TRUE);
            }
            this._handler.startElement(ELEM_CONTENT, this._atts);
            ELEM_DERIVATION = schemaPrefix + complexType.getDerivationMethod();
            Object baseTypeName = baseType.getName();
            if (complexType.isSimpleContent()) {
                if (baseType.isSimpleType()) {
                    SimpleType simpleType = (SimpleType)baseType;
                    if (((String)baseTypeName).indexOf(58) < 0) {
                        if (simpleType.isBuiltInType()) {
                            baseTypeName = schemaPrefix + (String)baseTypeName;
                        } else {
                            String targetNamespace = simpleType.getSchema().getTargetNamespace();
                            String prefix = this.getNSPrefix(complexType.getSchema(), targetNamespace);
                            if (prefix != null && prefix.length() > 0) {
                                baseTypeName = prefix + ":" + (String)baseTypeName;
                            }
                        }
                    }
                }
            } else if (complexType.isComplexContent() && baseType.isAnyType() && ((String)baseTypeName).indexOf(58) < 0) {
                baseTypeName = schemaPrefix + (String)baseTypeName;
            }
            if (baseType.isComplexType()) {
                String targetNamespace = baseType.getSchema().getTargetNamespace();
                if (targetNamespace == null) {
                    if (complexType.isRedefined()) {
                        targetNamespace = complexType.getSchema().getTargetNamespace();
                    }
                } else {
                    String nsPrefix = this.getNSPrefix(complexType.getSchema(), targetNamespace);
                    if (nsPrefix != null && nsPrefix.length() != 0) {
                        baseTypeName = nsPrefix + ":" + (String)baseTypeName;
                    }
                    targetNamespace = null;
                    nsPrefix = null;
                }
            }
            this._atts.clear();
            this._atts.addAttribute("base", CDATA, (String)baseTypeName);
            this._handler.startElement(ELEM_DERIVATION, this._atts);
            if (complexType.isSimpleContent() && complexType.isRestricted() && complexType.getContentType().getType() == 4) {
                SimpleContent simpleContent = (SimpleContent)complexType.getContentType();
                SimpleType simpleType = simpleContent.getSimpleType();
                Enumeration enumeration = simpleType.getLocalFacets();
                while (enumeration.hasMoreElements()) {
                    Facet facet = (Facet)enumeration.nextElement();
                    this._atts.clear();
                    this._atts.addAttribute(ATTR_VALUE, CDATA, facet.getValue());
                    String facetName = schemaPrefix + facet.getName();
                    this._handler.startElement(facetName, this._atts);
                    Enumeration annotations = facet.getAnnotations();
                    while (annotations.hasMoreElements()) {
                        Annotation annotation = (Annotation)annotations.nextElement();
                        this.processAnnotation(annotation, schemaPrefix);
                    }
                    this._handler.endElement(facetName);
                }
                enumeration = null;
                simpleType = null;
            }
        }
        this.processContentModelGroup(complexType, schemaPrefix);
        Enumeration enumeration = complexType.getLocalAttributeDecls();
        while (enumeration.hasMoreElements()) {
            this.processAttribute((AttributeDecl)enumeration.nextElement(), schemaPrefix);
        }
        enumeration = complexType.getAttributeGroupReferences();
        while (enumeration.hasMoreElements()) {
            this.processAttributeGroup((AttributeGroup)enumeration.nextElement(), schemaPrefix);
        }
        if (baseType != null) {
            this._handler.endElement(ELEM_DERIVATION);
            this._handler.endElement(ELEM_CONTENT);
        }
        this._handler.endElement(ELEMENT_NAME);
    }

    private void processContentModelGroup(ContentModelGroup contentModel, String schemaPrefix) throws SAXException {
        Enumeration enumeration = contentModel.enumerate();
        while (enumeration.hasMoreElements()) {
            Structure structure = (Structure)enumeration.nextElement();
            switch (structure.getStructureType()) {
                case 8: {
                    this.processElement((ElementDecl)structure, schemaPrefix);
                    break;
                }
                case 10: 
                case 16: {
                    this.processGroup((Group)structure, schemaPrefix);
                    break;
                }
                case 24: {
                    this.processWildcard((Wildcard)structure, schemaPrefix);
                    break;
                }
            }
        }
    }

    private void processElement(ElementDecl element, String schemaPrefix) throws SAXException {
        Form form;
        XMLType type;
        String ELEMENT_NAME = schemaPrefix + ELEMENT;
        this._atts.clear();
        Object value = element.getName();
        if (value != null) {
            if (element.isReference()) {
                String targetNamespace = element.getReference().getSchema().getTargetNamespace();
                String nsPrefix = this.getNSPrefix(element.getSchema(), targetNamespace);
                if (nsPrefix != null && nsPrefix.length() != 0) {
                    value = nsPrefix + ":" + (String)value;
                }
                targetNamespace = null;
                nsPrefix = null;
                this._atts.addAttribute("ref", CDATA, (String)value);
            } else {
                this._atts.addAttribute(ATTR_NAME, CDATA, (String)value);
            }
        }
        int max = element.getMaxOccurs();
        int min = element.getMinOccurs();
        if (min != 1) {
            this._atts.addAttribute("minOccurs", CDATA, Integer.toString(min));
        }
        if (max < 0) {
            this._atts.addAttribute("maxOccurs", CDATA, "unbounded");
        } else if (max != 1) {
            this._atts.addAttribute("maxOccurs", CDATA, Integer.toString(max));
        }
        boolean hasAnonymousType = false;
        if (!element.isReference() && (type = element.getType()) != null) {
            if (type.getName() == null) {
                hasAnonymousType = true;
            } else if (type.isSimpleType() && ((SimpleType)type).isBuiltInType()) {
                this._atts.addAttribute(ATTR_TYPE, CDATA, schemaPrefix + type.getName());
            } else if (type.getStructureType() == 0) {
                this._atts.addAttribute(ATTR_TYPE, CDATA, schemaPrefix + type.getName());
            } else if (this.isImportedType(type, element)) {
                String namespace = type.getSchema().getTargetNamespace();
                Object prefix = this.getNSPrefix(element.getSchema(), namespace);
                if (prefix == null) {
                    prefix = schemaPrefix + "2";
                    this._atts.addAttribute(XMLNS_PREFIX + (String)prefix, CDATA, namespace);
                }
                this._atts.addAttribute(ATTR_TYPE, CDATA, (String)prefix + ":" + type.getName());
            } else {
                Object typeName = type.getName();
                String targetNamespace = element.getSchema().getTargetNamespace();
                if (targetNamespace != null) {
                    String nsPrefix = this.getNSPrefix(element.getSchema(), targetNamespace);
                    if (nsPrefix != null && nsPrefix.length() != 0) {
                        typeName = nsPrefix + ":" + (String)typeName;
                    }
                    targetNamespace = null;
                    nsPrefix = null;
                }
                this._atts.addAttribute(ATTR_TYPE, CDATA, (String)typeName);
            }
        }
        if (element.isAbstract()) {
            this._atts.addAttribute("abstract", CDATA, VALUE_TRUE);
        }
        if (element.getBlock() != null) {
            this._atts.addAttribute("block", CDATA, element.getBlock().toString());
        }
        if (element.getDefaultValue() != null) {
            this._atts.addAttribute("default", CDATA, element.getDefaultValue());
        }
        if (element.getFixedValue() != null) {
            this._atts.addAttribute("fixed", CDATA, element.getFixedValue());
        }
        if (element.getFinal() != null) {
            this._atts.addAttribute("final", CDATA, element.getFinal().toString());
        }
        if ((form = element.getForm()) != null) {
            this._atts.addAttribute("form", CDATA, form.toString());
        }
        if (element.getId() != null) {
            this._atts.addAttribute("id", CDATA, element.getId());
        }
        if (element.isNillable()) {
            this._atts.addAttribute("nillable", CDATA, VALUE_TRUE);
        }
        if (element.getSubstitutionGroup() != null) {
            this._atts.addAttribute("substitutionGroup", CDATA, element.getSubstitutionGroup());
        }
        this._handler.startElement(ELEMENT_NAME, this._atts);
        this.processAnnotated(element, schemaPrefix);
        if (hasAnonymousType) {
            XMLType type2 = element.getType();
            if (type2.isComplexType()) {
                this.processComplexType((ComplexType)type2, schemaPrefix);
            } else if (type2.isSimpleType()) {
                this.processSimpleType((SimpleType)type2, schemaPrefix);
            }
        }
        Enumeration enumeration = element.getIdentityConstraints();
        while (enumeration.hasMoreElements()) {
            this.processIdentityConstraint((IdentityConstraint)enumeration.nextElement(), schemaPrefix);
        }
        this._handler.endElement(ELEMENT_NAME);
    }

    private void processGroup(Group group, String schemaPrefix) throws SAXException {
        Object ELEMENT_NAME = schemaPrefix;
        Object reference = null;
        if (group instanceof ModelGroup) {
            ModelGroup refGroup;
            ELEMENT_NAME = (String)ELEMENT_NAME + GROUP;
            ModelGroup mGroup = (ModelGroup)group;
            if (mGroup.hasReference() && (refGroup = mGroup.getReference()) != null) {
                String prefix;
                reference = refGroup.getName();
                String namespace = refGroup.getSchema().getTargetNamespace();
                if (namespace == null) {
                    namespace = "";
                }
                if ((prefix = this.getNSPrefix(mGroup.getSchema(), namespace)) != null && prefix.length() > 0) {
                    reference = prefix + ":" + (String)reference;
                }
            }
        } else {
            ELEMENT_NAME = (String)ELEMENT_NAME + group.getOrder().toString();
        }
        this._atts.clear();
        if (group.getId() != null) {
            this._atts.addAttribute("id", CDATA, group.getId());
        }
        if (reference != null) {
            this._atts.addAttribute("ref", CDATA, (String)reference);
        } else if (group.getName() != null) {
            this._atts.addAttribute(ATTR_NAME, CDATA, group.getName());
        }
        int max = group.getMaxOccurs();
        int min = group.getMinOccurs();
        if (min != 1) {
            this._atts.addAttribute("minOccurs", CDATA, Integer.toString(min));
        }
        if (max < 0) {
            this._atts.addAttribute("maxOccurs", CDATA, "unbounded");
        } else if (max != 1) {
            this._atts.addAttribute("maxOccurs", CDATA, Integer.toString(max));
        }
        this._handler.startElement((String)ELEMENT_NAME, this._atts);
        this.processAnnotated(group, schemaPrefix);
        if (reference == null) {
            this.processContentModelGroup(group, schemaPrefix);
        }
        this._handler.endElement((String)ELEMENT_NAME);
    }

    private void processIdentityConstraint(IdentityConstraint constraint, String schemaPrefix) throws SAXException {
        if (constraint == null) {
            return;
        }
        Object ELEMENT_NAME = schemaPrefix;
        String name = null;
        String id = null;
        String refer = null;
        switch (constraint.getStructureType()) {
            case 14: {
                ELEMENT_NAME = (String)ELEMENT_NAME + "keyref";
                refer = ((KeyRef)constraint).getRefer();
                break;
            }
            case 23: {
                ELEMENT_NAME = (String)ELEMENT_NAME + "unique";
                break;
            }
            default: {
                ELEMENT_NAME = (String)ELEMENT_NAME + "key";
            }
        }
        name = constraint.getName();
        id = constraint.getId();
        this._atts.clear();
        this._atts.addAttribute(ATTR_NAME, CDATA, constraint.getName());
        if (id != null) {
            this._atts.addAttribute("id", CDATA, id);
        }
        if (refer != null) {
            this._atts.addAttribute("refer", CDATA, refer);
        }
        this._handler.startElement((String)ELEMENT_NAME, this._atts);
        this.processAnnotated(constraint, schemaPrefix);
        String ELEM_SELECTOR = schemaPrefix + "selector";
        String xpath = null;
        IdentitySelector selector = constraint.getSelector();
        xpath = selector.getXPath();
        id = selector.getId();
        this._atts.clear();
        this._atts.addAttribute("xpath", CDATA, xpath);
        if (id != null) {
            this._atts.addAttribute("id", CDATA, id);
        }
        this._handler.startElement(ELEM_SELECTOR, this._atts);
        this.processAnnotated(selector, schemaPrefix);
        this._handler.endElement(ELEM_SELECTOR);
        String ELEM_FIELD = schemaPrefix + "field";
        Enumeration enumeration = constraint.getFields();
        while (enumeration.hasMoreElements()) {
            IdentityField field = (IdentityField)enumeration.nextElement();
            this._atts.clear();
            id = field.getId();
            xpath = field.getXPath();
            this._atts.addAttribute("xpath", CDATA, xpath);
            if (id != null) {
                this._atts.addAttribute("id", CDATA, id);
            }
            this._handler.startElement(ELEM_FIELD, this._atts);
            this.processAnnotated(field, schemaPrefix);
            this._handler.endElement(ELEM_FIELD);
        }
        this._handler.endElement((String)ELEMENT_NAME);
    }

    private void processSchema(Schema schema) throws SAXException {
        Schema tempSchema;
        Enumeration includedSchemas;
        FinalList finalList;
        BlockList blockList;
        Form form;
        Object schemaPrefix = this.getNSPrefix(schema, schema.getSchemaNamespace());
        if (schemaPrefix == null) {
            schemaPrefix = DEFAULT_PREFIX;
        }
        this._atts.clear();
        if (((String)schemaPrefix).length() == 0) {
            this._atts.addAttribute(XMLNS_DEFAULT, CDATA, schema.getSchemaNamespace());
        } else {
            this._atts.addAttribute(XMLNS_PREFIX + (String)schemaPrefix, CDATA, schema.getSchemaNamespace());
        }
        Namespaces namespaces = schema.getNamespaces();
        Enumeration keys = namespaces.getLocalNamespacePrefixes();
        while (keys.hasMoreElements()) {
            String nsPrefix = (String)keys.nextElement();
            if (nsPrefix.equals(schemaPrefix)) continue;
            String ns = namespaces.getNamespaceURI(nsPrefix);
            if (nsPrefix.length() > 0) {
                this._atts.addAttribute(XMLNS_PREFIX + nsPrefix, CDATA, ns);
                continue;
            }
            this._atts.addAttribute(XMLNS_DEFAULT, CDATA, ns);
        }
        String value = schema.getTargetNamespace();
        if (value != null) {
            this._atts.addAttribute("targetNamespace", CDATA, value);
        }
        if ((form = schema.getAttributeFormDefault()) != null) {
            this._atts.addAttribute("attributeFormDefault", CDATA, form.toString());
        }
        if ((form = schema.getElementFormDefault()) != null) {
            this._atts.addAttribute("elementFormDefault", CDATA, form.toString());
        }
        if ((blockList = schema.getBlockDefault()) != null) {
            this._atts.addAttribute("blockDefault", CDATA, blockList.toString());
        }
        if ((finalList = schema.getFinalDefault()) != null) {
            this._atts.addAttribute("finalDefault", CDATA, finalList.toString());
        }
        if (schema.getVersion() != null) {
            this._atts.addAttribute("version", CDATA, schema.getVersion());
        }
        if (((String)schemaPrefix).length() > 0) {
            schemaPrefix = (String)schemaPrefix + ":";
        }
        this._handler.startDocument();
        String ELEM_SCHEMA = (String)schemaPrefix + SCHEMA;
        this._handler.startElement(ELEM_SCHEMA, this._atts);
        this.processAnnotated(schema, (String)schemaPrefix);
        Enumeration enumeration = null;
        enumeration = schema.getImportedSchema();
        while (enumeration.hasMoreElements()) {
            this.processImport((Schema)enumeration.nextElement(), (String)schemaPrefix);
        }
        enumeration = schema.getCachedIncludedSchemas();
        while (enumeration.hasMoreElements()) {
            this.processIncludedSchema((Schema)enumeration.nextElement(), (String)schemaPrefix);
        }
        enumeration = schema.getRedefineSchema();
        while (enumeration.hasMoreElements()) {
            this.processRedefinition((RedefineSchema)enumeration.nextElement(), schema, (String)schemaPrefix);
        }
        enumeration = schema.getAttributeGroups();
        while (enumeration.hasMoreElements()) {
            boolean found = false;
            AttributeGroup temp = (AttributeGroup)enumeration.nextElement();
            if (temp instanceof AttributeGroupDecl && ((AttributeGroupDecl)temp).isRedefined()) {
                found = true;
            }
            includedSchemas = schema.getCachedIncludedSchemas();
            while (includedSchemas.hasMoreElements()) {
                tempSchema = (Schema)includedSchemas.nextElement();
                if (!(temp instanceof AttributeGroupDecl)) continue;
                String name = ((AttributeGroupDecl)temp).getName();
                found = tempSchema.getAttributeGroup(name) != null;
            }
            if (found) continue;
            this.processAttributeGroup(temp, (String)schemaPrefix);
        }
        enumeration = schema.getAttributes();
        while (enumeration.hasMoreElements()) {
            AttributeDecl temp = (AttributeDecl)enumeration.nextElement();
            boolean found = false;
            includedSchemas = schema.getCachedIncludedSchemas();
            while (includedSchemas.hasMoreElements()) {
                tempSchema = (Schema)includedSchemas.nextElement();
                found = tempSchema.getAttribute(temp.getName()) != null;
            }
            if (found) continue;
            this.processAttribute(temp, (String)schemaPrefix);
        }
        enumeration = schema.getElementDecls();
        while (enumeration.hasMoreElements()) {
            ElementDecl temp = (ElementDecl)enumeration.nextElement();
            boolean found = false;
            includedSchemas = schema.getCachedIncludedSchemas();
            while (includedSchemas.hasMoreElements()) {
                tempSchema = (Schema)includedSchemas.nextElement();
                found = tempSchema.getElementDecl(temp.getName()) != null;
            }
            if (found) continue;
            this.processElement(temp, (String)schemaPrefix);
        }
        enumeration = schema.getComplexTypes();
        while (enumeration.hasMoreElements()) {
            ComplexType temp = (ComplexType)enumeration.nextElement();
            boolean found = false;
            includedSchemas = schema.getCachedIncludedSchemas();
            while (includedSchemas.hasMoreElements()) {
                tempSchema = (Schema)includedSchemas.nextElement();
                found = tempSchema.getComplexType(temp.getName()) != null;
            }
            if (temp.isRedefined() || found) continue;
            this.processComplexType(temp, (String)schemaPrefix);
        }
        enumeration = schema.getModelGroups();
        while (enumeration.hasMoreElements()) {
            ModelGroup temp = (ModelGroup)enumeration.nextElement();
            boolean found = false;
            includedSchemas = schema.getCachedIncludedSchemas();
            while (includedSchemas.hasMoreElements()) {
                tempSchema = (Schema)includedSchemas.nextElement();
                found = tempSchema.getModelGroup(temp.getName()) != null;
            }
            if (temp.isRedefined() || found) continue;
            this.processGroup(temp, (String)schemaPrefix);
        }
        enumeration = schema.getSimpleTypes();
        while (enumeration.hasMoreElements()) {
            SimpleType temp = (SimpleType)enumeration.nextElement();
            boolean found = false;
            includedSchemas = schema.getCachedIncludedSchemas();
            while (includedSchemas.hasMoreElements()) {
                tempSchema = (Schema)includedSchemas.nextElement();
                found = tempSchema.getSimpleType(temp.getName()) != null;
            }
            if (temp.isRedefined() || found) continue;
            this.processSimpleType(temp, (String)schemaPrefix);
        }
        this._handler.endElement(ELEM_SCHEMA);
        this._handler.endDocument();
    }

    private void processWildcard(Wildcard wildcard, String schemaPrefix) throws SAXException {
        String ELEMENT_NAME = null;
        ELEMENT_NAME = wildcard.isAttributeWildcard() ? schemaPrefix + "anyAttribute" : schemaPrefix + "any";
        this._atts.clear();
        StringBuffer namespace = new StringBuffer();
        Enumeration enumeration = wildcard.getNamespaces();
        while (enumeration.hasMoreElements()) {
            if (namespace.length() > 0) {
                namespace.append(' ');
            }
            namespace.append(enumeration.nextElement().toString());
        }
        if (namespace.length() > 0) {
            this._atts.addAttribute("namespace", CDATA, namespace.toString());
        }
        int max = wildcard.getMaxOccurs();
        int min = wildcard.getMinOccurs();
        if (min != 1) {
            this._atts.addAttribute("minOccurs", CDATA, Integer.toString(min));
        }
        if (max < 0) {
            this._atts.addAttribute("maxOccurs", CDATA, "unbounded");
        } else if (max != 1) {
            this._atts.addAttribute("maxOccurs", CDATA, Integer.toString(max));
        }
        String value = wildcard.getProcessContent();
        if (value != null) {
            this._atts.addAttribute("processContents", CDATA, value);
        }
        this._handler.startElement(ELEMENT_NAME, this._atts);
        this.processAnnotated(wildcard, schemaPrefix);
        this._handler.endElement(ELEMENT_NAME);
    }

    private void processImport(Schema schema, String schemaPrefix) throws SAXException {
        String ELEMENT_NAME = schemaPrefix + "import";
        this._atts.clear();
        String namespace = schema.getTargetNamespace();
        String schemaLoc = schema.getSchemaLocation();
        this._atts.addAttribute("namespace", null, namespace);
        this._atts.addAttribute("schemaLocation", null, schemaLoc);
        this._handler.startElement(ELEMENT_NAME, this._atts);
        this._handler.endElement(ELEMENT_NAME);
    }

    private void processIncludedSchema(Schema schema, String schemaPrefix) throws SAXException {
        String ELEMENT_NAME = schemaPrefix + "include";
        this._atts.clear();
        String schemaLoc = schema.getSchemaLocation();
        this._atts.addAttribute("schemaLocation", null, schemaLoc);
        this._handler.startElement(ELEMENT_NAME, this._atts);
        this._handler.endElement(ELEMENT_NAME);
    }

    private void processRedefinition(RedefineSchema schema, Schema parentSchema, String schemaPrefix) throws SAXException {
        String ELEMENT_NAME = schemaPrefix + "redefine";
        this._atts.clear();
        String schemaLoc = schema.getSchemaLocation();
        if (schemaLoc != "") {
            this._atts.addAttribute("schemaLocation", null, schemaLoc);
        }
        this._handler.startElement(ELEMENT_NAME, this._atts);
        this.processAnnotated(schema, schemaPrefix);
        if (schemaLoc != "") {
            XMLType type;
            Enumeration enumeration = null;
            enumeration = schema.enumerateComplexTypes();
            while (enumeration.hasMoreElements()) {
                type = (ComplexType)enumeration.nextElement();
                this.processComplexType((ComplexType)type, schemaPrefix);
            }
            enumeration = schema.enumerateSimpleTypes();
            while (enumeration.hasMoreElements()) {
                type = (SimpleType)enumeration.nextElement();
                this.processSimpleType((SimpleType)type, schemaPrefix);
            }
            enumeration = schema.enumerateGroups();
            while (enumeration.hasMoreElements()) {
                ModelGroup group = (ModelGroup)enumeration.nextElement();
                this.processGroup(group, schemaPrefix);
            }
            enumeration = schema.enumerateAttributeGroups();
            while (enumeration.hasMoreElements()) {
                AttributeGroupDecl attGroup = (AttributeGroupDecl)enumeration.nextElement();
                this.processAttributeGroup(attGroup, schemaPrefix);
            }
        }
        this._handler.endElement(ELEMENT_NAME);
    }

    private void processSimpleType(SimpleType simpleType, String schemaPrefix) throws SAXException {
        if (simpleType.isBuiltInType()) {
            return;
        }
        String ELEMENT_NAME = schemaPrefix + SIMPLE_TYPE;
        this._atts.clear();
        String name = simpleType.getName();
        if (name != null) {
            this._atts.addAttribute(ATTR_NAME, CDATA, name);
        }
        if (simpleType.getFinal() != null) {
            this._atts.addAttribute("final", CDATA, simpleType.getFinal());
        }
        if (simpleType.getId() != null) {
            this._atts.addAttribute("id", CDATA, simpleType.getId());
        }
        this._handler.startElement(ELEMENT_NAME, this._atts);
        this.processAnnotated(simpleType, schemaPrefix);
        SimpleType base = (SimpleType)simpleType.getBaseType();
        boolean isRestriction = false;
        if (base != null) {
            isRestriction = simpleType instanceof ListType ? base instanceof ListType : true;
        }
        if (isRestriction) {
            String ELEM_RESTRICTION = schemaPrefix + RESTRICTION;
            this._atts.clear();
            Object typeName = base.getName();
            if (((String)typeName).indexOf(58) < 0) {
                if (base.isBuiltInType()) {
                    typeName = schemaPrefix + (String)typeName;
                } else {
                    String targetNamespace = base.getSchema().getTargetNamespace();
                    String prefix = this.getNSPrefix(simpleType.getSchema(), targetNamespace);
                    if (prefix != null && prefix.length() > 0) {
                        typeName = prefix + ":" + (String)typeName;
                    }
                }
            }
            this._atts.addAttribute("base", CDATA, (String)typeName);
            this._handler.startElement(ELEM_RESTRICTION, this._atts);
            Enumeration enumeration = simpleType.getLocalFacets();
            while (enumeration.hasMoreElements()) {
                Facet facet = (Facet)enumeration.nextElement();
                this._atts.clear();
                this._atts.addAttribute(ATTR_VALUE, CDATA, facet.getValue());
                String facetName = schemaPrefix + facet.getName();
                this._handler.startElement(facetName, this._atts);
                Enumeration annotations = facet.getAnnotations();
                while (annotations.hasMoreElements()) {
                    Annotation annotation = (Annotation)annotations.nextElement();
                    this.processAnnotation(annotation, schemaPrefix);
                }
                this._handler.endElement(facetName);
            }
            this._handler.endElement(ELEM_RESTRICTION);
        } else if (simpleType instanceof Union) {
            this.processUnion((Union)simpleType, schemaPrefix);
        } else {
            boolean topLevel;
            String ELEM_LIST = schemaPrefix + "list";
            this._atts.clear();
            SimpleType itemType = ((ListType)simpleType).getItemType();
            boolean bl = topLevel = itemType.getParent() == itemType.getSchema();
            if (itemType.isBuiltInType() || topLevel) {
                Object typeName = itemType.getName();
                if (((String)typeName).indexOf(58) < 0 && itemType.isBuiltInType()) {
                    typeName = schemaPrefix + (String)typeName;
                }
                this._atts.addAttribute("itemType", CDATA, (String)typeName);
            }
            this._handler.startElement(ELEM_LIST, this._atts);
            Annotation ann = ((ListType)simpleType).getLocalAnnotation();
            if (ann != null) {
                this.processAnnotation(ann, schemaPrefix);
            }
            if (!topLevel && !itemType.isBuiltInType()) {
                this.processSimpleType(itemType, schemaPrefix);
            }
            this._handler.endElement(ELEM_LIST);
        }
        this._handler.endElement(ELEMENT_NAME);
    }

    private void processUnion(Union union, String schemaPrefix) throws SAXException {
        String ELEMENT_NAME = schemaPrefix + "union";
        this._atts.clear();
        if (union.getId() != null) {
            this._atts.addAttribute("id", CDATA, union.getId());
        }
        StringBuffer memberTypes = new StringBuffer();
        Enumeration enumeration = union.getMemberTypes();
        while (enumeration.hasMoreElements()) {
            SimpleType simpleType = (SimpleType)enumeration.nextElement();
            if (simpleType.getParent() != union.getSchema()) continue;
            if (memberTypes.length() > 0) {
                memberTypes.append(' ');
            }
            memberTypes.append(simpleType.getName());
        }
        if (memberTypes.length() > 0) {
            this._atts.addAttribute("memberTypes", CDATA, memberTypes.toString());
        }
        this._handler.startElement(ELEMENT_NAME, this._atts);
        Annotation annotation = union.getLocalAnnotation();
        if (annotation != null) {
            this.processAnnotation(annotation, schemaPrefix);
        }
        enumeration = union.getMemberTypes();
        while (enumeration.hasMoreElements()) {
            SimpleType simpleType = (SimpleType)enumeration.nextElement();
            if (simpleType.getParent() == union.getSchema()) continue;
            this.processSimpleType(simpleType, schemaPrefix);
        }
        this._handler.endElement(ELEMENT_NAME);
    }

    private boolean isImportedType(XMLType type, ElementDecl element) {
        String targetNS = type.getSchema().getTargetNamespace();
        if (targetNS != null) {
            return element.getSchema().getImportedSchema(targetNS) != null;
        }
        return false;
    }

    private String getNSPrefix(Schema schema, String namespace) {
        if (namespace == null) {
            namespace = "";
        }
        return schema.getNamespaces().getNamespacePrefix(namespace);
    }
}

