/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.GroupUnmarshaller;

public class ModelGroupUnmarshaller
extends ComponentReader {
    private static final int MODEL_GROUP = 1;
    private static final String MAX_OCCURS_WILDCARD = "unbounded";
    private ComponentReader unmarshaller;
    private int depth = 0;
    private ModelGroup _group = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;

    public ModelGroupUnmarshaller(Schema schema, AttributeSet atts, Resolver resolver) {
        this.setResolver(resolver);
        this._schema = schema;
        this._group = new ModelGroup(this._schema);
        String attValue = null;
        this._group.setName(atts.getValue("name"));
        attValue = atts.getValue("maxOccurs");
        if (attValue != null) {
            if (this._group.getName() != null) {
                throw new IllegalArgumentException("In <group>: " + this._group.getName() + "'maxOccurs' cannot appear in a named <group>");
            }
            if (MAX_OCCURS_WILDCARD.equals(attValue)) {
                attValue = "-1";
            }
            int maxOccurs = ModelGroupUnmarshaller.toInt(attValue);
            this._group.setMaxOccurs(maxOccurs);
        }
        if ((attValue = atts.getValue("minOccurs")) != null) {
            if (this._group.getName() != null) {
                throw new IllegalArgumentException("In <group>: " + this._group.getName() + ", 'minOccurs' cannot appear in a named <group>");
            }
            this._group.setMinOccurs(ModelGroupUnmarshaller.toInt(attValue));
        }
        if ((attValue = atts.getValue("ref")) != null) {
            if (this._group.getName() != null) {
                throw new IllegalArgumentException("In <group>: " + this._group.getName() + ", 'ref' cannot appear in a named <group>");
            }
            this._group.setReference(attValue);
        }
        attValue = atts.getValue("id");
        this._group.setId(attValue);
    }

    public ModelGroup getGroup() {
        return this._group;
    }

    @Override
    public Object getObject() {
        return this.getGroup();
    }

    @Override
    public String elementName() {
        return "group";
    }

    @Override
    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if ("annotation".equals(name)) {
            if (this.foundAnnotation) {
                this.error("Only one (1) 'annotation' is allowed as a child of element definitions.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(atts);
        } else if (SchemaNames.isGroupName(name)) {
            this.unmarshaller = new GroupUnmarshaller(this._schema, name, atts, this.getResolver());
        } else {
            StringBuffer err = new StringBuffer("illegal element <");
            err.append(name);
            err.append("> found in <group>.");
            throw new SchemaException(err.toString());
        }
    }

    @Override
    public void endElement(String name, String namespace) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        if (this.unmarshaller != null && !name.equals(this.unmarshaller.elementName())) {
            Object err = "missing end element for ";
            err = (String)err + this.unmarshaller.elementName();
            throw new SchemaException((String)err);
        }
        if ("annotation".equals(name)) {
            Annotation ann = (Annotation)this.unmarshaller.getObject();
            this._group.addAnnotation(ann);
        } else if (SchemaNames.isGroupName(name)) {
            Group group = ((GroupUnmarshaller)this.unmarshaller).getGroup();
            this._group.addGroup(group);
        }
        this.unmarshaller.finish();
        this.unmarshaller = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }
}

