/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComplexContentRestrictionUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.ExtensionUnmarshaller;

public class ComplexContentUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private ComplexType _complexType = null;
    private boolean foundAnnotation = false;
    private boolean foundExtension = false;
    private boolean foundRestriction = false;

    public ComplexContentUnmarshaller(ComplexType complexType, AttributeSet atts, Resolver resolver) throws XMLException {
        this._complexType = complexType;
        String content = atts.getValue("mixed");
        if (content != null) {
            if (content.equals("true")) {
                this._complexType.setContentType(ContentType.valueOf("mixed"));
            }
            if (content.equals("false")) {
                this._complexType.setContentType(ContentType.valueOf("elementOnly"));
            }
        }
    }

    @Override
    public String elementName() {
        return "complexContent";
    }

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if ("extension".equals(name)) {
            if (this.foundExtension) {
                this.error("Only (1) 'extension' element may appear as a child of 'complexContent' elements.");
            }
            if (this.foundRestriction) {
                this.error("Both 'extension' and 'restriction' elements may not appear as children of the same complexContent definition.");
            }
            this.foundExtension = true;
            ExtensionUnmarshaller extension = new ExtensionUnmarshaller(this._complexType, atts, this.getResolver());
            this.unmarshaller = extension;
        } else if ("restriction".equals(name)) {
            if (this.foundRestriction) {
                this.error("Only (1) 'restriction' element may appear as a child of 'complexContent' elements.");
            }
            if (this.foundExtension) {
                this.error("Both 'extension' and 'restriction' elements may not appear as children of the same complexContent definition.");
            }
            this.foundRestriction = true;
            this.unmarshaller = new ComplexContentRestrictionUnmarshaller(this._complexType, atts, this.getResolver());
        } else if (name.equals("annotation")) {
            if (this.foundAnnotation) {
                this.error("Only (1) 'annotation' element may appear as a child of 'complexContent' elements.");
            }
            if (this.foundRestriction || this.foundExtension) {
                this.error("An 'annotation' may only appear as the first child of a 'complexContent' element.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(atts);
        } else {
            this.illegalElement(name);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    @Override
    public void endElement(String name, String namespace) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(name)) {
            Annotation ann = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._complexType.addAnnotation(ann);
        }
        this.unmarshaller = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }
}

