/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.AnyType;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;

class TypeReference
extends XMLType {
    private XMLType referredType = null;

    TypeReference() {
    }

    @Override
    XMLType getType() {
        if (this.referredType == null) {
            this.resolveTypeReference();
        }
        return this.referredType;
    }

    void resolveTypeReference() {
        String name = this.getName();
        if (name == null) {
            return;
        }
        Schema schema = this.getSchema();
        if (schema == null) {
            String error = "Schema is null. Reference  cannot be resolved.";
            throw new IllegalStateException(error);
        }
        String canonicalName = name;
        String nsPrefix = "";
        int colon = name.indexOf(58);
        if (colon >= 0) {
            canonicalName = name.substring(colon + 1);
            nsPrefix = name.substring(0, colon);
        }
        String ns = schema.getNamespace(nsPrefix);
        if (schema.getSchemaNamespace().equals(ns) && canonicalName.equals("anyType")) {
            this.referredType = new AnyType(schema);
            return;
        }
        IllegalArgumentException exception = null;
        try {
            this.referredType = this.getSchema().getSimpleType(this.getName());
        }
        catch (IllegalArgumentException iax) {
            exception = iax;
        }
        if (this.referredType != null) {
            return;
        }
        this.referredType = this.getSchema().getComplexType(this.getName());
        if (this.referredType != null) {
            return;
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    protected void setParent(Structure parent) {
    }

    @Override
    public short getStructureType() {
        return -1;
    }

    @Override
    public void validate() throws ValidationException {
    }
}

