/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.dtd;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import org.exolab.castor.xml.dtd.Attribute;
import org.exolab.castor.xml.dtd.ContentParticle;
import org.exolab.castor.xml.dtd.DTDException;
import org.exolab.castor.xml.dtd.DTDdocument;
import org.exolab.castor.xml.dtd.Element;
import org.exolab.castor.xml.dtd.GeneralEntity;
import org.exolab.castor.xml.dtd.Notation;
import org.exolab.castor.xml.dtd.parser.DTDInitialParser;
import org.exolab.castor.xml.dtd.parser.DTDParser;
import org.exolab.castor.xml.dtd.parser.InputCharStream;
import org.exolab.castor.xml.dtd.parser.ParseException;
import org.exolab.castor.xml.dtd.parser.TokenMgrError;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.writer.SchemaWriter;
import org.xml.sax.SAXException;

public class Converter {
    public static void main(String[] args) throws IOException, DTDException, SchemaException, SAXException {
        if (args.length < 2 || args.length > 3) {
            Object s = "\nUsage:\n";
            s = (String)s + "java org.exolab.castor.xml.dtd.Converter dtd_file xsd_file [character_encoding]\n\n";
            s = (String)s + "dtd_file: name of the input DTD file\n";
            s = (String)s + "xsd_file: name of the output Schema file\n";
            s = (String)s + "character_encoding: name of the character encoding,\n";
            s = (String)s + "                    if not specified, ASCII is chosen\n";
            System.out.println((String)s);
        } else {
            String encoding = args.length == 2 ? "US-ASCII" : (args[2].equals("ascii") || args[2].equals("ASCII") || args[2].equals("us-ascii") ? "US-ASCII" : (args[2].equals("utf-8") ? "UTF-8" : (args[2].equals("utf-16") ? "UTF-16" : args[2])));
            FileInputStream inputStream = new FileInputStream(args[0]);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, encoding);
            FileOutputStream outputStream = new FileOutputStream(args[1]);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, encoding);
            Converter.convertDTDtoSchema(reader, writer);
            reader.close();
            writer.close();
        }
    }

    public static void convertDTDtoSchema(Reader reader, Writer writer) throws DTDException, SchemaException, IOException, SAXException {
        DTDdocument dtd = Converter.parseDTD(reader);
        Schema schema = Converter.convertDTDObjectToSchemaObject(dtd);
        Converter.marshalSchema(schema, writer);
    }

    public static DTDdocument parseDTD(Reader reader) throws DTDException {
        try {
            InputCharStream charStream = new InputCharStream(reader);
            DTDInitialParser initialParser = new DTDInitialParser(charStream);
            String intermedResult = initialParser.Input();
            StringReader strReader = new StringReader(intermedResult);
            charStream = new InputCharStream(strReader);
            DTDParser parser = new DTDParser(charStream);
            DTDdocument dtd = parser.Input();
            strReader.close();
            return dtd;
        }
        catch (TokenMgrError tme) {
            String msg = tme.getMessage();
            throw new DTDException("TokenMgrError" + (String)(msg == null ? "" : ": " + msg));
        }
        catch (ParseException pe) {
            String msg = pe.getMessage();
            throw new DTDException("ParseException" + (String)(msg == null ? "" : ": " + msg));
        }
    }

    public static Schema convertDTDObjectToSchemaObject(DTDdocument dtd) throws DTDException, SchemaException {
        Schema schema = new Schema();
        String name = dtd.getName();
        if (name != null && !name.equals("")) {
            schema.setId(name);
        }
        Enumeration dtdNotations = dtd.getNotations();
        while (dtdNotations.hasMoreElements()) {
            Notation notation = (Notation)dtdNotations.nextElement();
        }
        Enumeration dtdGeneralEntities = dtd.getGeneralEntities();
        if (dtdGeneralEntities.hasMoreElements()) {
            Annotation annotation = new Annotation();
            while (dtdGeneralEntities.hasMoreElements()) {
                GeneralEntity ge = (GeneralEntity)dtdGeneralEntities.nextElement();
                Documentation documentation = new Documentation();
                String text = "General Entity Declaration";
                documentation.add(text);
                documentation.add(ge);
                annotation.addDocumentation(documentation);
            }
            schema.addAnnotation(annotation);
        }
        Enumeration dtdElements = dtd.getElements();
        while (dtdElements.hasMoreElements()) {
            Element dtdElement = (Element)dtdElements.nextElement();
            ElementDecl schemaElement = Converter.convertDTDElementToSchemaElement(dtdElement, schema);
            schema.addElementDecl(schemaElement);
        }
        return schema;
    }

    public static ElementDecl convertDTDElementToSchemaElement(Element dtdElement, Schema schema) throws DTDException, SchemaException {
        String name = dtdElement.getName();
        if (name == null || name.equals("")) {
            String err = "DTD to Schema converter: a DTD element has no name.";
            throw new DTDException(err);
        }
        ElementDecl schemaElement = new ElementDecl(schema, name);
        ComplexType complexType = schema.createComplexType();
        ContentType contentType = null;
        Group group = null;
        Iterator mixedChildrenIterator = null;
        String elementRef = null;
        ElementDecl elem = null;
        if (dtdElement.isEmptyContent()) {
            contentType = ContentType.elemOnly;
        } else if (dtdElement.isAnyContent()) {
            contentType = ContentType.mixed;
            group = new Group();
            group.setOrder(Order.seq);
            group.setMinOccurs(0);
            group.setMaxOccurs(-1);
            Wildcard any = new Wildcard(group);
            group.addWildcard(any);
            complexType.addGroup(group);
        } else if (dtdElement.isElemOnlyContent()) {
            contentType = ContentType.elemOnly;
            ContentParticle dtdContent = dtdElement.getContent();
            if (dtdContent == null) {
                String err = "DTD to Schema converter: element \"" + dtdElement.getName();
                err = err + "\" has no content.";
                throw new DTDException(err);
            }
            Particle content = null;
            try {
                content = Converter.convertContentParticle(dtdContent, schema);
            }
            catch (DTDException e) {
                String err = "DTD to Schema converter: content of DTD element \"" + dtdElement.getName();
                err = err + "\", represented by a Content Particle, is malformed.";
                throw new DTDException(err);
            }
            if (content instanceof ElementDecl) {
                group = new Group();
                group.setOrder(Order.seq);
                group.addElementDecl((ElementDecl)content);
                complexType.addGroup(group);
            } else {
                complexType.addGroup((Group)content);
            }
        } else if (dtdElement.isMixedContent()) {
            contentType = ContentType.mixed;
            mixedChildrenIterator = dtdElement.getMixedContentChildren();
            if (mixedChildrenIterator != null && mixedChildrenIterator.hasNext()) {
                group = new Group();
                group.setOrder(Order.choice);
                group.setMinOccurs(0);
                group.setMaxOccurs(-1);
                while (mixedChildrenIterator.hasNext()) {
                    elementRef = (String)mixedChildrenIterator.next();
                    elem = new ElementDecl(schema);
                    elem.setReference(elementRef);
                    group.addElementDecl(elem);
                }
                complexType.addGroup(group);
            }
        } else {
            String err = "DTD to Schema converter: content type of DTD element \"" + dtdElement.getName();
            err = err + "\" has not been specified.";
            throw new DTDException(err);
        }
        complexType.setContentType(contentType);
        Enumeration dtdAttributes = dtdElement.getAttributes();
        while (dtdAttributes.hasMoreElements()) {
            Attribute dtdAttribute = (Attribute)dtdAttributes.nextElement();
            AttributeDecl schemaAttribute = Converter.convertAttribute(dtdAttribute, schema);
            complexType.addAttributeDecl(schemaAttribute);
        }
        schemaElement.setType(complexType);
        return schemaElement;
    }

    public static Particle convertContentParticle(ContentParticle dtdContent, Schema schema) throws DTDException, SchemaException {
        Particle returnValue;
        if (dtdContent.isReferenceType()) {
            ElementDecl elem = new ElementDecl(schema);
            elem.setReference(dtdContent.getReference());
            returnValue = elem;
        } else if (dtdContent.isSeqType() || dtdContent.isChoiceType()) {
            Group group = new Group();
            if (dtdContent.isSeqType()) {
                group.setOrder(Order.seq);
            } else {
                group.setOrder(Order.choice);
            }
            Enumeration children = dtdContent.getChildren();
            while (children.hasMoreElements()) {
                ContentParticle child = (ContentParticle)children.nextElement();
                Particle contentParticle = Converter.convertContentParticle(child, schema);
                if (contentParticle instanceof ElementDecl) {
                    group.addElementDecl((ElementDecl)contentParticle);
                    continue;
                }
                group.addGroup((Group)contentParticle);
            }
            returnValue = group;
        } else {
            throw new DTDException();
        }
        if (dtdContent.isOneOccurance()) {
            returnValue.setMinOccurs(1);
            returnValue.setMaxOccurs(1);
        } else if (dtdContent.isOneOrMoreOccurances()) {
            returnValue.setMinOccurs(1);
            returnValue.setMaxOccurs(-1);
        } else if (dtdContent.isZeroOrMoreOccurances()) {
            returnValue.setMinOccurs(0);
            returnValue.setMaxOccurs(-1);
        } else if (dtdContent.isZeroOrOneOccurance()) {
            returnValue.setMinOccurs(0);
            returnValue.setMaxOccurs(1);
        }
        return returnValue;
    }

    public static AttributeDecl convertAttribute(Attribute dtdAttribute, Schema schema) throws DTDException {
        AttributeDecl schemaAttribute = new AttributeDecl(schema, dtdAttribute.getName());
        SimpleType type = null;
        if (dtdAttribute.isStringType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(1));
        } else if (dtdAttribute.isIDType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(25));
        } else if (dtdAttribute.isIDREFType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(26));
        } else if (dtdAttribute.isIDREFSType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(27));
        } else if (dtdAttribute.isENTITYType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(28));
        } else if (dtdAttribute.isENTITIESType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(29));
        } else if (dtdAttribute.isNMTOKENType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(30));
        } else if (dtdAttribute.isNMTOKENSType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(31));
        } else if (dtdAttribute.isNOTATIONType()) {
            type = schema.createSimpleType(null, schema.getBuiltInTypeName(19), "restriction");
            Iterator values = dtdAttribute.getValues();
            while (values.hasNext()) {
                type.addFacet(new Facet("enumeration", (String)values.next()));
            }
        } else if (dtdAttribute.isEnumerationType()) {
            type = schema.createSimpleType(null, schema.getBuiltInTypeName(30), "restriction");
            Iterator values = dtdAttribute.getValues();
            while (values.hasNext()) {
                type.addFacet(new Facet("enumeration", (String)values.next()));
            }
        } else {
            String err = "DTD to Schema converter: DTD attribute \"" + dtdAttribute.getName();
            err = err + "\" has unspecified type.";
            throw new DTDException(err);
        }
        schemaAttribute.setSimpleType(type);
        if (dtdAttribute.isREQUIRED()) {
            schemaAttribute.setUse("required");
        } else if (dtdAttribute.isIMPLIED()) {
            schemaAttribute.setUse("optional");
        } else if (!dtdAttribute.isFIXED()) {
            schemaAttribute.setDefaultValue(dtdAttribute.getDefaultValue());
        }
        return schemaAttribute;
    }

    public static void marshalSchema(Schema schema, Writer writer) throws IOException, SAXException {
        SchemaWriter.enable = true;
        SchemaWriter sw = new SchemaWriter(writer);
        sw.write(schema);
    }
}

