/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.File;
import java.util.Hashtable;

public class JavaNaming {
    public static final String UPPER_CASE_AFTER_UNDERSCORE_PROPERTY = "org.exolab.castor.xml.JavaNaming.upperCaseAfterUnderscore";
    public static boolean upperCaseAfterUnderscore = false;
    private static final Hashtable subst = JavaNaming.keywordMap();
    private static final String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};

    private JavaNaming() {
    }

    public static boolean isKeyword(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < keywords.length; ++i) {
            if (!keywords[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidJavaIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch == '_' || ch == '$' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') continue;
            if (ch >= '0' && ch <= '9') {
                if (i != 0) continue;
                return false;
            }
            return false;
        }
        return !JavaNaming.isKeyword(string);
    }

    public static String toJavaClassName(String name) {
        if (name == null || name.length() <= 0) {
            return name;
        }
        int colon = name.indexOf(58);
        if (colon != -1) {
            name = name.substring(colon + 1);
        }
        return JavaNaming.toJavaName(name, true);
    }

    public static String toJavaMemberName(String name) {
        return JavaNaming.toJavaMemberName(name, true);
    }

    public static String toJavaMemberName(String name, boolean useKeywordSubstitutions) {
        if (name == null) {
            return null;
        }
        Object memberName = JavaNaming.toJavaName(name, false);
        if (JavaNaming.isKeyword((String)memberName) && useKeywordSubstitutions) {
            String mappedName = (String)subst.get(memberName);
            memberName = mappedName != null ? mappedName : "_" + (String)memberName;
        }
        return memberName;
    }

    public static String packageToPath(String packageName) {
        if (packageName == null) {
            return packageName;
        }
        return packageName.replace('.', File.separatorChar);
    }

    private static Hashtable keywordMap() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("class", "clazz");
        return ht;
    }

    private static String toJavaName(String name, boolean upperFirst) {
        boolean lowercase;
        int size = name.length();
        char[] ncChars = name.toCharArray();
        int next = 0;
        boolean uppercase = upperFirst;
        boolean bl = lowercase = !uppercase;
        if (size > 1 && lowercase && Character.isUpperCase(ncChars[0]) && Character.isUpperCase(ncChars[1])) {
            lowercase = false;
        }
        block5: for (int i = 0; i < size; ++i) {
            char ch = ncChars[i];
            switch (ch) {
                case ' ': 
                case '.': {
                    ncChars[next++] = 95;
                    continue block5;
                }
                case '-': 
                case ':': {
                    uppercase = true;
                    continue block5;
                }
                case '_': {
                    if (upperCaseAfterUnderscore) {
                        uppercase = true;
                        ncChars[next] = ch;
                        ++next;
                        continue block5;
                    }
                }
                default: {
                    if (uppercase) {
                        ncChars[next] = Character.toUpperCase(ch);
                        uppercase = false;
                    } else if (lowercase) {
                        ncChars[next] = Character.toLowerCase(ch);
                        lowercase = false;
                    } else {
                        ncChars[next] = ch;
                    }
                    ++next;
                }
            }
        }
        return new String(ncChars, 0, next);
    }
}

