/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.util.EmptyStackException;
import org.exolab.castor.util.Iterator;

public class Stack {
    private static final int MAX_POOL_SIZE = 19;
    private int size = 0;
    private StackItem top = null;
    private StackItem _freeItems = null;
    private int _freeItemsCount = 0;

    public boolean empty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new StackIterator(this.top);
    }

    public Object peek() throws EmptyStackException {
        if (this.empty()) {
            throw new EmptyStackException();
        }
        return this.top.object;
    }

    public Object pop() throws EmptyStackException {
        if (this.empty()) {
            throw new EmptyStackException();
        }
        Object obj = this.top.object;
        StackItem tmp = this.top;
        this.top = this.top.previous;
        if (this.top != null) {
            this.top.next = null;
        }
        --this.size;
        this.releaseStackItem(tmp);
        return obj;
    }

    public void push(Object object) {
        StackItem item = this.getAvailableStackItem();
        item.previous = this.top;
        item.next = null;
        item.object = object;
        if (this.top != null) {
            this.top.next = item;
        }
        this.top = item;
        ++this.size;
    }

    public int search(Object object) {
        int idx = 0;
        StackItem item = this.top;
        while (item != null) {
            if (item.object == object) {
                return idx;
            }
            item = item.previous;
            ++idx;
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    private StackItem getAvailableStackItem() {
        StackItem item = null;
        if (this._freeItems == null) {
            item = new StackItem();
        } else {
            item = this._freeItems;
            this._freeItems = this._freeItems.previous;
            if (this._freeItems != null) {
                this._freeItems.next = null;
            }
            --this._freeItemsCount;
            item.clear();
        }
        return item;
    }

    private void releaseStackItem(StackItem item) {
        if (this._freeItemsCount < 19) {
            item.clear();
            item.previous = this._freeItems;
            item.next = null;
            if (this._freeItems != null) {
                this._freeItems.next = item;
            }
            this._freeItems = item;
            ++this._freeItemsCount;
        }
    }

    public class StackIterator
    implements Iterator {
        StackItem current = null;

        protected StackIterator(StackItem top) {
            this.current = top;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Object next() {
            if (this.current != null) {
                Object obj = this.current.object;
                this.current = this.current.previous;
                return obj;
            }
            return null;
        }

        @Override
        public Object remove() throws IllegalStateException {
            return null;
        }
    }

    private class StackItem {
        StackItem next = null;
        StackItem previous = null;
        Object object = null;

        private StackItem() {
        }

        void clear() {
            this.object = null;
            this.previous = null;
            this.next = null;
        }
    }
}

