/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exolab.castor.util.Logger;

public class Messages {
    public static final String ResourceName = "org.exolab.castor.util.resources.messages";
    private static ResourceBundle _messages;
    private static Hashtable _formats;

    public static String format(String message, Object arg1) {
        return Messages.format(message, new Object[]{arg1});
    }

    public static String format(String message, Object arg1, Object arg2) {
        return Messages.format(message, new Object[]{arg1, arg2});
    }

    public static String format(String message, Object arg1, Object arg2, Object arg3) {
        return Messages.format(message, new Object[]{arg1, arg2, arg3});
    }

    public static String format(String message, Object[] args) {
        try {
            MessageFormat mf = (MessageFormat)_formats.get(message);
            if (mf == null) {
                String msg;
                try {
                    msg = _messages.getString(message);
                }
                catch (MissingResourceException except) {
                    return message;
                }
                mf = new MessageFormat(msg);
                _formats.put(message, mf);
            }
            return mf.format(args);
        }
        catch (Exception except) {
            return "An internal error occured while processing message " + message;
        }
    }

    public static String message(String message) {
        try {
            return _messages.getString(message);
        }
        catch (MissingResourceException except) {
            return message;
        }
    }

    public static void setLocale(Locale locale) {
        try {
            _messages = locale == null ? ResourceBundle.getBundle(ResourceName) : ResourceBundle.getBundle(ResourceName, locale);
        }
        catch (Exception except) {
            _messages = new EmptyResourceBundle();
            Logger.getSystemLogger().println("Failed to locate messages resource org.exolab.castor.util.resources.messages");
        }
        _formats = new Hashtable();
    }

    static {
        Messages.setLocale(Locale.getDefault());
    }

    static class EmptyResourceBundle
    extends ResourceBundle
    implements Enumeration {
        EmptyResourceBundle() {
        }

        public Enumeration getKeys() {
            return this;
        }

        @Override
        protected Object handleGetObject(String name) {
            return "[Missing message " + name + "]";
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }
}

