/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;

public class Logger
extends PrintWriter {
    private static final String Prefix = "Castor";
    private static PrintWriter _system = new Logger(System.out).setPrefix("Castor");
    private boolean _logTime = false;
    private String _prefix = null;
    private boolean _newLine = true;

    public Logger(OutputStream output) {
        super(output, true);
    }

    public Logger(Writer writer) {
        super(writer, true);
    }

    public static PrintWriter getSystemLogger() {
        return _system;
    }

    public static void setSystemLogger(PrintWriter system) {
        if (system == null) {
            throw new NullPointerException("Argument 'system' is null");
        }
        _system = system;
    }

    public Logger setPrefix(String prefix) {
        this._prefix = prefix != null && prefix.length() > 0 ? "[" + prefix + "] " : "";
        return this;
    }

    public Logger setLogTime(boolean logTime) {
        this._logTime = logTime;
        return this;
    }

    @Override
    public void println() {
        super.println();
        this._newLine = true;
    }

    @Override
    public void println(boolean value) {
        this.prefixLine();
        super.print(value);
        super.println();
        this._newLine = true;
    }

    @Override
    public void print(boolean value) {
        this.prefixLine();
        super.print(value);
    }

    @Override
    public void println(char value) {
        this.prefixLine();
        super.print(value);
        super.println();
        this._newLine = true;
    }

    @Override
    public void print(char value) {
        this.prefixLine();
        super.print(value);
        this._newLine = value == '\n';
    }

    @Override
    public void println(int value) {
        this.prefixLine();
        super.print(value);
        super.println();
        this._newLine = true;
    }

    @Override
    public void print(int value) {
        this.prefixLine();
        super.print(value);
    }

    @Override
    public void println(long value) {
        this.prefixLine();
        super.print(value);
        super.println();
        this._newLine = true;
    }

    @Override
    public void print(long value) {
        this.prefixLine();
        super.print(value);
    }

    @Override
    public void println(float value) {
        this.prefixLine();
        super.print(value);
        super.println();
        this._newLine = true;
    }

    @Override
    public void print(float value) {
        this.prefixLine();
        super.print(value);
    }

    @Override
    public void println(double value) {
        this.prefixLine();
        super.print(value);
        super.println();
        this._newLine = true;
    }

    @Override
    public void print(double value) {
        this.prefixLine();
        super.print(value);
    }

    @Override
    public void println(char[] value) {
        this.print(value);
        super.println();
        this._newLine = true;
    }

    @Override
    public void print(char[] value) {
        int i;
        int offset = 0;
        for (i = 0; i < value.length; ++i) {
            if (value[i] != '\n') continue;
            this.prefixLine();
            super.write(value, offset, i - offset);
            super.println();
            this._newLine = true;
            offset = i + 1;
        }
        if (i > offset) {
            this.prefixLine();
            super.write(value, offset, i - offset);
            this._newLine = false;
        }
    }

    @Override
    public void println(String value) {
        this.print(value);
        super.println();
        this._newLine = true;
    }

    @Override
    public void print(String value) {
        int i;
        int offset = 0;
        for (i = 0; i < value.length(); ++i) {
            if (value.charAt(i) != '\n') continue;
            this.prefixLine();
            super.write(value, offset, i - offset);
            super.println();
            this._newLine = true;
            offset = i + 1;
        }
        if (i > offset) {
            this.prefixLine();
            super.write(value, offset, i - offset);
            this._newLine = false;
        }
    }

    @Override
    public void println(Object value) {
        this.println(String.valueOf(value));
    }

    @Override
    public void print(Object value) {
        this.prefixLine();
        this.println(String.valueOf(value));
    }

    protected final void prefixLine() {
        if (this._newLine) {
            if (this._logTime) {
                this.write(new Date().toString());
                this.write(32);
            }
            if (this._prefix != null) {
                this.write(this._prefix);
            }
        }
    }
}

