/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.io.Serializable;
import java.text.ParseException;

public class TimeDuration
implements Serializable {
    private static final boolean DEBUG = false;
    private static final int TIME_FLAG = 8;
    private short _year = 0;
    private short _month = 0;
    private short _day = 0;
    private short _hour = 0;
    private short _minute = 0;
    private short _second = 0;
    private short _millisecond = 0;
    private boolean _isNegative = false;

    public TimeDuration() {
    }

    public TimeDuration(long l) {
        long refSecond = 1000L;
        long refMinute = 60L * refSecond;
        long refHour = 60L * refMinute;
        long refDay = 24L * refHour;
        long refMonth = (long)(30.42 * (double)refDay);
        long refYear = 12L * refMonth;
        if (l < 0L) {
            this.setNegative();
            l = -l;
        }
        short year = (short)(l / refYear);
        short month = (short)((l %= refYear) / refMonth);
        short day = (short)((l %= refMonth) / refDay);
        short hour = (short)((l %= refDay) / refHour);
        short minute = (short)((l %= refHour) / refMinute);
        short seconds = (short)((l %= refMinute) / refSecond);
        short milliseconds = (short)(l %= refSecond);
        this.setValue(year, month, day, hour, minute, seconds, milliseconds);
    }

    public void setYear(short year) {
        this._year = year;
    }

    public void setMonth(short month) {
        this._month = month;
    }

    public void setDay(short day) {
        this._day = day;
    }

    public void setHour(short hour) {
        this._hour = hour;
    }

    public void setMinute(short minute) {
        this._minute = minute;
    }

    public void setSeconds(short second) {
        this._second = second;
    }

    public void setMilli(short milli) {
        this._millisecond = milli;
    }

    public void setNegative() {
        this._isNegative = true;
    }

    public void setValue(short year, short month, short day, short hour, short minute, short second, short millisecond) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setHour(hour);
        this.setMinute(minute);
        this.setSeconds(second);
        this.setMilli(millisecond);
    }

    public short getYear() {
        return this._year;
    }

    public short getMonth() {
        return this._month;
    }

    public short getDay() {
        return this._day;
    }

    public short getHour() {
        return this._hour;
    }

    public short getMinute() {
        return this._minute;
    }

    public short getSeconds() {
        return this._second;
    }

    public short getMilli() {
        return this._millisecond;
    }

    public boolean isNegative() {
        return this._isNegative;
    }

    public long toLong() {
        long result = 0L;
        result = (long)((((((double)((long)this._year * 12L + (long)this._month) * 30.42 + (double)this._day) * 24.0 + (double)this._hour) * 60.0 + (double)this._minute) * 60.0 + (double)this._second) * 1000.0 + (double)this._millisecond);
        result = this.isNegative() ? -result : result;
        return result;
    }

    public String toString() {
        boolean isThereTime;
        StringBuffer result = new StringBuffer();
        result.append("P");
        if (this._year != 0) {
            result.append(this._year);
            result.append("Y");
        }
        if (this._month != 0) {
            result.append(this._month);
            result.append("M");
        }
        if (this._day != 0) {
            result.append(this._day);
            result.append("D");
        }
        boolean bl = isThereTime = this._hour != 0 || this._minute != 0 || this._second != 0;
        if (isThereTime) {
            result.append("T");
            if (this._hour != 0) {
                result.append(this._hour);
                result.append("H");
            }
            if (this._minute != 0) {
                result.append(this._minute);
                result.append("M");
            }
            if (this._second != 0) {
                result.append(this._second);
                if (this._millisecond != 0) {
                    result.append('.');
                    if (this._millisecond < 100) {
                        result.append('0');
                        if (this._millisecond < 10) {
                            result.append('0');
                        }
                    }
                    result.append(this._millisecond);
                }
                result.append('S');
            }
        }
        if (this._isNegative) {
            result.insert(0, '-');
        }
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return TimeDuration.parseTimeDuration(str);
    }

    public static TimeDuration parseTimeDuration(String str) throws ParseException {
        if (str == null) {
            throw new IllegalArgumentException("the string to be parsed must not be null");
        }
        TimeDuration result = new TimeDuration();
        char[] chars = str.toCharArray();
        int idx = 0;
        if (chars.length == 0) {
            return null;
        }
        if (chars[idx] == '-') {
            result.setNegative();
            if (++idx >= chars.length) {
                throw new ParseException("'-' is wrong placed", 0);
            }
        }
        if (chars[idx] != 'P') {
            throw new ParseException("Missing 'P' delimiter", idx);
        }
        ++idx;
        int number = 0;
        boolean hasNumber = false;
        int flags = 0;
        block9: while (idx < chars.length) {
            char ch = chars[idx++];
            switch (ch) {
                case 'Y': {
                    String err;
                    if (flags > 0) {
                        err = str + ":Syntax error, 'Y' must proceed all other delimiters.";
                        throw new ParseException(err, idx);
                    }
                    flags = 64;
                    if (hasNumber) {
                        result.setYear((short)number);
                        hasNumber = false;
                        continue block9;
                    }
                    err = str + ":missing number of years before 'Y'";
                    throw new ParseException(err, idx);
                }
                case 'M': {
                    String err;
                    if ((flags & 8) == 8) {
                        if ((flags & 3) > 0) {
                            throw new ParseException(str + ": Syntax Error...", idx);
                        }
                        flags |= 2;
                        if (hasNumber) {
                            result.setMinute((short)number);
                            hasNumber = false;
                            continue block9;
                        }
                        err = str + ": missing number of minutes before 'M'";
                        throw new ParseException(err, idx);
                    }
                    if ((flags & 0x3F) > 0) {
                        throw new ParseException(str + ":Syntax Error...", idx);
                    }
                    flags |= 0x20;
                    if (hasNumber) {
                        result.setMonth((short)number);
                        hasNumber = false;
                        continue block9;
                    }
                    err = str + ":missing number of months before 'M'";
                    throw new ParseException(err, idx);
                }
                case 'D': {
                    if ((flags & 0x1F) > 0) {
                        throw new ParseException(str + ":Syntax Error...", idx);
                    }
                    flags |= 0x10;
                    if (hasNumber) {
                        result.setDay((short)number);
                        hasNumber = false;
                        continue block9;
                    }
                    String err = str + ":missing number of days before 'D'";
                    throw new ParseException(err, idx);
                }
                case 'T': {
                    String err;
                    if ((flags & 8) == 8) {
                        err = str + ":Syntax error, 'T' may not exist more than once.";
                        throw new ParseException(err, idx);
                    }
                    flags |= 8;
                    continue block9;
                }
                case 'H': {
                    String err;
                    if ((flags & 0xF) != 8) {
                        err = null;
                        err = (flags & 8) != 8 ? str + ": Missing 'T' before 'H'" : str + ": Syntax Error, 'H' must appear for 'M' or 'S'";
                        throw new ParseException(err, idx);
                    }
                    flags |= 4;
                    if (hasNumber) {
                        result.setHour((short)number);
                        hasNumber = false;
                        continue block9;
                    }
                    err = str + ":missing number of hours before 'H'";
                    throw new ParseException(err, idx);
                }
                case 'S': {
                    String err;
                    if (flags != 0) {
                        if ((flags & 8) != 8) {
                            err = str + ": Missing 'T' before 'S'";
                            throw new ParseException(err, idx);
                        }
                        if ((flags & 1) == 1) {
                            err = str + ": Syntax error 'S' may not exist more than once.";
                            throw new ParseException(err, idx);
                        }
                        flags |= 1;
                        if (hasNumber) {
                            result.setSeconds((short)number);
                            hasNumber = false;
                            continue block9;
                        }
                        err = str + ": missing number of seconds before 'S'";
                        throw new ParseException(err, idx);
                    }
                    if (hasNumber) {
                        String numb = Integer.toString(number);
                        if (numb.length() < 3) {
                            if (numb.length() < 2) {
                                number *= 10;
                            }
                            number *= 10;
                        }
                        result.setMilli((short)number);
                        hasNumber = false;
                        continue block9;
                    }
                    err = str + ": missing number of milliseconds before 'S'";
                    throw new ParseException(err, idx);
                }
                case '.': {
                    String err;
                    if ((flags | 1) == 1) {
                        err = str + ": Syntax error '.' may not exist more than once.";
                        throw new ParseException(err, idx);
                    }
                    if ((flags & 8) != 8) {
                        err = str + ": Missing 'T' before 'S'";
                        throw new ParseException(err, idx);
                    }
                    flags = 0;
                    if (hasNumber) {
                        result.setSeconds((short)number);
                        hasNumber = false;
                        continue block9;
                    }
                    err = str + ": missing number of seconds before 'S'";
                    throw new ParseException(err, idx);
                }
            }
            if ('0' <= ch && ch <= '9') {
                if (hasNumber) {
                    number = number * 10 + (ch - 48);
                    continue;
                }
                hasNumber = true;
                number = ch - 48;
                continue;
            }
            throw new ParseException(str + ":Invalid character: " + ch, idx);
        }
        if ((flags & 0xF) == 8) {
            throw new ParseException(str + ": T must be omitted", idx);
        }
        if (hasNumber) {
            throw new ParseException(str + ": expecting ending delimiter", idx);
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof TimeDuration) {
            return this.equal((TimeDuration)object);
        }
        return false;
    }

    public boolean equal(TimeDuration timeD) {
        boolean result = false;
        if (timeD == null) {
            return result;
        }
        result = this._year == timeD.getYear();
        result = result && this._month == timeD.getMonth();
        result = result && this._day == timeD.getDay();
        result = result && this._hour == timeD.getHour();
        result = result && this._minute == timeD.getMinute();
        result = result && this._second == timeD.getSeconds();
        result = result && this.isNegative() == timeD.isNegative();
        return result;
    }

    public boolean isGreater(TimeDuration timeD) {
        boolean result = false;
        result = this.toLong() > timeD.toLong();
        return result;
    }
}

