/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.exolab.castor.types.Duration;
import org.exolab.castor.types.GDay;
import org.exolab.castor.types.GMonth;
import org.exolab.castor.types.GMonthDay;
import org.exolab.castor.types.GYear;
import org.exolab.castor.types.GYearMonth;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.types.Time;

public abstract class DateTimeBase
implements Serializable {
    private short _century = 0;
    private short _year = 0;
    private short _month = 0;
    private short _day = 0;
    private short _hour = 0;
    private short _minute = 0;
    private short _second = 0;
    private short _millsecond = 0;
    private short _zoneHour = 0;
    private short _zoneMinute = 0;
    private boolean _UTC = false;
    private boolean _zoneNegative = false;
    private boolean _isNegative = false;
    public static final int INDETERMINATE = -1;
    public static final int LESS_THAN = 0;
    public static final int EQUALS = 1;
    public static final int GREATER_THAN = 2;
    protected static final String WRONGLY_PLACED = "is wrongly placed.";

    public void setCentury(short century) {
        Object err = "";
        if (century < 0) {
            err = "century : " + century + " must not be a negative value.";
            throw new IllegalArgumentException((String)err);
        }
        this._century = century;
    }

    public void setYear(short year) throws OperationNotSupportedException {
        Object err = "";
        if (year < 0) {
            err = "year : " + year + " must not be a negative value.";
            throw new IllegalArgumentException((String)err);
        }
        if (year == -1 && this._century != -1) {
            err = "year can not be omitted if century is not omitted.";
            throw new IllegalArgumentException((String)err);
        }
        if (year == 0 && this._century == 0) {
            err = "0000 is not an allowed year";
            throw new IllegalArgumentException((String)err);
        }
        if (year > 99) {
            err = year + " is not correct: A year field must be ranged between 0 and 99";
            throw new IllegalArgumentException((String)err);
        }
        this._year = year;
    }

    public void setMonth(short month) throws OperationNotSupportedException {
        Object err = "";
        if (month == -1) {
            if (this._century != -1) {
                err = "month cannot be omitted if the previous component is not omitted.\nonly higher level components can be omitted.";
                throw new IllegalArgumentException((String)err);
            }
        } else {
            if (month < 1) {
                err = "month : " + month + " is not a correct value.\n 1<month<12";
                throw new IllegalArgumentException((String)err);
            }
            if (month > 12) {
                err = "month : " + month + " is not a correct value.";
                err = (String)err + "\n 1<month<12";
                throw new IllegalArgumentException((String)err);
            }
        }
        this._month = month;
    }

    public void setDay(short day) throws OperationNotSupportedException {
        Object err = "";
        if (day == -1) {
            if (this._month != -1) {
                err = "day cannot be omitted if the previous component is not omitted.\nonly higher level components can be omitted.";
                throw new IllegalArgumentException((String)err);
            }
        } else if (day < 0) {
            err = "day : " + day + " is not a correct value.";
            err = (String)err + "\n 1<day";
            throw new IllegalArgumentException((String)err);
        }
        if (this._month == 2) {
            if (this.isLeap(this._century, this._year)) {
                if (day > 29) {
                    err = "day : " + day + " is not a correct value.";
                    err = (String)err + "\n day<30 (leap year and month is february)";
                    throw new IllegalArgumentException((String)err);
                }
            } else if (day > 28) {
                err = "day : " + day + " is not a correct value.";
                err = (String)err + "\n day<30 (not a leap year and month is february)";
                throw new IllegalArgumentException((String)err);
            }
        } else if (this._month == 4 || this._month == 6 || this._month == 9 || this._month == 11) {
            if (day > 30) {
                err = "day : " + day + " is not a correct value.";
                err = (String)err + "\n day<31 ";
                throw new IllegalArgumentException((String)err);
            }
        } else if (day > 31) {
            err = "day : " + day + " is not a correct value.";
            err = (String)err + "\n day<=31 ";
            throw new IllegalArgumentException((String)err);
        }
        this._day = day;
    }

    public final boolean isLeap(int year) {
        short century = (short)(year / 100);
        return this.isLeap(century, (short)(year %= 100));
    }

    private final boolean isLeap(short century, short year) {
        int temp = century * 100 + year;
        boolean result = temp % 4 == 0 && temp % 100 != 0;
        result = result || temp % 400 == 0;
        return result;
    }

    public void setHour(short hour) throws OperationNotSupportedException {
        if (hour > 23) {
            String err = "the hour field (" + hour + ")must be strictly lower than 24";
            throw new IllegalArgumentException(err);
        }
        if (hour < 0) {
            String err = "hour : " + hour + " is not a correct value.";
            err = err + "\n 0<hour";
            throw new IllegalArgumentException(err);
        }
        this._hour = hour;
    }

    public void setMinute(short minute) throws OperationNotSupportedException {
        if (minute > 59) {
            String err = "the minute field (" + minute + ")must be lower than 59.";
            throw new IllegalArgumentException(err);
        }
        if (minute < 0) {
            String err = "minute : " + minute + " is not a correct value.";
            err = err + "\n 0<minute";
            throw new IllegalArgumentException(err);
        }
        this._minute = minute;
    }

    public void setSecond(short second, short millsecond) throws OperationNotSupportedException {
        this.setSecond(second);
        this.setMilliSecond(millsecond);
    }

    public void setSecond(short second) throws OperationNotSupportedException {
        if (second > 60) {
            String err = "the second field (" + second + ")must be lower than 60";
            throw new IllegalArgumentException(err);
        }
        if (second < 0) {
            String err = "second : " + second + " is not a correct value.";
            err = err + "\n 0<second";
            throw new IllegalArgumentException(err);
        }
        this._second = second;
    }

    public void setMilliSecond(short millisecond) throws OperationNotSupportedException {
        if (millisecond < 0) {
            String err = "millisecond : " + millisecond + " is not a correct value.";
            err = err + "\n 0<millisecond";
            throw new IllegalArgumentException(err);
        }
        this._millsecond = millisecond;
    }

    public void setZone(short hour, short minute) throws OperationNotSupportedException {
        this.setZoneHour(hour);
        this.setZoneMinute(minute);
    }

    public void setZoneHour(short hour) throws OperationNotSupportedException {
        if (hour > 23) {
            String err = "the zone hour field (" + hour + ")must be strictly lower than 24";
            throw new IllegalArgumentException(err);
        }
        if (hour < 0) {
            String err = "hour : " + hour + " is not a correct value.";
            err = err + "\n 0<hour";
            throw new IllegalArgumentException(err);
        }
        this._zoneHour = hour;
        this.setUTC();
    }

    public void setZoneMinute(short minute) throws OperationNotSupportedException {
        if (minute > 59) {
            String err = "the minute field (" + minute + ")must be lower than 59";
            throw new IllegalArgumentException(err);
        }
        if (minute < 0) {
            String err = "minute : " + minute + " is not a correct value.";
            err = err + "\n 0<minute";
            throw new IllegalArgumentException(err);
        }
        this._zoneMinute = minute;
        this.setUTC();
    }

    public abstract void setValues(short[] var1);

    public void setNegative() {
        this._isNegative = true;
    }

    public abstract Date toDate();

    public void setZoneNegative(boolean zoneNegative) throws OperationNotSupportedException {
        this._zoneNegative = zoneNegative;
    }

    public void setUTC() {
        this._UTC = true;
    }

    public short getCentury() {
        return this._century;
    }

    public short getYear() {
        return this._year;
    }

    public short getMonth() {
        return this._month;
    }

    public short getDay() {
        return this._day;
    }

    public short getHour() {
        return this._hour;
    }

    public short getMinute() {
        return this._minute;
    }

    public short getSeconds() {
        return this._second;
    }

    public short getMilli() {
        return this._millsecond;
    }

    public short getZoneHour() {
        return this._zoneHour;
    }

    public short getZoneMinute() {
        return this._zoneMinute;
    }

    public abstract short[] getValues();

    public boolean isUTC() {
        return this._UTC;
    }

    public boolean isNegative() {
        return this._isNegative;
    }

    public boolean isZoneNegative() {
        return this._zoneNegative;
    }

    /*
     * Unable to fully structure code
     */
    public void addDuration(Duration duration) {
        block22: {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                temp = 0;
                                carry = 0;
                                sign = duration.isNegative() != false ? -1 : 1;
                                try {
                                    temp = this._month + sign * duration.getMonth();
                                    carry = this.fQuotient(temp - 1, 12);
                                    temp = this.modulo(temp - 1, 12) + 1;
                                    this.setMonth((short)temp);
                                }
                                catch (OperationNotSupportedException e) {
                                    if (this instanceof Time || this instanceof GYear || this instanceof GDay) break block17;
                                    throw e;
                                }
                            }
                            try {
                                temp = this._century * 100 + this._year + sign * duration.getYear() + carry;
                                century = (short)(temp / 100);
                                this.setCentury(century);
                                this.setYear((short)(temp %= 100));
                            }
                            catch (OperationNotSupportedException e) {
                                if (this instanceof Time || this instanceof GMonthDay) break block18;
                                throw e;
                            }
                        }
                        try {
                            temp = this._second + sign * duration.getSeconds();
                            carry = this.fQuotient(temp, 60);
                            temp = this.modulo(temp, 60);
                            this.setSecond((short)temp, this.getMilli());
                        }
                        catch (OperationNotSupportedException e) {
                            if (!(this instanceof Time)) break block19;
                            throw e;
                        }
                    }
                    try {
                        temp = this._minute + sign * duration.getMinute() + carry;
                        carry = this.fQuotient(temp, 60);
                        temp = this.modulo(temp, 60);
                        this.setMinute((short)temp);
                    }
                    catch (OperationNotSupportedException e) {
                        if (!(this instanceof Time)) break block20;
                        throw e;
                    }
                }
                try {
                    temp = this._hour + sign * duration.getHour() + carry;
                    carry = this.fQuotient(temp, 24);
                    temp = this.modulo(temp, 24);
                    this.setHour((short)temp);
                }
                catch (OperationNotSupportedException e) {
                    if (!(this instanceof Time)) break block21;
                    throw e;
                }
            }
            try {
                maxDay = this.maxDayInMonthFor(this._century, this._year, this._month);
                tempDay = this._day > maxDay ? maxDay : this._day;
                tempDay = tempDay + sign * duration.getDay() + carry;
                while (true) lbl-1000:
                // 3 sources

                {
                    if (tempDay < 1) {
                        tempDay = (short)(tempDay + this.maxDayInMonthFor(this._century, this._year, this._month - 1));
                        this.setDay((short)tempDay);
                        carry = -1;
                    } else {
                        if (tempDay <= maxDay) ** break;
                        tempDay = (short)(tempDay - (short)maxDay);
                        carry = 1;
                    }
                    try {
                        temp = this._month + carry;
                        this.setMonth((short)(this.modulo(temp - 1, 12) + 1));
                        temp = this.fQuotient(temp - 1, 12);
                        temp = this.getCentury() * 100 + this.getYear() + temp;
                        century = (short)(temp / 100);
                        this.setCentury(century);
                        this.setYear((short)(temp %= 100));
                    }
                    catch (OperationNotSupportedException e) {
                        if (!(this instanceof Time) && !(this instanceof GMonthDay)) ** break;
                        continue;
                        throw e;
                    }
                    break;
                }
                ** GOTO lbl-1000
                this.setDay((short)tempDay);
            }
            catch (OperationNotSupportedException e) {
                if (this instanceof Time || this instanceof GYearMonth || this instanceof GMonth) break block22;
                throw e;
            }
        }
    }

    private int fQuotient(int a, int b) {
        return (int)Math.floor((float)a / (float)b);
    }

    private int modulo(int a, int b) {
        return a - this.fQuotient(a, b) * b;
    }

    private final short maxDayInMonthFor(short century, short year, int month) {
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        if (month == 2) {
            if (this.isLeap(century, year)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    public void normalize() {
        if (!this.isUTC()) {
            return;
        }
        if (this._zoneHour == 0 && this._zoneMinute == 0) {
            return;
        }
        Duration temp = new Duration();
        temp.setHour(this._zoneHour);
        temp.setMinute(this._zoneMinute);
        if (this.isZoneNegative()) {
            temp.setNegative();
        }
        this.addDuration(temp);
        this.setZone((short)0, (short)0);
        Object var1_1 = null;
    }

    public int compareTo(DateTimeBase dateTime) {
        if (dateTime == null) {
            throw new IllegalArgumentException("a Date/Time datatype cannot be compared with a null value");
        }
        DateTimeBase tempDate1 = this;
        DateTimeBase tempDate2 = dateTime;
        if (tempDate1.isUTC()) {
            tempDate1.normalize();
        }
        if (tempDate2.isUTC()) {
            tempDate2.normalize();
        }
        if (tempDate1.isUTC() && tempDate2.isUTC() || !tempDate1.isUTC() && !tempDate2.isUTC()) {
            return DateTimeBase.compareFields(tempDate1, tempDate2);
        }
        if (tempDate1.isUTC()) {
            tempDate2.setZone((short)14, (short)0);
            tempDate2.normalize();
            int result = DateTimeBase.compareFields(tempDate1, tempDate2);
            if (result == 0) {
                return result;
            }
            tempDate2.setZone((short)14, (short)0);
            tempDate2.setZoneNegative(true);
            tempDate2.normalize();
            result = DateTimeBase.compareFields(tempDate1, tempDate2);
            if (result == 2) {
                return result;
            }
            return -1;
        }
        if (tempDate2.isUTC()) {
            tempDate1.setZone((short)14, (short)0);
            tempDate1.normalize();
            int result = DateTimeBase.compareFields(tempDate1, tempDate2);
            if (result == 2) {
                return result;
            }
            tempDate1.setZone((short)14, (short)0);
            tempDate1.setZoneNegative(true);
            tempDate1.normalize();
            result = DateTimeBase.compareFields(tempDate1, tempDate2);
            if (result == 0) {
                return result;
            }
            return -1;
        }
        tempDate1 = null;
        tempDate2 = null;
        return -1;
    }

    private static int compareFields(DateTimeBase date1, DateTimeBase date2) {
        int field1 = -1;
        int field2 = -1;
        try {
            field1 = date1.getCentury();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        try {
            field2 = date2.getCentury();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        if (field1 * field2 < 0) {
            return -1;
        }
        if (field1 < field2) {
            return 0;
        }
        if (field1 > field2) {
            return 2;
        }
        try {
            field1 = date1.getYear();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        try {
            field2 = date2.getYear();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        if (field1 * field2 < 0) {
            return -1;
        }
        if (field1 < field2) {
            return 0;
        }
        if (field1 > field2) {
            return 2;
        }
        try {
            field1 = date1.getMonth();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        try {
            field2 = date2.getMonth();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        if (field1 * field2 < 0) {
            return -1;
        }
        if (field1 < field2) {
            return 0;
        }
        if (field1 > field2) {
            return 2;
        }
        try {
            field1 = date1.getDay();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        try {
            field2 = date2.getDay();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        if (field1 * field2 < 0) {
            return -1;
        }
        if (field1 < field2) {
            return 0;
        }
        if (field1 > field2) {
            return 2;
        }
        try {
            field1 = date1.getHour();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        try {
            field2 = date2.getHour();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        if (field1 * field2 < 0) {
            return -1;
        }
        if (field1 < field2) {
            return 0;
        }
        if (field1 > field2) {
            return 2;
        }
        try {
            field1 = date1.getMinute();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        try {
            field2 = date2.getMinute();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        if (field1 * field2 < 0) {
            return -1;
        }
        if (field1 < field2) {
            return 0;
        }
        if (field1 > field2) {
            return 2;
        }
        try {
            field1 = date1.getSeconds();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        try {
            field2 = date2.getSeconds();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        if (field1 * field2 < 0) {
            return -1;
        }
        if (field1 < field2) {
            return 0;
        }
        if (field1 > field2) {
            return 2;
        }
        try {
            field1 = date1.getMilli();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        try {
            field2 = date2.getMilli();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        if (field1 * field2 < 0) {
            return -1;
        }
        if (field1 < field2) {
            return 0;
        }
        if (field1 > field2) {
            return 2;
        }
        return 1;
    }

    public int hashCode() {
        return this._year ^ this._month ^ this._day ^ this._hour ^ this._minute ^ this._second ^ this._zoneHour ^ this._zoneMinute;
    }

    public boolean equals(Object object) {
        if (object instanceof DateTimeBase) {
            return this.equal((DateTimeBase)object);
        }
        return false;
    }

    protected boolean equal(DateTimeBase dateTime) {
        int result = this.compareTo(dateTime);
        return result == 1;
    }

    public Calendar toCalendar() {
        GregorianCalendar result = new GregorianCalendar();
        result.setTime(this.toDate());
        return result;
    }
}

