/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.text.ParseException;
import java.util.Enumeration;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.types.GMonth;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class XSGMonth
extends XSType {
    private static final JType jType = new JClass("org.exolab.castor.types.GMonth");
    private GMonth _maxInclusive;
    private GMonth _maxExclusive;
    private GMonth _minInclusive;
    private GMonth _minExclusive;

    public XSGMonth() {
        super((short)10);
    }

    @Override
    public String newInstanceCode() {
        return "new " + this.getJType().getName() + "();";
    }

    @Override
    public JType getJType() {
        return jType;
    }

    public GMonth getMaxExclusive() {
        return this._maxExclusive;
    }

    public GMonth getMaxInclusive() {
        return this._maxInclusive;
    }

    public GMonth getMinExclusive() {
        return this._minExclusive;
    }

    public GMonth getMinInclusive() {
        return this._minInclusive;
    }

    public void setMaxExclusive(GMonth max) {
        this._maxExclusive = max;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(GMonth max) {
        this._maxInclusive = max;
        this._maxExclusive = null;
    }

    public void setMinExclusive(GMonth min) {
        this._minExclusive = min;
        this._minInclusive = null;
    }

    public void setMinInclusive(GMonth min) {
        this._minInclusive = min;
        this._minExclusive = null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    @Override
    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSGMonth.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            try {
                if ("maxExclusive".equals(name)) {
                    this.setMaxExclusive(GMonth.parseGMonth(facet.getValue()));
                    continue;
                }
                if ("maxInclusive".equals(name)) {
                    this.setMaxInclusive(GMonth.parseGMonth(facet.getValue()));
                    continue;
                }
                if ("minExclusive".equals(name)) {
                    this.setMinExclusive(GMonth.parseGMonth(facet.getValue()));
                    continue;
                }
                if ("minInclusive".equals(name)) {
                    this.setMinInclusive(GMonth.parseGMonth(facet.getValue()));
                    continue;
                }
                if (!"pattern".equals(name)) continue;
                System.out.println("Warning: The facet 'pattern' is not currently supported for XSGMonth.");
            }
            catch (ParseException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    @Override
    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        if (jsc == null) {
            jsc = new JSourceCode();
        }
        jsc.add("DateTimeValidator typeValidator = new DateTimeValidator();");
        if (this.hasMinimum()) {
            jsc.add("try {");
            jsc.indent();
            GMonth min = this.getMinExclusive();
            if (min != null) {
                jsc.add("org.exolab.castor.types. min =org.exolab.castor.types..parse(\"" + min.toString() + "\");");
                jsc.add("typeValidator.setMinExclusive(");
            } else {
                min = this.getMinInclusive();
                jsc.add("org.exolab.castor.types. min =org.exolab.castor.types..parse(\"" + min.toString() + "\");");
                jsc.add("typeValidator.setMinInclusive(");
            }
            jsc.append("min");
            jsc.append(");");
            jsc.unindent();
            jsc.add("} catch (java.text.ParseException e) {");
            jsc.indent();
            jsc.add("System.out.println(e);");
            jsc.add("e.printStackTrace();");
            jsc.add("return;");
            jsc.unindent();
            jsc.add("}");
        }
        if (this.hasMaximum()) {
            jsc.add("try {");
            jsc.indent();
            GMonth max = this.getMaxExclusive();
            if (max != null) {
                jsc.add("org.exolab.castor.types. max =org.exolab.castor.types..parse(\"" + max.toString() + "\");");
                jsc.add("typeValidator.setMaxExclusive(");
            } else {
                max = this.getMaxInclusive();
                jsc.add("org.exolab.castor.types. max =org.exolab.castor.types.Date.parse(\"" + max.toString() + "\");");
                jsc.add("typeValidator.setMaxInclusive(");
            }
            jsc.append("max");
            jsc.append(");");
            jsc.unindent();
            jsc.add("} catch (java.text.ParseException e) {");
            jsc.indent();
            jsc.add("System.out.println(e);");
            jsc.add("e.printStackTrace();");
            jsc.add("return;");
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

