/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSFloat
extends XSPatternBase {
    Float maxInclusive = null;
    Float maxExclusive = null;
    Float minInclusive = null;
    Float minExclusive = null;
    private static JType jType = JType.Float;
    private boolean _asWrapper = false;

    public XSFloat() {
        this(false);
    }

    public XSFloat(boolean asWrapper) {
        super((short)14);
        this._asWrapper = asWrapper;
        jType = this._asWrapper ? new JClass("java.lang.Float") : JType.Float;
    }

    @Override
    public JType getJType() {
        return jType;
    }

    public Float getMaxExclusive() {
        return this.maxExclusive;
    }

    public Float getMaxInclusive() {
        return this.maxInclusive;
    }

    public Float getMinExclusive() {
        return this.minExclusive;
    }

    public Float getMinInclusive() {
        return this.minInclusive;
    }

    public boolean hasMaximum() {
        return this.maxInclusive != null || this.maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this.minInclusive != null || this.minExclusive != null;
    }

    public void setMaxExclusive(float max) {
        this.maxExclusive = new Float(max);
    }

    public void setMaxExclusive(Float max) {
        this.maxExclusive = max;
    }

    public void setMaxInclusive(float max) {
        this.maxInclusive = new Float(max);
    }

    public void setMaxInclusive(Float max) {
        this.maxInclusive = max;
    }

    public void setMinExclusive(float min) {
        this.minExclusive = new Float(min);
    }

    public void setMinExclusive(Float min) {
        this.minExclusive = min;
    }

    public void setMinInclusive(float min) {
        this.minInclusive = new Float(min);
    }

    public void setMinInclusive(Float min) {
        this.minInclusive = min;
    }

    @Override
    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSFloat.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(facet.toFloat());
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(facet.toFloat());
                continue;
            }
            if ("minExclusive".equals(name)) {
                this.setMinExclusive(facet.toFloat());
                continue;
            }
            if ("minInclusive".equals(name)) {
                this.setMinInclusive(facet.toFloat());
                continue;
            }
            if (!"pattern".equals(name)) continue;
            this.setPattern(facet.getValue());
        }
    }

    @Override
    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return super.createToJavaObjectCode(variableName);
        }
        StringBuffer sb = new StringBuffer("new java.lang.Float(");
        sb.append(variableName);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String createFromJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer("((java.lang.Float)");
        sb.append(variableName);
        sb.append(")");
        if (!this._asWrapper) {
            sb.append(".floatValue()");
        }
        return sb.toString();
    }

    @Override
    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        String pattern;
        if (jsc == null) {
            jsc = new JSourceCode();
        }
        jsc.add("FloatValidator typeValidator = new FloatValidator();");
        if (this.hasMinimum()) {
            Float min = this.getMinExclusive();
            if (min != null) {
                jsc.add("typeValidator.setMinExclusive(");
            } else {
                min = this.getMinInclusive();
                jsc.add("typeValidator.setMinInclusive(");
            }
            if (min.equals(new Float(Float.NEGATIVE_INFINITY))) {
                jsc.append("Float.NEGATIVE_INFINITY");
            } else if (min.equals(new Float(Float.POSITIVE_INFINITY))) {
                jsc.append("Float.POSITIVE_INFINITY");
            } else {
                jsc.append(min.toString() + "f");
            }
            jsc.append(");");
        }
        if (this.hasMaximum()) {
            Float max = this.getMaxExclusive();
            if (max != null) {
                jsc.add("typeValidator.setMaxExclusive(");
            } else {
                max = this.getMaxInclusive();
                jsc.add("typeValidator.setMaxInclusive(");
            }
            if (max.equals(new Float(Float.NEGATIVE_INFINITY))) {
                jsc.append("Float.NEGATIVE_INFINITY");
            } else if (max.equals(new Float(Float.POSITIVE_INFINITY))) {
                jsc.append("Float.POSITIVE_INFINITY");
            } else {
                jsc.append(max.toString() + "f");
            }
            jsc.append(");");
        }
        if (fixedValue != null) {
            Float test = new Float(fixedValue);
            jsc.add("typeValidator.setFixed(");
            jsc.append(fixedValue);
            jsc.append("f);");
        }
        if ((pattern = this.getPattern()) != null) {
            jsc.add("typeValidator.setPattern(\"");
            jsc.append(XSFloat.escapePattern(pattern));
            jsc.append("\");");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

