/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSBoolean
extends XSType {
    private static JType jType = JType.Boolean;
    private boolean _asWrapper = false;

    public XSBoolean() {
        this(false);
    }

    public XSBoolean(boolean asWrapper) {
        super((short)11);
        this._asWrapper = asWrapper;
        jType = this._asWrapper ? new JClass("java.lang.Boolean") : JType.Boolean;
    }

    @Override
    public JType getJType() {
        return jType;
    }

    @Override
    public void setFacets(SimpleType simpleType) {
    }

    @Override
    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return super.createToJavaObjectCode(variableName);
        }
        StringBuffer sb = new StringBuffer("(");
        sb.append(variableName);
        sb.append(" ? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE)");
        return sb.toString();
    }

    @Override
    public String createFromJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer("((java.lang.Boolean)");
        sb.append(variableName);
        sb.append(")");
        if (!this._asWrapper) {
            sb.append(".booleanValue()");
        }
        return sb.toString();
    }

    @Override
    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        if (jsc == null) {
            jsc = new JSourceCode();
        }
        jsc.add("BooleanValidator typeValidator = new BooleanValidator();");
        if (fixedValue != null) {
            Boolean.valueOf(fixedValue);
            jsc.add("typeValidator.setFixed(");
            jsc.append(fixedValue);
            jsc.append(");");
        }
        jsc.add("fieldValidator.setValidator(typeValidator);");
    }
}

