/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Enumeration;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.types.XSAnyURI;
import org.exolab.castor.builder.types.XSBinary;
import org.exolab.castor.builder.types.XSBoolean;
import org.exolab.castor.builder.types.XSByte;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSDate;
import org.exolab.castor.builder.types.XSDateTime;
import org.exolab.castor.builder.types.XSDecimal;
import org.exolab.castor.builder.types.XSDouble;
import org.exolab.castor.builder.types.XSDuration;
import org.exolab.castor.builder.types.XSFloat;
import org.exolab.castor.builder.types.XSGDay;
import org.exolab.castor.builder.types.XSGMonth;
import org.exolab.castor.builder.types.XSGMonthDay;
import org.exolab.castor.builder.types.XSGYear;
import org.exolab.castor.builder.types.XSGYearMonth;
import org.exolab.castor.builder.types.XSId;
import org.exolab.castor.builder.types.XSIdRef;
import org.exolab.castor.builder.types.XSInt;
import org.exolab.castor.builder.types.XSInteger;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.builder.types.XSLong;
import org.exolab.castor.builder.types.XSNCName;
import org.exolab.castor.builder.types.XSNMToken;
import org.exolab.castor.builder.types.XSNegativeInteger;
import org.exolab.castor.builder.types.XSNonNegativeInteger;
import org.exolab.castor.builder.types.XSNonPositiveInteger;
import org.exolab.castor.builder.types.XSNormalizedString;
import org.exolab.castor.builder.types.XSPositiveInteger;
import org.exolab.castor.builder.types.XSQName;
import org.exolab.castor.builder.types.XSShort;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSTime;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Union;
import org.exolab.javasource.JClass;

public class TypeConversion {
    private static final String TYPES_PACKAGE = "types";
    private BuilderConfiguration _config = null;

    public TypeConversion(BuilderConfiguration config) {
        if (config == null) {
            String error = "The argument 'config' must not be null.";
            throw new IllegalArgumentException(error);
        }
        this._config = config;
    }

    public XSType convertType(SimpleType simpleType) {
        return this.convertType(simpleType, this._config.usePrimitiveWrapper(), null);
    }

    public XSType convertType(SimpleType simpleType, String packageName) {
        return this.convertType(simpleType, this._config.usePrimitiveWrapper(), packageName);
    }

    public XSType convertType(SimpleType simpleType, boolean useWrapper, String packageName) {
        SimpleType base;
        if (simpleType == null) {
            return null;
        }
        XSType xsType = null;
        for (base = simpleType; base != null && !base.isBuiltInType(); base = (SimpleType)base.getBaseType()) {
        }
        if (simpleType.getStructureType() == 22) {
            SimpleType common = TypeConversion.findCommonType((Union)simpleType);
            if (common == null) {
                return new XSClass(SGTypes.Object);
            }
            return this.convertType(common, useWrapper, (String)packageName);
        }
        if (base == null) {
            String className = JavaNaming.toJavaClassName(simpleType.getName());
            xsType = new XSClass(new JClass(className));
        } else {
            switch (base.getTypeCode()) {
                case 25: {
                    return new XSId();
                }
                case 26: {
                    return new XSIdRef();
                }
                case 27: {
                    return new XSList(new XSIdRef());
                }
                case 30: {
                    return new XSNMToken();
                }
                case 31: {
                    return new XSList(new XSNMToken());
                }
                case 17: {
                    return new XSAnyURI();
                }
                case 12: {
                    return new XSBinary(12);
                }
                case 13: {
                    return new XSBinary(13);
                }
                case 11: {
                    return new XSBoolean(useWrapper);
                }
                case 38: {
                    XSByte xsByte = new XSByte(useWrapper);
                    if (!simpleType.isBuiltInType()) {
                        xsByte.setFacets(simpleType);
                    }
                    return xsByte;
                }
                case 5: {
                    XSDate xsDate = new XSDate();
                    if (!simpleType.isBuiltInType()) {
                        xsDate.setFacets(simpleType);
                    }
                    return xsDate;
                }
                case 3: {
                    return new XSDateTime();
                }
                case 15: {
                    XSDouble xsDouble = new XSDouble(useWrapper);
                    if (!simpleType.isBuiltInType()) {
                        xsDouble.setFacets(simpleType);
                    }
                    return xsDouble;
                }
                case 2: {
                    XSDuration xsDuration = new XSDuration();
                    if (!simpleType.isBuiltInType()) {
                        xsDuration.setFacets(simpleType);
                    }
                    return xsDuration;
                }
                case 16: {
                    XSDecimal xsDecimal = new XSDecimal();
                    if (!simpleType.isBuiltInType()) {
                        xsDecimal.setFacets(simpleType);
                    }
                    return xsDecimal;
                }
                case 14: {
                    XSFloat xsFloat = new XSFloat(useWrapper);
                    if (!simpleType.isBuiltInType()) {
                        xsFloat.setFacets(simpleType);
                    }
                    return xsFloat;
                }
                case 9: {
                    XSGDay xsGDay = new XSGDay();
                    if (!simpleType.isBuiltInType()) {
                        xsGDay.setFacets(simpleType);
                    }
                    return xsGDay;
                }
                case 8: {
                    XSGMonthDay xsGMonthDay = new XSGMonthDay();
                    if (!simpleType.isBuiltInType()) {
                        xsGMonthDay.setFacets(simpleType);
                    }
                    return xsGMonthDay;
                }
                case 10: {
                    XSGMonth xsGMonth = new XSGMonth();
                    if (!simpleType.isBuiltInType()) {
                        xsGMonth.setFacets(simpleType);
                    }
                    return xsGMonth;
                }
                case 6: {
                    XSGYearMonth xsGYearMonth = new XSGYearMonth();
                    if (!simpleType.isBuiltInType()) {
                        xsGYearMonth.setFacets(simpleType);
                    }
                    return xsGYearMonth;
                }
                case 7: {
                    XSGYear xsGYear = new XSGYear();
                    if (!simpleType.isBuiltInType()) {
                        xsGYear.setFacets(simpleType);
                    }
                    return xsGYear;
                }
                case 32: {
                    XSInteger xsInteger = new XSInteger(useWrapper);
                    if (!simpleType.isBuiltInType()) {
                        xsInteger.setFacets(simpleType);
                    }
                    return xsInteger;
                }
                case 36: {
                    XSInt xsInt = new XSInt(useWrapper);
                    if (!simpleType.isBuiltInType()) {
                        xsInt.setFacets(simpleType);
                    }
                    return xsInt;
                }
                case 22: {
                    String warning = "Warning: Currently, the W3C datatype '" + simpleType.getName();
                    warning = warning + "' is supported only as a String by Castor Source Generator.";
                    System.out.println(warning);
                    return new XSString();
                }
                case 35: {
                    XSLong xsLong = new XSLong(useWrapper);
                    if (!simpleType.isBuiltInType()) {
                        xsLong.setFacets(simpleType);
                    }
                    return xsLong;
                }
                case 24: {
                    return new XSNCName();
                }
                case 33: {
                    XSNonPositiveInteger xsInteger = new XSNonPositiveInteger(useWrapper);
                    xsInteger.setFacets(simpleType);
                    return xsInteger;
                }
                case 39: {
                    XSNonNegativeInteger xsInteger = new XSNonNegativeInteger(useWrapper);
                    xsInteger.setFacets(simpleType);
                    return xsInteger;
                }
                case 34: {
                    XSNegativeInteger xsInteger = new XSNegativeInteger(useWrapper);
                    xsInteger.setFacets(simpleType);
                    return xsInteger;
                }
                case 20: {
                    XSNormalizedString xsNormalString = new XSNormalizedString();
                    if (!simpleType.isBuiltInType()) {
                        xsNormalString.setFacets(simpleType);
                    }
                    return xsNormalString;
                }
                case 44: {
                    XSPositiveInteger xsInteger = new XSPositiveInteger(useWrapper);
                    xsInteger.setFacets(simpleType);
                    return xsInteger;
                }
                case 18: {
                    XSQName xsQName = new XSQName();
                    xsQName.setFacets(simpleType);
                    return xsQName;
                }
                case 1: {
                    if (simpleType.hasFacet("enumeration")) {
                        Object typeName = simpleType.getName();
                        if (typeName == null) {
                            Structure parent = simpleType.getParent();
                            if (parent instanceof ElementDecl) {
                                typeName = ((ElementDecl)parent).getName();
                            } else if (parent instanceof AttributeDecl) {
                                typeName = ((AttributeDecl)parent).getName();
                            }
                            typeName = (String)typeName + "Type";
                        }
                        Object className = JavaNaming.toJavaClassName((String)typeName);
                        if (packageName == null) {
                            String ns = simpleType.getSchema().getTargetNamespace();
                            packageName = this._config.lookupPackageByNamespace(ns);
                        }
                        packageName = packageName != null && ((String)packageName).length() > 0 ? (String)packageName + ".types" : TYPES_PACKAGE;
                        className = (String)packageName + "." + (String)className;
                        xsType = new XSClass(new JClass((String)className));
                        xsType.setAsEnumerated(true);
                        break;
                    }
                    XSString xsString = new XSString();
                    if (!simpleType.isBuiltInType()) {
                        xsString.setFacets(simpleType);
                    }
                    xsType = xsString;
                    break;
                }
                case 37: {
                    XSShort xsShort = new XSShort(useWrapper);
                    if (!simpleType.isBuiltInType()) {
                        xsShort.setFacets(simpleType);
                    }
                    return xsShort;
                }
                case 4: {
                    XSTime xsTime = new XSTime();
                    if (!simpleType.isBuiltInType()) {
                        xsTime.setFacets(simpleType);
                    }
                    return xsTime;
                }
                case 21: {
                    Object warning = "Warning: Currently, the W3C datatype 'token'";
                    warning = (String)warning + " is supported only as a String by Castor Source Generator.";
                    System.out.println((String)warning);
                    XSString xsString = new XSString();
                    if (!simpleType.isBuiltInType()) {
                        xsString.setFacets(simpleType);
                    }
                    return xsString;
                }
                default: {
                    String name = simpleType.getName();
                    if (name == null || name.length() == 0) {
                        name = simpleType.getBuiltInBaseType().getName();
                    }
                    String warning = "Warning: The W3C datatype '" + name;
                    warning = warning + "' is not currently supported by Castor Source Generator.";
                    System.out.println(warning);
                    String className = JavaNaming.toJavaClassName(name);
                    xsType = new XSClass(new JClass(className));
                }
            }
        }
        return xsType;
    }

    public static XSType convertType(String javaType) {
        if (javaType == null) {
            return null;
        }
        if (javaType.equals("java.lang.Boolean")) {
            return new XSBoolean(true);
        }
        if (javaType.equals("boolean")) {
            return new XSBoolean(false);
        }
        if (javaType.equals("java.lang.Byte")) {
            return new XSByte(true);
        }
        if (javaType.equals("byte")) {
            return new XSBoolean(false);
        }
        if (javaType.equals("org.exolab.castor.types.Date")) {
            return new XSDateTime();
        }
        if (javaType.equals("org.exolab.castor.types.Guration")) {
            return new XSDuration();
        }
        if (javaType.equals("org.exolab.castor.types.GDay")) {
            return new XSGDay();
        }
        if (javaType.equals("org.exolab.castor.types.GMonth")) {
            return new XSGMonth();
        }
        if (javaType.equals("org.exolab.castor.types.GMonthDay")) {
            return new XSGMonthDay();
        }
        if (javaType.equals("org.exolab.castor.types.GYear")) {
            return new XSGYear();
        }
        if (javaType.equals("org.exolab.castor.types.GYearMonth")) {
            return new XSGYearMonth();
        }
        if (javaType.equals("org.exolab.castor.types.Time")) {
            return new XSTime();
        }
        if (javaType.equals("java.util.Date")) {
            return new XSDate();
        }
        if (javaType.equals("java.math.BigDecimal")) {
            return new XSDecimal();
        }
        if (javaType.equals("java.lang.Double")) {
            return new XSDouble(true);
        }
        if (javaType.equals("double")) {
            return new XSDouble(false);
        }
        if (javaType.equals("java.lang.Float")) {
            return new XSFloat(true);
        }
        if (javaType.equals("float")) {
            return new XSDouble(false);
        }
        if (javaType.equals("java.lang.Integer")) {
            return new XSInteger(true);
        }
        if (javaType.equals("int")) {
            return new XSInt();
        }
        if (javaType.equals("java.lang.Short")) {
            return new XSShort(true);
        }
        if (javaType.equals("short")) {
            return new XSShort(false);
        }
        if (javaType.equals("java.lang.String")) {
            return new XSString();
        }
        return new XSClass(new JClass(javaType));
    }

    private static SimpleType findCommonType(Union union) {
        SimpleType common = null;
        Enumeration enumeration = union.getMemberTypes();
        while (enumeration.hasMoreElements()) {
            SimpleType type = (SimpleType)enumeration.nextElement();
            type = type.getBuiltInBaseType();
            if (common == null) {
                common = type;
                continue;
            }
            if ((common = TypeConversion.compare(common, type)) != null) continue;
            break;
        }
        return common;
    }

    private static SimpleType compare(SimpleType aType, SimpleType bType) {
        int type2;
        int type1 = aType.getTypeCode();
        if (type1 == (type2 = bType.getTypeCode())) {
            return aType;
        }
        if (TypeConversion.isNumeric(aType) ? TypeConversion.isNumeric(bType) : !TypeConversion.isString(aType) || TypeConversion.isString(bType)) {
            // empty if block
        }
        Schema schema = aType.getSchema();
        return schema.getSimpleType("string", schema.getSchemaNamespace());
    }

    private static boolean isNumeric(SimpleType type) {
        int code = type.getTypeCode();
        switch (code) {
            case 14: 
            case 15: 
            case 16: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: {
                return true;
            }
        }
        return false;
    }

    private static boolean isString(SimpleType type) {
        int code = type.getTypeCode();
        switch (code) {
            case 1: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                return true;
            }
        }
        return false;
    }

    private static boolean isDateOrTime(SimpleType type) {
        int code = type.getTypeCode();
        switch (code) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    class TypeNames {
        protected static final String BOOLEAN_PRIMITIVE = "boolean";
        protected static final String BOOLEAN_OBJECT = "java.lang.Boolean";
        protected static final String BYTE_PRIMITIVE = "byte";
        protected static final String BYTE_OBJECT = "java.lang.Byte";
        protected static final String DATE = "java.util.Date";
        protected static final String CASTOR_DATE = "org.exolab.castor.types.Date";
        protected static final String CASTOR_TIME = "org.exolab.castor.types.Time";
        protected static final String CASTOR_DURATION = "org.exolab.castor.types.Guration";
        protected static final String CASTOR_GMONTH = "org.exolab.castor.types.GMonth";
        protected static final String CASTOR_GMONTHDAY = "org.exolab.castor.types.GMonthDay";
        protected static final String CASTOR_GYEAR = "org.exolab.castor.types.GYear";
        protected static final String CASTOR_GYEARMONTH = "org.exolab.castor.types.GYearMonth";
        protected static final String CASTOR_GDAY = "org.exolab.castor.types.GDay";
        protected static final String DECIMAL = "java.math.BigDecimal";
        protected static final String DOUBLE_PRIMITIVE = "double";
        protected static final String DOUBLE_OBJECT = "java.lang.Double";
        protected static final String FLOAT_PRIMITIVE = "float";
        protected static final String FLOAT_OBJECT = "java.lang.Float";
        protected static final String INT = "int";
        protected static final String INTEGER = "java.lang.Integer";
        protected static final String SHORT_PRIMITIVE = "short";
        protected static final String SHORT_OBJECT = "java.lang.Short";
        protected static final String STRING = "java.lang.String";

        TypeNames() {
        }
    }
}

