/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.wrappers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public class TextFileWindow {
    private int pre;
    private int post;
    private int total;
    private int read = 0;
    BufferedReader in = null;
    Vector prew = null;
    Vector postw = null;

    public TextFileWindow(int pre, int post, File file) throws IOException {
        String str;
        this.pre = pre;
        this.post = post;
        this.total = pre + post + 1;
        this.prew = new Vector();
        this.postw = new Vector();
        this.in = new BufferedReader(new FileReader(file));
        while (this.prew.size() < pre && (str = this.in.readLine()) != null) {
            this.prew.add(str);
        }
        while (this.postw.size() < post && (str = this.in.readLine()) != null) {
            this.postw.add(str);
        }
    }

    public String readLine() throws IOException {
        if (this.read > this.prew.size() - 1) {
            return null;
        }
        String result = (String)this.prew.get(this.read);
        if (this.read < this.prew.size() - 1) {
            ++this.read;
        } else {
            String str;
            String removed = (String)this.prew.remove(0);
            if (this.postw.size() > 0) {
                String moved = (String)this.postw.remove(0);
                this.prew.add(moved);
            }
            while (this.postw.size() < this.post && (str = this.in.readLine()) != null) {
                this.postw.add(str);
            }
        }
        return result;
    }

    public String readWindow() {
        Object result = "";
        Iterator iter = this.prew.iterator();
        while (iter.hasNext()) {
            result = (String)result + (String)iter.next() + "\n";
        }
        iter = this.postw.iterator();
        while (iter.hasNext()) {
            result = (String)result + (String)iter.next() + "\n";
        }
        return result;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

