/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.oracle;

import alma.archive.database.helpers.DatabaseHelper;
import alma.archive.database.interfaces.DBCursor;
import alma.archive.database.oracle.DatabaseConnectionPool;
import alma.archive.exceptions.cursor.CursorClosedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.wrappers.ResultStruct;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import oracle.xdb.XMLType;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.expr.Step;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class CursorImpl
implements DBCursor {
    private static final SAXBuilder builder = new SAXBuilder();
    private final Logger logger;
    private final DatabaseConnectionPool connectionPool;
    private final Connection connection;
    private final ResultSet rSet;
    private final String user;
    private boolean closed;
    private ResultStruct nextResult;
    private BaseXPath lastStep;
    private Iterator<?> resultStack;
    private URI resultStackUri;

    public CursorImpl(Logger logger, DatabaseConnectionPool connectionPool, ResultSet rSet, Connection connection, String user) {
        this.logger = logger;
        this.connectionPool = connectionPool;
        this.connection = connection;
        this.user = user;
        this.rSet = rSet;
    }

    @Override
    public boolean hasNext() throws DatabaseException {
        if (this.nextResult == null) {
            this.nextResult = this.fetchNextResult();
        }
        return this.nextResult != null;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.rSet.close();
            }
            catch (SQLException e) {
                this.logger.info("Ignoring exception: " + e.toString());
            }
            try {
                this.connectionPool.close(this.connection);
            }
            catch (SQLException e) {
                this.logger.info("Ignoring exception: " + e.toString());
            }
        }
    }

    protected void reevaluateLastStep(Step last) throws DatabaseException {
        try {
            this.lastStep = new JDOMXPath("*/" + last.getText());
        }
        catch (JaxenException e) {
            String msg = "Could not create XPath out of " + last.toString();
            this.logger.warning(msg);
            throw new DatabaseException(msg);
        }
    }

    @Override
    public ResultStruct next() throws DatabaseException, CursorClosedException {
        if (this.nextResult == null) {
            this.nextResult = this.fetchNextResult();
        }
        if (this.closed) {
            throw new CursorClosedException();
        }
        ResultStruct out = this.nextResult;
        this.nextResult = null;
        return out;
    }

    @Override
    public ResultStruct[] nextBlock(int size) throws DatabaseException {
        ResultStruct[] ret = new ResultStruct[size];
        for (int count = 0; count < size && this.hasNext() && !this.closed; ++count) {
            try {
                ret[count] = this.next();
                continue;
            }
            catch (CursorClosedException cursorClosedException) {
                // empty catch block
            }
        }
        return ret;
    }

    private ResultStruct fetchNextResult() throws DatabaseException {
        ResultStruct out = null;
        if (this.resultStack != null && this.resultStack.hasNext()) {
            out = new ResultStruct(this.resultStackUri, this.getValue(this.resultStack.next()));
        } else {
            this.resultStack = null;
            try {
                if (this.closed || !this.rSet.next()) {
                    this.close();
                } else if (this.checkPermission()) {
                    String uidStr = this.rSet.getString("archive_uid");
                    try {
                        out = this.extractResult(uidStr);
                    }
                    catch (URISyntaxException e) {
                        this.logger.warning("Found invalid UID in database: " + uidStr + ". Will not be part of query result.");
                        out = this.fetchNextResult();
                    }
                } else {
                    out = this.fetchNextResult();
                }
            }
            catch (SQLException e) {
                this.logger.warning("SQL Exception: " + e);
                throw new DatabaseException("Could not retrieve next result from cursor.", e);
            }
        }
        return out;
    }

    private ResultStruct extractResult(String uidStr) throws SQLException, DatabaseException, URISyntaxException {
        ResultStruct out = null;
        URI uid = new URI(uidStr);
        String xml = ((XMLType)this.rSet.getObject("xml")).getStringVal();
        if (this.lastStep != null) {
            xml = this.applayLastStep(uid, xml);
        }
        if (xml != null) {
            out = new ResultStruct(uid, xml);
        }
        return out;
    }

    private String applayLastStep(URI uid, String xml) throws DatabaseException {
        String resultXml = null;
        try {
            Object result = this.lastStep.evaluate((Object)builder.build((Reader)new StringReader(xml)));
            if (result instanceof Collection) {
                this.resultStack = ((List)result).iterator();
                if (!this.resultStack.hasNext()) {
                    this.resultStack = null;
                    throw new DatabaseException("Unexpected failure of XPath handling in CursorImpl for content queries.");
                }
                this.resultStackUri = uid;
                resultXml = this.getValue(this.resultStack.next());
            } else if (result != null) {
                resultXml = this.getValue(result);
            }
        }
        catch (JaxenException e) {
            this.logger.warning("Could not evaluate XPath " + this.lastStep.toString() + " on document.");
            throw new DatabaseException("Could not evaluate XPath " + this.lastStep.toString() + " on document.", e);
        }
        catch (JDOMException e) {
            this.logger.warning("Could not parse document retrieved from Oracle. ");
            throw new DatabaseException("Could not parse document retrieved from Oracle.", e);
        }
        catch (IOException e) {
            throw new DatabaseException("Caught IOException when reading String. This should NEVER happen!", e);
        }
        return resultXml;
    }

    private String getValue(Object o) {
        String value = null;
        try {
            value = o.getClass().getMethod("getValue", new Class[0]).invoke(o, new Object[0]).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (value == null) {
            value = o.toString();
        }
        return value;
    }

    private boolean checkPermission() throws SQLException {
        String readPermissions = this.rSet.getString("readPermissions");
        String owner = this.rSet.getString("owner");
        return DatabaseHelper.checkAccessPermissions(this.user, readPermissions, owner);
    }
}

