/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import com.microstar.xml.HandlerBase;
import gnu.regexp.RE;
import gnu.regexp.REException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Stack;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ParserRule;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.util.Log;

public abstract class XModeHandler
extends HandlerBase {
    private String modeName;
    private TokenMarker marker;
    private KeywordMap keywords;
    private Stack stateStack;
    private String propName;
    private String propValue;
    private Hashtable props;
    private Hashtable modeProps;
    private String lastStart;
    private String lastEnd;
    private String lastKeyword;
    private String lastSetName;
    private String lastEscape;
    private ParserRuleSet lastDelegateSet;
    private String lastNoWordSep;
    private ParserRuleSet rules;
    private byte lastDefaultID = 0;
    private byte lastTokenID;
    private int termChar = -1;
    private boolean lastNoLineBreak;
    private boolean lastNoWordBreak;
    private boolean lastExcludeMatch;
    private boolean lastIgnoreCase = true;
    private boolean lastHighlightDigits;
    private boolean lastAtLineStart;
    private boolean lastAtWhitespaceEnd;
    private boolean lastAtWordStart;
    private boolean lastNoEscape;
    private int lastStartPosMatch;
    private int lastEndPosMatch;
    private String lastDigitRE;
    private char lastHashChar;

    public XModeHandler(String modeName) {
        this.modeName = modeName;
        this.marker = new TokenMarker();
        this.marker.addRuleSet(new ParserRuleSet(modeName, "MAIN"));
        this.stateStack = new Stack();
        this.lastNoWordSep = "_";
    }

    public Object resolveEntity(String publicId, String systemId) {
        if ("xmode.dtd".equals(systemId)) {
            return new StringReader("<!-- -->");
        }
        return null;
    }

    public void attribute(String aname, String value, boolean isSpecified) {
        String string = aname = aname == null ? null : aname.intern();
        if (aname == "NAME") {
            this.propName = value;
        } else if (aname == "VALUE") {
            this.propValue = value;
        } else if (aname == "TYPE") {
            this.lastTokenID = Token.stringToToken(value);
            if (this.lastTokenID == -1) {
                this.error("token-invalid", value);
            }
        } else if (aname == "AT_LINE_START") {
            this.lastAtLineStart = isSpecified ? value.equals("TRUE") : false;
        } else if (aname == "AT_WHITESPACE_END") {
            this.lastAtWhitespaceEnd = isSpecified ? value.equals("TRUE") : false;
        } else if (aname == "AT_WORD_START") {
            this.lastAtWordStart = isSpecified ? value.equals("TRUE") : false;
        } else if (aname == "NO_LINE_BREAK") {
            this.lastNoLineBreak = isSpecified ? value.equals("TRUE") : false;
        } else if (aname == "NO_WORD_BREAK") {
            this.lastNoWordBreak = isSpecified ? value.equals("TRUE") : false;
        } else if (aname == "NO_ESCAPE") {
            this.lastNoEscape = isSpecified ? value.equals("TRUE") : false;
        } else if (aname == "EXCLUDE_MATCH") {
            this.lastExcludeMatch = isSpecified ? value.equals("TRUE") : false;
        } else if (aname == "IGNORE_CASE") {
            this.lastIgnoreCase = isSpecified ? value.equals("TRUE") : true;
        } else if (aname == "HIGHLIGHT_DIGITS") {
            this.lastHighlightDigits = isSpecified ? value.equals("TRUE") : false;
        } else if (aname == "DIGIT_RE") {
            this.lastDigitRE = value;
        } else if (aname == "NO_WORD_SEP") {
            if (isSpecified) {
                this.lastNoWordSep = value;
            }
        } else if (aname == "AT_CHAR") {
            try {
                if (isSpecified) {
                    this.termChar = Integer.parseInt(value);
                }
            }
            catch (NumberFormatException e) {
                this.error("termchar-invalid", value);
                this.termChar = -1;
            }
        } else if (aname == "ESCAPE") {
            this.lastEscape = value;
        } else if (aname == "SET") {
            this.lastSetName = value;
        } else if (aname == "DELEGATE") {
            if (value != null) {
                String delegateSetName;
                String delegateMode;
                int index = value.indexOf("::");
                if (index != -1) {
                    delegateMode = value.substring(0, index);
                    delegateSetName = value.substring(index + 2);
                } else {
                    delegateMode = this.modeName;
                    delegateSetName = value;
                }
                TokenMarker delegateMarker = this.getTokenMarker(delegateMode);
                if (delegateMarker == null) {
                    this.error("delegate-invalid", value);
                } else {
                    this.lastDelegateSet = delegateMarker.getRuleSet(delegateSetName);
                    if (delegateMarker == this.marker && this.lastDelegateSet == null) {
                        this.lastDelegateSet = new ParserRuleSet(delegateMode, delegateSetName);
                        this.lastDelegateSet.setDefault((byte)7);
                        this.marker.addRuleSet(this.lastDelegateSet);
                    } else if (this.lastDelegateSet == null) {
                        this.error("delegate-invalid", value);
                    }
                }
            }
        } else if (aname == "DEFAULT") {
            this.lastDefaultID = Token.stringToToken(value);
            if (this.lastDefaultID == -1) {
                this.error("token-invalid", value);
                this.lastDefaultID = 0;
            }
        } else if (aname == "HASH_CHAR") {
            if (value.length() != 1) {
                this.error("hash-char-invalid", value);
                this.lastDefaultID = 0;
            } else {
                this.lastHashChar = value.charAt(0);
            }
        }
    }

    public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
        if ("MODE".equalsIgnoreCase(name)) {
            return;
        }
        this.error("doctype-invalid", name);
    }

    public void charData(char[] c, int off, int len) {
        String tag = this.peekElement();
        String text = new String(c, off, len);
        if (tag == "EOL_SPAN" || tag == "EOL_SPAN_REGEXP" || tag == "MARK_PREVIOUS" || tag == "MARK_FOLLOWING" || tag == "SEQ" || tag == "SEQ_REGEXP" || tag == "BEGIN") {
            this.lastStart = text;
            this.lastStartPosMatch = (this.lastAtLineStart ? 2 : 0) | (this.lastAtWhitespaceEnd ? 4 : 0) | (this.lastAtWordStart ? 8 : 0);
            this.lastAtLineStart = false;
            this.lastAtWordStart = false;
            this.lastAtWhitespaceEnd = false;
        } else if (tag == "END") {
            this.lastEnd = text;
            this.lastEndPosMatch = (this.lastAtLineStart ? 2 : 0) | (this.lastAtWhitespaceEnd ? 4 : 0) | (this.lastAtWordStart ? 8 : 0);
            this.lastAtLineStart = false;
            this.lastAtWordStart = false;
            this.lastAtWhitespaceEnd = false;
        } else {
            this.lastKeyword = text;
        }
    }

    public void startElement(String tag) {
        if ((tag = this.pushElement(tag)) == "WHITESPACE") {
            Log.log(7, this, this.modeName + ": WHITESPACE rule " + "no longer needed");
        } else if (tag == "KEYWORDS") {
            this.keywords = new KeywordMap(this.rules.getIgnoreCase());
        } else if (tag == "RULES") {
            if (this.lastSetName == null) {
                this.lastSetName = "MAIN";
            }
            this.rules = this.marker.getRuleSet(this.lastSetName);
            if (this.rules == null) {
                this.rules = new ParserRuleSet(this.modeName, this.lastSetName);
                this.marker.addRuleSet(this.rules);
            }
            this.rules.setIgnoreCase(this.lastIgnoreCase);
            this.rules.setHighlightDigits(this.lastHighlightDigits);
            if (this.lastDigitRE != null) {
                try {
                    this.rules.setDigitRegexp(new RE(this.lastDigitRE, this.lastIgnoreCase ? 2 : 0, ParserRule.RE_SYNTAX_JEDIT));
                }
                catch (REException e) {
                    this.error("regexp", e);
                }
            }
            if (this.lastEscape != null) {
                this.rules.setEscapeRule(ParserRule.createEscapeRule(this.lastEscape));
            }
            this.rules.setDefault(this.lastDefaultID);
            this.rules.setNoWordSep(this.lastNoWordSep);
        }
    }

    public void endElement(String name) {
        if (name == null) {
            return;
        }
        String tag = this.popElement();
        if (name.equals(tag)) {
            if (tag == "PROPERTY") {
                this.props.put(this.propName, this.propValue);
            } else if (tag == "PROPS") {
                if (this.peekElement().equals("RULES")) {
                    this.rules.setProperties(this.props);
                } else {
                    this.modeProps = this.props;
                }
                this.props = new Hashtable();
            } else if (tag == "RULES") {
                this.rules.setKeywords(this.keywords);
                this.keywords = null;
                this.lastSetName = null;
                this.lastEscape = null;
                this.lastIgnoreCase = true;
                this.lastHighlightDigits = false;
                this.lastDigitRE = null;
                this.lastDefaultID = 0;
                this.lastNoWordSep = "_";
                this.rules = null;
            } else if (tag == "IMPORT") {
                this.rules.addRuleSet(this.lastDelegateSet);
                this.lastDelegateSet = null;
            } else if (tag == "TERMINATE") {
                this.rules.setTerminateChar(this.termChar);
                this.termChar = -1;
            } else if (tag == "SEQ") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "SEQ");
                    return;
                }
                this.rules.addRule(ParserRule.createSequenceRule(this.lastStartPosMatch, this.lastStart, this.lastDelegateSet, this.lastTokenID));
                this.reset();
            } else if (tag == "SEQ_REGEXP") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "SEQ_REGEXP");
                    return;
                }
                try {
                    this.rules.addRule(ParserRule.createRegexpSequenceRule(this.lastHashChar, this.lastStartPosMatch, this.lastStart, this.lastDelegateSet, this.lastTokenID, this.lastIgnoreCase));
                }
                catch (REException re) {
                    this.error("regexp", re);
                }
                this.reset();
            } else if (tag == "SPAN") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "BEGIN");
                    return;
                }
                if (this.lastEnd == null) {
                    this.error("empty-tag", "END");
                    return;
                }
                this.rules.addRule(ParserRule.createSpanRule(this.lastStartPosMatch, this.lastStart, this.lastEndPosMatch, this.lastEnd, this.lastDelegateSet, this.lastTokenID, this.lastExcludeMatch, this.lastNoLineBreak, this.lastNoWordBreak, this.lastNoEscape));
                this.reset();
            } else if (tag == "SPAN_REGEXP") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "BEGIN");
                    return;
                }
                if (this.lastEnd == null) {
                    this.error("empty-tag", "END");
                    return;
                }
                try {
                    this.rules.addRule(ParserRule.createRegexpSpanRule(this.lastHashChar, this.lastStartPosMatch, this.lastStart, this.lastEndPosMatch, this.lastEnd, this.lastDelegateSet, this.lastTokenID, this.lastExcludeMatch, this.lastNoLineBreak, this.lastNoWordBreak, this.lastIgnoreCase, this.lastNoEscape));
                }
                catch (REException re) {
                    this.error("regexp", re);
                }
                this.reset();
            } else if (tag == "EOL_SPAN") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "EOL_SPAN");
                    return;
                }
                this.rules.addRule(ParserRule.createEOLSpanRule(this.lastStartPosMatch, this.lastStart, this.lastDelegateSet, this.lastTokenID, this.lastExcludeMatch));
                this.reset();
            } else if (tag == "EOL_SPAN_REGEXP") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "EOL_SPAN_REGEXP");
                    return;
                }
                try {
                    this.rules.addRule(ParserRule.createRegexpEOLSpanRule(this.lastHashChar, this.lastStartPosMatch, this.lastStart, this.lastDelegateSet, this.lastTokenID, this.lastExcludeMatch, this.lastIgnoreCase));
                }
                catch (REException re) {
                    this.error("regexp", re);
                }
                this.reset();
            } else if (tag == "MARK_FOLLOWING") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "MARK_FOLLOWING");
                    return;
                }
                this.rules.addRule(ParserRule.createMarkFollowingRule(this.lastStartPosMatch, this.lastStart, this.lastTokenID, this.lastExcludeMatch));
                this.reset();
            } else if (tag == "MARK_PREVIOUS") {
                if (this.lastStart == null) {
                    this.error("empty-tag", "MARK_PREVIOUS");
                    return;
                }
                this.rules.addRule(ParserRule.createMarkPreviousRule(this.lastStartPosMatch, this.lastStart, this.lastTokenID, this.lastExcludeMatch));
                this.reset();
            } else {
                byte token = Token.stringToToken(tag);
                if (token != -1) {
                    this.addKeyword(this.lastKeyword, token);
                }
            }
        } else {
            throw new InternalError();
        }
    }

    public void startDocument() {
        this.props = new Hashtable();
        this.pushElement(null);
    }

    public void endDocument() {
        ParserRuleSet[] rulesets = this.marker.getRuleSets();
        for (int i = 0; i < rulesets.length; ++i) {
            rulesets[i].resolveImports();
        }
    }

    public TokenMarker getTokenMarker() {
        return this.marker;
    }

    public Hashtable getModeProperties() {
        return this.modeProps;
    }

    protected abstract void error(String var1, Object var2);

    protected abstract TokenMarker getTokenMarker(String var1);

    private void reset() {
        this.lastHashChar = '\u0000';
        this.lastStartPosMatch = 0;
        this.lastStart = null;
        this.lastEndPosMatch = 0;
        this.lastEnd = null;
        this.lastDelegateSet = null;
        this.lastTokenID = 0;
        this.lastExcludeMatch = false;
        this.lastNoLineBreak = false;
        this.lastNoWordBreak = false;
        this.lastNoEscape = false;
    }

    private void addKeyword(String k, byte id) {
        if (k == null) {
            this.error("empty-keyword", null);
            return;
        }
        if (this.keywords == null) {
            return;
        }
        this.keywords.add(k, id);
    }

    private String pushElement(String name) {
        name = name == null ? null : name.intern();
        this.stateStack.push(name);
        return name;
    }

    private String peekElement() {
        return (String)this.stateStack.peek();
    }

    private String popElement() {
        return (String)this.stateStack.pop();
    }
}

