/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.search.HyperSearchResult;

public class HyperSearchResults
extends JPanel
implements EBComponent,
DefaultFocusComponent {
    public static final String NAME = "hypersearch-results";
    private View view;
    private JLabel caption;
    private JTree resultTree;
    private DefaultMutableTreeNode resultTreeRoot;
    private DefaultTreeModel resultTreeModel;
    private RolloverButton clear;
    private RolloverButton multi;
    private boolean multiStatus;

    public HyperSearchResults(View view) {
        super(new BorderLayout());
        this.view = view;
        this.caption = new JLabel();
        Box toolBar = new Box(0);
        toolBar.add(this.caption);
        toolBar.add(Box.createGlue());
        ActionHandler ah = new ActionHandler();
        this.clear = new RolloverButton(GUIUtilities.loadIcon("Clear.png"));
        this.clear.setToolTipText(jEdit.getProperty("hypersearch-results.clear.label"));
        this.clear.addActionListener(ah);
        toolBar.add(this.clear);
        this.multi = new RolloverButton();
        this.multi.setToolTipText(jEdit.getProperty("hypersearch-results.multi.label"));
        this.multi.addActionListener(ah);
        toolBar.add(this.multi);
        this.add("North", toolBar);
        this.resultTreeRoot = new DefaultMutableTreeNode();
        this.resultTreeModel = new DefaultTreeModel(this.resultTreeRoot);
        this.resultTree = new JTree(this.resultTreeModel);
        this.resultTree.setCellRenderer(new ResultCellRenderer());
        this.resultTree.setVisibleRowCount(16);
        this.resultTree.setRootVisible(false);
        this.resultTree.setShowsRootHandles(true);
        if (!OperatingSystem.isMacOSLF()) {
            this.resultTree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.resultTree.setEditable(false);
        this.resultTree.addKeyListener(new KeyHandler());
        this.resultTree.addMouseListener(new MouseHandler());
        JScrollPane scrollPane = new JScrollPane(this.resultTree);
        Dimension dim = scrollPane.getPreferredSize();
        dim.width = 400;
        scrollPane.setPreferredSize(dim);
        this.add("Center", scrollPane);
    }

    public void focusOnDefaultComponent() {
        this.resultTree.requestFocus();
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
        this.multiStatus = jEdit.getBooleanProperty("hypersearch-results.multi");
        this.updateMultiStatus();
    }

    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus(this);
        jEdit.setBooleanProperty("hypersearch-results.multi", this.multiStatus);
    }

    private void visitBuffers(ResultVisitor visitor, Buffer buffer) {
        for (int i = this.resultTreeRoot.getChildCount() - 1; i >= 0; --i) {
            DefaultMutableTreeNode searchNode = (DefaultMutableTreeNode)this.resultTreeRoot.getChildAt(i);
            for (int j = searchNode.getChildCount() - 1; j >= 0; --j) {
                DefaultMutableTreeNode bufferNode = (DefaultMutableTreeNode)searchNode.getChildAt(j);
                for (int k = bufferNode.getChildCount() - 1; k >= 0; --k) {
                    Object userObject = ((DefaultMutableTreeNode)bufferNode.getChildAt(k)).getUserObject();
                    HyperSearchResult result = (HyperSearchResult)userObject;
                    if (!result.pathEquals(buffer.getSymlinkPath())) continue;
                    visitor.visit(buffer, result);
                }
            }
        }
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof BufferUpdate) {
            BufferUpdate bmsg = (BufferUpdate)msg;
            Buffer buffer = bmsg.getBuffer();
            Object what = bmsg.getWhat();
            if (what == BufferUpdate.LOADED || what == BufferUpdate.CLOSED) {
                ResultVisitor visitor = null;
                visitor = what == BufferUpdate.LOADED ? new BufferLoadedVisitor() : new BufferClosedVisitor();
                this.visitBuffers(visitor, buffer);
            }
        }
    }

    public DefaultTreeModel getTreeModel() {
        return this.resultTreeModel;
    }

    public JTree getTree() {
        return this.resultTree;
    }

    public void searchStarted() {
        this.caption.setText(jEdit.getProperty("hypersearch-results.searching"));
    }

    public void searchFailed() {
        this.caption.setText(jEdit.getProperty("hypersearch-results.no-results"));
        for (int i = 0; i < this.resultTreeRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.resultTreeRoot.getChildAt(i);
            this.resultTree.collapsePath(new TreePath(new Object[]{this.resultTreeRoot, node}));
        }
    }

    public void searchDone(final DefaultMutableTreeNode searchNode) {
        final int nodeCount = searchNode.getChildCount();
        if (nodeCount < 1) {
            this.searchFailed();
            return;
        }
        this.caption.setText(jEdit.getProperty("hypersearch-results.done"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!HyperSearchResults.this.multiStatus) {
                    for (int i = 0; i < HyperSearchResults.this.resultTreeRoot.getChildCount(); ++i) {
                        HyperSearchResults.this.resultTreeRoot.remove(0);
                    }
                }
                HyperSearchResults.this.resultTreeRoot.add(searchNode);
                HyperSearchResults.this.resultTreeModel.reload(HyperSearchResults.this.resultTreeRoot);
                TreePath lastNode = null;
                for (int i = 0; i < nodeCount; ++i) {
                    lastNode = new TreePath(((DefaultMutableTreeNode)searchNode.getChildAt(i)).getPath());
                    HyperSearchResults.this.resultTree.expandPath(lastNode);
                }
                HyperSearchResults.this.resultTree.scrollPathToVisible(new TreePath(new Object[]{HyperSearchResults.this.resultTreeRoot, searchNode}));
            }
        });
    }

    private void updateMultiStatus() {
        if (this.multiStatus) {
            this.multi.setIcon(GUIUtilities.loadIcon("MultipleResults.png"));
        } else {
            this.multi.setIcon(GUIUtilities.loadIcon("SingleResult.png"));
        }
    }

    private void goToSelectedNode() {
        TreePath path = this.resultTree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object value = node.getUserObject();
        if (node.getParent() != this.resultTreeRoot) {
            if (value instanceof String) {
                Buffer buffer = jEdit.openFile(this.view, (String)value);
                if (buffer == null) {
                    return;
                }
                this.view.goToBuffer(buffer);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        HyperSearchResults.this.resultTree.requestFocus();
                    }
                });
            } else if (value instanceof HyperSearchResult) {
                ((HyperSearchResult)value).goTo(this.view);
            }
        }
    }

    class BufferClosedVisitor
    implements ResultVisitor {
        BufferClosedVisitor() {
        }

        public void visit(Buffer buffer, HyperSearchResult result) {
            result.bufferClosed();
        }
    }

    class BufferLoadedVisitor
    implements ResultVisitor {
        BufferLoadedVisitor() {
        }

        public void visit(Buffer buffer, HyperSearchResult result) {
            result.bufferOpened(buffer);
        }
    }

    static interface ResultVisitor {
        public void visit(Buffer var1, HyperSearchResult var2);
    }

    class ResultCellRenderer
    extends DefaultTreeCellRenderer {
        Font plainFont = UIManager.getFont("Tree.font");
        Font boldFont;

        ResultCellRenderer() {
            if (this.plainFont == null) {
                this.plainFont = jEdit.getFontProperty("metal.secondary.font");
            }
            this.boldFont = new Font(this.plainFont.getName(), 1, this.plainFont.getSize());
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getParent() == HyperSearchResults.this.resultTreeRoot) {
                this.setFont(this.boldFont);
                int bufferCount = node.getChildCount();
                int resultCount = 0;
                for (int i = 0; i < bufferCount; ++i) {
                    resultCount += node.getChildAt(i).getChildCount();
                }
                String property = "hypersearch-results.result-caption";
                if (bufferCount == 1) {
                    property = property + (resultCount == 1 ? "1" : "2");
                }
                Object[] pp = new Object[]{node.toString(), new Integer(resultCount), new Integer(bufferCount)};
                this.setText(jEdit.getProperty(property, pp));
            } else if (node.getUserObject() instanceof String) {
                this.setFont(this.boldFont);
                int count = node.getChildCount();
                if (count == 1) {
                    this.setText(jEdit.getProperty("hypersearch-results.file-caption1", new Object[]{node.getUserObject()}));
                } else {
                    this.setText(jEdit.getProperty("hypersearch-results.file-caption", new Object[]{node.getUserObject(), new Integer(count)}));
                }
            } else {
                this.setFont(this.plainFont);
            }
            return this;
        }
    }

    class RemoveAllTreeNodesAction
    extends AbstractAction {
        public RemoveAllTreeNodesAction() {
            super(jEdit.getProperty("hypersearch-results.remove-all-nodes"));
        }

        public void actionPerformed(ActionEvent evt) {
            HyperSearchResults.this.resultTreeRoot = new DefaultMutableTreeNode();
            HyperSearchResults.this.resultTreeModel = new DefaultTreeModel(HyperSearchResults.this.resultTreeRoot);
            HyperSearchResults.this.resultTree.setModel(HyperSearchResults.this.resultTreeModel);
        }
    }

    class RemoveTreeNodeAction
    extends AbstractAction {
        public RemoveTreeNodeAction() {
            super(jEdit.getProperty("hypersearch-results.remove-node"));
        }

        public void actionPerformed(ActionEvent evt) {
            TreePath path = HyperSearchResults.this.resultTree.getSelectionPath();
            if (path == null) {
                return;
            }
            MutableTreeNode value = (MutableTreeNode)path.getLastPathComponent();
            HyperSearchResults.this.resultTreeModel.removeNodeFromParent(value);
        }
    }

    class MouseHandler
    extends MouseAdapter {
        private JPopupMenu popupMenu;

        MouseHandler() {
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            TreePath path1 = HyperSearchResults.this.resultTree.getPathForLocation(evt.getX(), evt.getY());
            if (path1 == null) {
                return;
            }
            HyperSearchResults.this.resultTree.setSelectionPath(path1);
            if (GUIUtilities.isPopupTrigger(evt)) {
                this.showPopupMenu(evt);
            } else {
                HyperSearchResults.this.goToSelectedNode();
                HyperSearchResults.this.view.toFront();
                HyperSearchResults.this.view.requestFocus();
                HyperSearchResults.this.view.getTextArea().requestFocus();
            }
        }

        private void showPopupMenu(MouseEvent evt) {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
                this.popupMenu.add(new RemoveTreeNodeAction());
            }
            GUIUtilities.showPopupMenu(this.popupMenu, evt.getComponent(), evt.getX(), evt.getY());
            evt.consume();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 10) {
                HyperSearchResults.this.goToSelectedNode();
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ KeyHandler this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        HyperSearchResults.access$300(KeyHandler.access$800(this.this$1)).requestFocus();
                    }
                });
                evt.consume();
            }
        }

        static /* synthetic */ HyperSearchResults access$800(KeyHandler x0) {
            return x0.HyperSearchResults.this;
        }
    }

    public class ActionHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == HyperSearchResults.this.clear) {
                HyperSearchResults.this.resultTreeRoot.removeAllChildren();
                HyperSearchResults.this.resultTreeModel.reload(HyperSearchResults.this.resultTreeRoot);
            } else if (source == HyperSearchResults.this.multi) {
                HyperSearchResults.this.multiStatus = !HyperSearchResults.this.multiStatus;
                HyperSearchResults.this.updateMultiStatus();
                if (!HyperSearchResults.this.multiStatus) {
                    for (int i = HyperSearchResults.this.resultTreeRoot.getChildCount() - 2; i >= 0; --i) {
                        HyperSearchResults.this.resultTreeModel.removeNodeFromParent((MutableTreeNode)HyperSearchResults.this.resultTreeRoot.getChildAt(i));
                    }
                }
            }
        }
    }
}

