/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.SwingUtilities;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.DisplayTokenHandler;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.util.Log;

class BufferPrintable
implements Printable {
    private static Color headerColor = Color.lightGray;
    private static Color headerTextColor = Color.black;
    private static Color footerColor = Color.lightGray;
    private static Color footerTextColor = Color.black;
    private static Color lineNumberColor = Color.gray;
    private static Color textColor = Color.black;
    private PrinterJob job;
    private Object format;
    private View view;
    private Buffer buffer;
    private Font font;
    private SyntaxStyle[] styles;
    private boolean header;
    private boolean footer;
    private boolean lineNumbers;
    private int currentPage;
    private int currentPageStart;
    private int currentPhysicalLine;
    private boolean end;
    private LineMetrics lm;
    private ArrayList lineList;
    private FontRenderContext frc;
    private DisplayTokenHandler tokenHandler;
    static /* synthetic */ Class class$java$awt$print$PrinterJob;

    BufferPrintable(PrinterJob job, Object format, View view, Buffer buffer, Font font, boolean header, boolean footer, boolean lineNumbers, boolean color) {
        this.job = job;
        this.format = format;
        this.view = view;
        this.buffer = buffer;
        this.font = font;
        this.header = header;
        this.footer = footer;
        this.lineNumbers = lineNumbers;
        this.styles = GUIUtilities.loadStyles(jEdit.getProperty("print.font"), jEdit.getIntegerProperty("print.fontsize", 10), color);
        this.styles[0] = new SyntaxStyle(textColor, null, font);
        for (int i = 0; i < this.styles.length; ++i) {
            SyntaxStyle s = this.styles[i];
            if (!s.getForegroundColor().equals(Color.WHITE) || s.getBackgroundColor() != null) continue;
            this.styles[i] = new SyntaxStyle(Color.BLACK, this.styles[i].getBackgroundColor(), this.styles[i].getFont());
        }
        this.lineList = new ArrayList();
        this.tokenHandler = new DisplayTokenHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        block6: {
            try {
                if (this.format == null) {
                    this.job.print();
                    break block6;
                }
                Method method = (class$java$awt$print$PrinterJob == null ? (class$java$awt$print$PrinterJob = BufferPrintable.class$("java.awt.print.PrinterJob")) : class$java$awt$print$PrinterJob).getMethod("print", Class.forName("javax.print.attribute.PrintRequestAttributeSet"));
                method.invoke((Object)this.job, this.format);
            }
            catch (PrinterAbortException ae) {
                Log.log(1, this, ae);
            }
            catch (Exception e) {
                Log.log(9, this, e);
                final String[] args = new String[]{e.toString()};
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GUIUtilities.error(BufferPrintable.this.view, "print-error", args);
                    }
                });
            }
        }
    }

    public int print(Graphics _gfx, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.frc == null) {
            this.frc = ((Graphics2D)_gfx).getFontRenderContext();
            Log.log(1, this, "Font render context is " + this.frc);
        }
        Log.log(1, this, "Asked to print page " + pageIndex);
        Log.log(1, this, "Current page is " + this.currentPage);
        if (pageIndex > this.currentPage) {
            for (int i = this.currentPage; i < pageIndex; ++i) {
                Log.log(1, this, "Current physical line is now " + this.currentPageStart);
                this.currentPhysicalLine = this.currentPageStart;
                this.printPage(_gfx, pageFormat, i, true);
            }
            this.currentPage = pageIndex - 1;
            Log.log(1, this, "Current page is now " + this.currentPage);
        }
        if (pageIndex == this.currentPage + 1) {
            if (this.end) {
                Log.log(1, this, "The end");
                return 1;
            }
            this.currentPageStart = this.currentPhysicalLine;
            Log.log(1, this, "#2 - Current physical line is now " + this.currentPageStart);
            this.currentPage = pageIndex;
            Log.log(1, this, "#2 - Current page is now " + this.currentPage);
        } else if (pageIndex == this.currentPage) {
            this.currentPhysicalLine = this.currentPageStart;
            Log.log(1, this, "#3 - Current physical line is now " + this.currentPageStart);
        }
        this.printPage(_gfx, pageFormat, pageIndex, true);
        return 0;
    }

    private void printPage(Graphics _gfx, PageFormat pageFormat, int pageIndex, boolean actuallyPaint) {
        double lineNumberWidth;
        int i;
        char[] chars;
        Log.log(1, this, "printPage(" + pageIndex + "," + actuallyPaint + ")");
        Graphics2D gfx = (Graphics2D)_gfx;
        gfx.setFont(this.font);
        double pageX = pageFormat.getImageableX();
        double pageY = pageFormat.getImageableY();
        double pageWidth = pageFormat.getImageableWidth();
        double pageHeight = pageFormat.getImageableHeight();
        Log.log(1, this, "#1 - Page dimensions: " + pageWidth + "x" + pageHeight);
        if (this.header) {
            double headerHeight = this.paintHeader(gfx, pageX, pageY, pageWidth, actuallyPaint);
            pageY += headerHeight;
            pageHeight -= headerHeight;
        }
        if (this.footer) {
            double footerHeight = this.paintFooter(gfx, pageX, pageY, pageWidth, pageHeight, pageIndex, actuallyPaint);
            pageHeight -= footerHeight;
        }
        boolean glyphVector = jEdit.getBooleanProperty("print.glyphVector");
        if (this.lineNumbers) {
            int lineNumberDigits = (int)Math.ceil(Math.log(this.buffer.getLineCount() + 1) / Math.log(10.0)) + 1;
            chars = new char[lineNumberDigits];
            for (i = 0; i < chars.length; ++i) {
                chars[i] = 32;
            }
            lineNumberWidth = this.font.getStringBounds(chars, 0, lineNumberDigits, this.frc).getWidth();
        } else {
            lineNumberWidth = 0.0;
        }
        Log.log(1, this, "#2 - Page dimensions: " + (pageWidth - lineNumberWidth) + "x" + pageHeight);
        int tabSize = jEdit.getIntegerProperty("print.tabSize", 8);
        chars = new char[tabSize];
        for (i = 0; i < chars.length; ++i) {
            chars[i] = 32;
        }
        double tabWidth = this.font.getStringBounds(chars, 0, tabSize, this.frc).getWidth();
        PrintTabExpander e = new PrintTabExpander(tabWidth);
        double y = 0.0;
        this.lm = this.font.getLineMetrics("gGyYX", this.frc);
        Log.log(1, this, "Line height is " + this.lm.getHeight());
        while (true) {
            if (this.currentPhysicalLine == this.buffer.getLineCount()) {
                Log.log(1, this, "Finished buffer");
                this.end = true;
                break;
            }
            this.lineList.clear();
            this.tokenHandler.init(this.styles, this.frc, e, this.lineList, (float)(pageWidth - lineNumberWidth));
            this.buffer.markTokens(this.currentPhysicalLine, this.tokenHandler);
            if (this.lineList.size() == 0) {
                this.lineList.add(null);
            }
            if (y + (double)(this.lm.getHeight() * (float)this.lineList.size()) >= pageHeight) {
                Log.log(1, this, "Finished page before line " + this.currentPhysicalLine);
                break;
            }
            if (this.lineNumbers && actuallyPaint) {
                gfx.setFont(this.font);
                gfx.setColor(lineNumberColor);
                gfx.drawString(String.valueOf(this.currentPhysicalLine + 1), (float)pageX, (float)(pageY + y + (double)this.lm.getHeight()));
            }
            for (int i2 = 0; i2 < this.lineList.size(); ++i2) {
                y += (double)this.lm.getHeight();
                Chunk chunks = (Chunk)this.lineList.get(i2);
                if (chunks == null || !actuallyPaint) continue;
                Chunk.paintChunkBackgrounds(chunks, gfx, (float)(pageX + lineNumberWidth), (float)(pageY + y));
                Chunk.paintChunkList(chunks, gfx, (float)(pageX + lineNumberWidth), (float)(pageY + y), glyphVector);
            }
            ++this.currentPhysicalLine;
        }
    }

    private double paintHeader(Graphics2D gfx, double pageX, double pageY, double pageWidth, boolean actuallyPaint) {
        String headerText = jEdit.getProperty("print.headerText", new String[]{this.buffer.getName()});
        FontRenderContext frc = gfx.getFontRenderContext();
        this.lm = this.font.getLineMetrics(headerText, frc);
        Rectangle2D bounds = this.font.getStringBounds(headerText, frc);
        Rectangle2D.Double headerBounds = new Rectangle2D.Double(pageX, pageY, pageWidth, bounds.getHeight());
        if (actuallyPaint) {
            gfx.setColor(headerColor);
            gfx.fill(headerBounds);
            gfx.setColor(headerTextColor);
            gfx.drawString(headerText, (float)(pageX + (pageWidth - bounds.getWidth()) / 2.0), (float)(pageY + (double)this.lm.getAscent()));
        }
        return ((RectangularShape)headerBounds).getHeight();
    }

    private double paintFooter(Graphics2D gfx, double pageX, double pageY, double pageWidth, double pageHeight, int pageIndex, boolean actuallyPaint) {
        String footerText = jEdit.getProperty("print.footerText", new Object[]{new Date(), new Integer(pageIndex + 1)});
        FontRenderContext frc = gfx.getFontRenderContext();
        this.lm = this.font.getLineMetrics(footerText, frc);
        Rectangle2D bounds = this.font.getStringBounds(footerText, frc);
        Rectangle2D.Double footerBounds = new Rectangle2D.Double(pageX, pageY + pageHeight - bounds.getHeight(), pageWidth, bounds.getHeight());
        if (actuallyPaint) {
            gfx.setColor(footerColor);
            gfx.fill(footerBounds);
            gfx.setColor(footerTextColor);
            gfx.drawString(footerText, (float)(pageX + (pageWidth - bounds.getWidth()) / 2.0), (float)(pageY + pageHeight - bounds.getHeight() + (double)this.lm.getAscent()));
        }
        return ((RectangularShape)footerBounds).getHeight();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class PrintTabExpander
    implements TabExpander {
        private double tabWidth;

        public PrintTabExpander(double tabWidth) {
            this.tabWidth = tabWidth;
        }

        public float nextTabStop(float x, int tabOffset) {
            int ntabs = (int)((double)(x + 1.0f) / this.tabWidth);
            return (float)((double)(ntabs + 1) * this.tabWidth);
        }
    }
}

