/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import com.microstar.xml.HandlerBase;
import java.io.StringReader;
import java.util.Stack;
import org.gjt.sp.jedit.pluginmgr.MirrorList;
import org.gjt.sp.util.Log;

class MirrorListHandler
extends HandlerBase {
    private String id;
    private String description;
    private String location;
    private String country;
    private String continent;
    private MirrorList mirrors;
    private MirrorList.Mirror mirror;
    private Stack stateStack;
    private String path;

    MirrorListHandler(MirrorList mirrors, String path) {
        this.mirrors = mirrors;
        this.path = path;
        this.stateStack = new Stack();
    }

    public Object resolveEntity(String publicId, String systemId) {
        if ("mirrors.dtd".equals(systemId)) {
            return new StringReader("<!-- -->");
        }
        return null;
    }

    public void attribute(String aname, String value, boolean isSpecified) {
        aname = aname == null ? null : aname.intern();
        String string = value = value == null ? null : value.intern();
        if (aname == "ID") {
            this.id = value;
        }
    }

    public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
        if ("MIRRORS".equals(name)) {
            return;
        }
        Log.log(9, this, this.path + ": DOCTYPE must be MIRRORS");
    }

    public void charData(char[] c, int off, int len) {
        String tag = this.peekElement();
        String text = new String(c, off, len);
        if (tag == "DESCRIPTION") {
            this.description = text;
        } else if (tag == "LOCATION") {
            this.location = text;
        } else if (tag == "COUNTRY") {
            this.country = text;
        } else if (tag == "CONTINENT") {
            this.continent = text;
        }
    }

    public void startElement(String tag) {
        if ((tag = this.pushElement(tag)) == "MIRROR") {
            this.mirror = new MirrorList.Mirror();
        }
    }

    public void endElement(String tag) {
        if (tag == null) {
            return;
        }
        tag = tag.intern();
        this.popElement();
        if (tag == "MIRROR") {
            this.mirror.id = this.id;
            this.mirror.description = this.description;
            this.mirror.location = this.location;
            this.mirror.country = this.country;
            this.mirror.continent = this.continent;
            this.mirrors.add(this.mirror);
        }
    }

    public void startDocument() {
        try {
            this.pushElement(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void endDocument() {
        this.mirrors.finished();
    }

    private String pushElement(String name) {
        name = name == null ? null : name.intern();
        this.stateStack.push(name);
        return name;
    }

    private String peekElement() {
        return (String)this.stateStack.peek();
    }

    private String popElement() {
        return (String)this.stateStack.pop();
    }
}

