/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import com.microstar.xml.XmlParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.MirrorListHandler;

public class MirrorList {
    public ArrayList mirrors = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MirrorList() throws Exception {
        Mirror none = new Mirror();
        none.id = "NONE";
        none.continent = "";
        none.country = "";
        none.location = "";
        none.description = "";
        this.mirrors.add(none);
        String path = jEdit.getProperty("plugin-manager.mirror-url");
        MirrorListHandler handler = new MirrorListHandler(this, path);
        XmlParser parser = new XmlParser();
        parser.setHandler(handler);
        BufferedReader in = new BufferedReader(new InputStreamReader(new URL(path).openStream()));
        try {
            parser.parse(null, null, in);
        }
        finally {
            ((Reader)in).close();
        }
    }

    void add(Mirror mirror) {
        this.mirrors.add(mirror);
    }

    void finished() {
        Collections.sort(this.mirrors, new MirrorCompare());
    }

    class MirrorCompare
    implements Comparator {
        MirrorCompare() {
        }

        public int compare(Object o1, Object o2) {
            Mirror m1 = (Mirror)o1;
            Mirror m2 = (Mirror)o2;
            int result = m1.continent.compareToIgnoreCase(m2.continent);
            if (result == 0 && (result = m1.country.compareToIgnoreCase(m2.country)) == 0 && (result = m1.location.compareToIgnoreCase(m2.location)) == 0) {
                return m1.description.compareToIgnoreCase(m2.description);
            }
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof MirrorCompare;
        }
    }

    public static class Mirror {
        public static final String NONE = "NONE";
        public String id;
        public String description;
        public String location;
        public String country;
        public String continent;
    }
}

