/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.help.HelpViewer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.pluginmgr.Roster;

public class ManagePanel
extends JPanel {
    private JCheckBox hideLibraries;
    private JTable table;
    private PluginTableModel pluginModel;
    private PluginManager window;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ManagePanel(PluginManager window) {
        super(new BorderLayout(12, 12));
        this.window = window;
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Box topBox = new Box(0);
        this.hideLibraries = new HideLibrariesButton();
        topBox.add(this.hideLibraries);
        this.add("North", topBox);
        this.pluginModel = new PluginTableModel();
        this.table = new JTable(this.pluginModel);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setRowHeight(this.table.getRowHeight() + 2);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 300));
        this.table.setRequestFocusEnabled(false);
        this.table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = ManagePanel.class$("java.lang.Object")) : class$java$lang$Object, new TextRenderer((DefaultTableCellRenderer)this.table.getDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = ManagePanel.class$("java.lang.Object")) : class$java$lang$Object)));
        TableColumn col1 = this.table.getColumnModel().getColumn(0);
        TableColumn col2 = this.table.getColumnModel().getColumn(1);
        TableColumn col3 = this.table.getColumnModel().getColumn(2);
        TableColumn col4 = this.table.getColumnModel().getColumn(3);
        col1.setPreferredWidth(30);
        col1.setMinWidth(30);
        col1.setMaxWidth(30);
        col1.setResizable(false);
        col2.setPreferredWidth(300);
        col3.setPreferredWidth(100);
        col4.setPreferredWidth(100);
        JTableHeader header = this.table.getTableHeader();
        header.setReorderingAllowed(false);
        header.addMouseListener(new HeaderMouseHandler());
        JScrollPane scrollpane = new JScrollPane(this.table);
        scrollpane.getViewport().setBackground(this.table.getBackground());
        this.add("Center", scrollpane);
        Box buttons = new Box(0);
        buttons.add(new RemoveButton());
        buttons.add(Box.createGlue());
        buttons.add(new HelpButton());
        this.add("South", buttons);
    }

    public void update() {
        this.pluginModel.update();
    }

    private int showListConfirm(String name, String[] args, Vector listModel) {
        JList list = new JList(listModel);
        list.setVisibleRowCount(8);
        Object[] message = new Object[]{jEdit.getProperty(name + ".message", args), new JScrollPane(list)};
        return JOptionPane.showConfirmDialog(this.window, message, jEdit.getProperty(name + ".title"), 0, 3);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class HeaderMouseHandler
    extends MouseAdapter {
        HeaderMouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            switch (ManagePanel.this.table.getTableHeader().columnAtPoint(evt.getPoint())) {
                case 1: {
                    ManagePanel.this.pluginModel.setSortType(1);
                    break;
                }
                case 3: {
                    ManagePanel.this.pluginModel.setSortType(2);
                    break;
                }
            }
        }
    }

    static class EntryCompare
    implements Comparator {
        public static final int NAME = 1;
        public static final int STATUS = 2;
        private int type;

        public EntryCompare(int type) {
            this.type = type;
        }

        public int compare(Object o1, Object o2) {
            Entry e1 = (Entry)o1;
            Entry e2 = (Entry)o2;
            if (this.type == 1) {
                return this.compareNames(e1, e2);
            }
            int result = e1.status.compareToIgnoreCase(e2.status);
            if (result == 0) {
                return this.compareNames(e1, e2);
            }
            return result;
        }

        private int compareNames(Entry e1, Entry e2) {
            String s1 = e1.name == null ? MiscUtilities.getFileName(e1.jar) : e1.name;
            String s2 = e2.name == null ? MiscUtilities.getFileName(e2.jar) : e2.name;
            return s1.compareToIgnoreCase(s2);
        }
    }

    class HelpButton
    extends JButton
    implements ListSelectionListener,
    ActionListener {
        private URL docURL;

        public HelpButton() {
            super(jEdit.getProperty("manage-plugins.help"));
            ManagePanel.this.table.getSelectionModel().addListSelectionListener(this);
            this.addActionListener(this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent evt) {
            new HelpViewer(this.docURL);
        }

        public void valueChanged(ListSelectionEvent e) {
            if (ManagePanel.this.table.getSelectedRowCount() == 1) {
                try {
                    URL url;
                    Entry entry = ManagePanel.this.pluginModel.getEntry(ManagePanel.this.table.getSelectedRow());
                    String label = entry.clazz;
                    String docs = entry.docs;
                    PluginJAR jar = jEdit.getPlugin(label).getPluginJAR();
                    if (jar != null && label != null && docs != null && (url = jar.getClassLoader().getResource(docs)) != null) {
                        this.docURL = url;
                        this.setEnabled(true);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setEnabled(false);
        }
    }

    class RemoveButton
    extends JButton
    implements ListSelectionListener,
    ActionListener {
        public RemoveButton() {
            super(jEdit.getProperty("manage-plugins.remove"));
            ManagePanel.this.table.getSelectionModel().addListSelectionListener(this);
            this.addActionListener(this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent evt) {
            int[] selected = ManagePanel.this.table.getSelectedRows();
            Vector<String> listModel = new Vector<String>();
            Roster roster = new Roster();
            for (int i = 0; i < selected.length; ++i) {
                Entry entry = ManagePanel.this.pluginModel.getEntry(selected[i]);
                Iterator iter = entry.jars.iterator();
                while (iter.hasNext()) {
                    String jar = (String)iter.next();
                    listModel.addElement(jar);
                    roster.addRemove(jar);
                }
            }
            int button = ManagePanel.this.showListConfirm("plugin-manager.remove-confirm", null, listModel);
            if (button == 0) {
                roster.performOperationsInAWTThread(ManagePanel.this.window);
                ManagePanel.this.pluginModel.update();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            if (ManagePanel.this.table.getSelectedRowCount() == 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class HideLibrariesButton
    extends JCheckBox
    implements ActionListener {
        HideLibrariesButton() {
            super(jEdit.getProperty("plugin-manager.hide-libraries"));
            this.setSelected(jEdit.getBooleanProperty("plugin-manager.hide-libraries.toggle"));
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent evt) {
            jEdit.setBooleanProperty("plugin-manager.hide-libraries.toggle", this.isSelected());
            ManagePanel.this.update();
        }
    }

    class TextRenderer
    extends DefaultTableCellRenderer {
        private DefaultTableCellRenderer tcr;

        public TextRenderer(DefaultTableCellRenderer tcr) {
            this.tcr = tcr;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Entry entry = ManagePanel.this.pluginModel.getEntry(row);
            if (entry.status.equals("error")) {
                this.tcr.setForeground(Color.red);
            } else {
                this.tcr.setForeground(UIManager.getColor("Table.foreground"));
            }
            return this.tcr.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }
    }

    class PluginTableModel
    extends AbstractTableModel {
        private List entries = new ArrayList();
        private int sortType = 1;

        public PluginTableModel() {
            this.update();
        }

        public int getColumnCount() {
            return 4;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ManagePanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                }
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = ManagePanel.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return jEdit.getProperty("manage-plugins.info.name");
                }
                case 2: {
                    return jEdit.getProperty("manage-plugins.info.version");
                }
                case 3: {
                    return jEdit.getProperty("manage-plugins.info.status");
                }
            }
            throw new Error("Column out of range");
        }

        public Entry getEntry(int rowIndex) {
            return (Entry)this.entries.get(rowIndex);
        }

        public int getRowCount() {
            return this.entries.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Entry entry = (Entry)this.entries.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return new Boolean(!entry.status.equals("not-loaded"));
                }
                case 1: {
                    if (entry.name == null) {
                        return MiscUtilities.getFileName(entry.jar);
                    }
                    return entry.name;
                }
                case 2: {
                    return entry.version;
                }
                case 3: {
                    return jEdit.getProperty("plugin-manager.status." + entry.status);
                }
            }
            throw new Error("Column out of range");
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            Entry entry = (Entry)this.entries.get(rowIndex);
            if (columnIndex == 0) {
                PluginJAR jar = jEdit.getPluginJAR(entry.jar);
                if (jar == null) {
                    if (value.equals(Boolean.FALSE)) {
                        return;
                    }
                    this.loadPluginJAR(entry.jar);
                } else {
                    if (value.equals(Boolean.TRUE)) {
                        return;
                    }
                    this.unloadPluginJARWithDialog(jar);
                }
            }
            this.update();
        }

        public void setSortType(int type) {
            this.sortType = type;
            this.sort(type);
        }

        public void sort(int type) {
            Collections.sort(this.entries, new EntryCompare(type));
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void update() {
            Entry e;
            this.entries.clear();
            String systemJarDir = MiscUtilities.constructPath(jEdit.getJEditHome(), "jars");
            String userJarDir = jEdit.getSettingsDirectory() == null ? null : MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "jars");
            PluginJAR[] plugins = jEdit.getPluginJARs();
            for (int i = 0; i < plugins.length; ++i) {
                String path = plugins[i].getPath();
                if (!path.startsWith(systemJarDir) && (userJarDir == null || !path.startsWith(userJarDir))) continue;
                e = new Entry(plugins[i]);
                if (ManagePanel.this.hideLibraries.isSelected() && e.clazz == null) continue;
                this.entries.add(e);
            }
            String[] newPlugins = jEdit.getNotLoadedPluginJARs();
            for (int i = 0; i < newPlugins.length; ++i) {
                e = new Entry(newPlugins[i]);
                this.entries.add(e);
            }
            this.sort(this.sortType);
        }

        private void loadPluginJAR(String jarPath) {
            jEdit.addPluginJAR(jarPath);
            PluginJAR jar = jEdit.getPluginJAR(jarPath);
            if (jar == null || jar.getPlugin() == null) {
                return;
            }
            String jars = jEdit.getProperty("plugin." + jar.getPlugin().getClassName() + ".jars");
            if (jars != null) {
                String dir2 = MiscUtilities.getParentOfPath(jarPath);
                StringTokenizer st = new StringTokenizer(jars);
                while (st.hasMoreTokens()) {
                    String _jarPath = MiscUtilities.constructPath(dir2, st.nextToken());
                    PluginJAR _jar = jEdit.getPluginJAR(_jarPath);
                    if (_jar != null) continue;
                    jEdit.addPluginJAR(_jarPath);
                }
            }
            jar.checkDependencies();
            jar.activatePluginIfNecessary();
        }

        private void unloadPluginJARWithDialog(PluginJAR jar) {
            String[] dependents = jar.getDependentPlugins();
            if (dependents.length == 0) {
                this.unloadPluginJAR(jar);
            } else {
                Vector listModel = new Vector();
                this.transitiveClosure(dependents, listModel);
                int button = ManagePanel.this.showListConfirm("plugin-manager.dependency", new String[]{jar.getFile().getName()}, listModel);
                if (button == 0) {
                    this.unloadPluginJAR(jar);
                }
            }
        }

        private void transitiveClosure(String[] dependents, Vector listModel) {
            for (int i = 0; i < dependents.length; ++i) {
                String jarPath = dependents[i];
                if (listModel.contains(jarPath)) continue;
                listModel.add(jarPath);
                PluginJAR jar = jEdit.getPluginJAR(jarPath);
                this.transitiveClosure(jar.getDependentPlugins(), listModel);
            }
        }

        private void unloadPluginJAR(PluginJAR jar) {
            String[] dependents = jar.getDependentPlugins();
            for (int i = 0; i < dependents.length; ++i) {
                PluginJAR _jar = jEdit.getPluginJAR(dependents[i]);
                if (_jar == null) continue;
                this.unloadPluginJAR(_jar);
            }
            jEdit.removePluginJAR(jar, false);
        }
    }

    class Entry {
        static final String ERROR = "error";
        static final String LOADED = "loaded";
        static final String NOT_LOADED = "not-loaded";
        String status;
        String jar;
        String clazz;
        String name;
        String version;
        String author;
        String docs;
        List jars = new LinkedList();

        Entry(String jar) {
            this.jar = jar;
            this.jars.add(this.jar);
            this.status = NOT_LOADED;
        }

        Entry(PluginJAR jar) {
            this.jar = jar.getPath();
            this.jars.add(this.jar);
            EditPlugin plugin = jar.getPlugin();
            if (plugin != null) {
                this.status = plugin instanceof EditPlugin.Broken ? ERROR : LOADED;
                this.clazz = plugin.getClassName();
                this.name = jEdit.getProperty("plugin." + this.clazz + ".name");
                this.version = jEdit.getProperty("plugin." + this.clazz + ".version");
                this.author = jEdit.getProperty("plugin." + this.clazz + ".author");
                this.docs = jEdit.getProperty("plugin." + this.clazz + ".docs");
                String jarsProp = jEdit.getProperty("plugin." + this.clazz + ".jars");
                if (jarsProp != null) {
                    String directory = MiscUtilities.getParentOfPath(this.jar);
                    StringTokenizer st = new StringTokenizer(jarsProp);
                    while (st.hasMoreElements()) {
                        this.jars.add(MiscUtilities.constructPath(directory, st.nextToken()));
                    }
                }
            } else {
                this.status = LOADED;
            }
        }
    }
}

