/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.SyntaxHiliteOptionPane;

class BrowserColorsModel
extends AbstractTableModel {
    private ArrayList entries = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Color;

    BrowserColorsModel() {
        String glob;
        int i = 0;
        while ((glob = jEdit.getProperty("vfs.browser.colors." + i + ".glob")) != null) {
            this.entries.add(new Entry(glob, jEdit.getColorProperty("vfs.browser.colors." + i + ".color", Color.black)));
            ++i;
        }
    }

    void add() {
        this.entries.add(new Entry("", UIManager.getColor("Tree.foreground")));
        this.fireTableRowsInserted(this.entries.size() - 1, this.entries.size() - 1);
    }

    void remove(int index) {
        this.entries.remove(index);
        this.fireTableRowsDeleted(this.entries.size(), this.entries.size());
    }

    public void moveUp(int index) {
        Object obj = this.entries.get(index);
        this.entries.remove(index);
        this.entries.add(index - 1, obj);
        this.fireTableRowsUpdated(index - 1, index);
    }

    public void moveDown(int index) {
        Object obj = this.entries.get(index);
        this.entries.remove(index);
        this.entries.add(index + 1, obj);
        this.fireTableRowsUpdated(index, index + 1);
    }

    void save() {
        int i;
        for (i = 0; i < this.entries.size(); ++i) {
            Entry entry = (Entry)this.entries.get(i);
            jEdit.setProperty("vfs.browser.colors." + i + ".glob", entry.glob);
            jEdit.setColorProperty("vfs.browser.colors." + i + ".color", entry.color);
        }
        jEdit.unsetProperty("vfs.browser.colors." + i + ".glob");
        jEdit.unsetProperty("vfs.browser.colors." + i + ".color");
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.entries.size();
    }

    public Object getValueAt(int row, int col) {
        Entry entry = (Entry)this.entries.get(row);
        switch (col) {
            case 0: {
                return entry.glob;
            }
            case 1: {
                return entry.color;
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    public void setValueAt(Object value, int row, int col) {
        Entry entry = (Entry)this.entries.get(row);
        if (col == 0) {
            entry.glob = (String)value;
        } else {
            entry.color = (Color)value;
        }
        this.fireTableRowsUpdated(row, row);
    }

    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty("options.browser.colors.glob");
            }
            case 1: {
                return jEdit.getProperty("options.browser.colors.color");
            }
        }
        return null;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return class$java$lang$String == null ? (class$java$lang$String = BrowserColorsModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 1: {
                return class$java$awt$Color == null ? (class$java$awt$Color = BrowserColorsModel.class$("java.awt.Color")) : class$java$awt$Color;
            }
        }
        throw new InternalError();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        public ColorRenderer() {
            this.setOpaque(true);
            this.setBorder(SyntaxHiliteOptionPane.noFocusBorder);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int col) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            if (value != null) {
                this.setBackground((Color)value);
            }
            this.setBorder(cellHasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : SyntaxHiliteOptionPane.noFocusBorder);
            return this;
        }
    }

    static class Entry {
        String glob;
        Color color;

        Entry(String glob, Color color) {
            this.glob = glob;
            this.color = color;
        }
    }
}

