/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;

public class MarkersProvider
implements DynamicMenuProvider {
    public boolean updateEveryTime() {
        return true;
    }

    public void update(JMenu menu) {
        final View view = GUIUtilities.getView(menu);
        Buffer buffer = view.getBuffer();
        Vector markers = buffer.getMarkers();
        if (markers.size() == 0) {
            JMenuItem mi = new JMenuItem(jEdit.getProperty("no-markers.label"));
            mi.setEnabled(false);
            menu.add(mi);
            return;
        }
        int maxItems = jEdit.getIntegerProperty("menu.spillover", 20);
        JMenu current = menu;
        for (int i = 0; i < markers.size(); ++i) {
            final Marker marker = (Marker)markers.elementAt(i);
            int lineNo = buffer.getLineOfOffset(marker.getPosition());
            if (current.getItemCount() >= maxItems && i != markers.size() - 1) {
                JMenu newCurrent = new JMenu(jEdit.getProperty("common.more"));
                current.add(newCurrent);
                current = newCurrent;
            }
            MarkersMenuItem mi = new MarkersMenuItem(buffer, lineNo, marker.getShortcut());
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    view.getTextArea().setCaretPosition(marker.getPosition());
                }
            });
            current.add(mi);
        }
    }

    static class MarkersMenuItem
    extends JMenuItem {
        private String shortcutProp;
        private char shortcut;
        private static Font acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        private static Color acceleratorForeground;
        private static Color acceleratorSelectionForeground;

        MarkersMenuItem(Buffer buffer, int lineNo, char shortcut) {
            String text = buffer.getLineText(lineNo).trim();
            if (text.length() == 0) {
                text = jEdit.getProperty("markers.blank-line");
            }
            this.setText(lineNo + 1 + ": " + text);
            this.shortcutProp = "goto-marker.shortcut";
            this.shortcut = shortcut;
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            String shortcut = this.getShortcut();
            if (shortcut != null) {
                d.width += this.getFontMetrics(acceleratorFont).stringWidth(shortcut) + 15;
            }
            return d;
        }

        public void paint(Graphics g) {
            super.paint(g);
            String shortcut = this.getShortcut();
            if (shortcut != null) {
                g.setFont(acceleratorFont);
                g.setColor(this.getModel().isArmed() ? acceleratorSelectionForeground : acceleratorForeground);
                FontMetrics fm = g.getFontMetrics();
                Insets insets = this.getInsets();
                g.drawString(shortcut, this.getWidth() - (fm.stringWidth(shortcut) + insets.right + insets.left + 5), this.getFont().getSize() + (insets.top - 1));
            }
        }

        private String getShortcut() {
            if (this.shortcut == '\u0000') {
                return null;
            }
            String shortcutPrefix = jEdit.getProperty(this.shortcutProp);
            if (shortcutPrefix == null) {
                return null;
            }
            return shortcutPrefix + " " + this.shortcut;
        }

        static {
            acceleratorFont = new Font("Monospaced", acceleratorFont.getStyle(), acceleratorFont.getSize());
            acceleratorForeground = UIManager.getColor("MenuItem.acceleratorForeground");
            acceleratorSelectionForeground = UIManager.getColor("MenuItem.acceleratorSelectionForeground");
        }
    }
}

