/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.io.File;
import java.lang.reflect.Method;
import java.util.LinkedList;
import javax.swing.filechooser.FileSystemView;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.util.Log;

public class FileRootsVFS
extends VFS {
    public static final String PROTOCOL = "roots";
    private static FileSystemView fsView;
    private static Method getSystemDisplayName;
    private static Method getRoots;
    private static Method isFileSystemRoot;
    private static Method isFloppyDrive;
    private static Method isDrive;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$javax$swing$filechooser$FileSystemView;
    static /* synthetic */ Class class$org$gjt$sp$jedit$io$FileRootsVFS;

    public FileRootsVFS() {
        super(PROTOCOL, 64, new String[]{"type"});
        if (OperatingSystem.hasJava14()) {
            try {
                getSystemDisplayName = (class$javax$swing$filechooser$FileSystemView == null ? (class$javax$swing$filechooser$FileSystemView = FileRootsVFS.class$("javax.swing.filechooser.FileSystemView")) : class$javax$swing$filechooser$FileSystemView).getMethod("getSystemDisplayName", class$java$io$File == null ? (class$java$io$File = FileRootsVFS.class$("java.io.File")) : class$java$io$File);
                getRoots = (class$javax$swing$filechooser$FileSystemView == null ? (class$javax$swing$filechooser$FileSystemView = FileRootsVFS.class$("javax.swing.filechooser.FileSystemView")) : class$javax$swing$filechooser$FileSystemView).getMethod("getRoots", new Class[0]);
                isFileSystemRoot = (class$javax$swing$filechooser$FileSystemView == null ? (class$javax$swing$filechooser$FileSystemView = FileRootsVFS.class$("javax.swing.filechooser.FileSystemView")) : class$javax$swing$filechooser$FileSystemView).getMethod("isFileSystemRoot", class$java$io$File == null ? (class$java$io$File = FileRootsVFS.class$("java.io.File")) : class$java$io$File);
                isFloppyDrive = (class$javax$swing$filechooser$FileSystemView == null ? (class$javax$swing$filechooser$FileSystemView = FileRootsVFS.class$("javax.swing.filechooser.FileSystemView")) : class$javax$swing$filechooser$FileSystemView).getMethod("isFloppyDrive", class$java$io$File == null ? (class$java$io$File = FileRootsVFS.class$("java.io.File")) : class$java$io$File);
                isDrive = (class$javax$swing$filechooser$FileSystemView == null ? (class$javax$swing$filechooser$FileSystemView = FileRootsVFS.class$("javax.swing.filechooser.FileSystemView")) : class$javax$swing$filechooser$FileSystemView).getMethod("isDrive", class$java$io$File == null ? (class$java$io$File = FileRootsVFS.class$("java.io.File")) : class$java$io$File);
                fsView = FileSystemView.getFileSystemView();
                Log.log(1, this, "Java 1.4 FileSystemView detected");
            }
            catch (Exception e) {
                Log.log(1, this, "Java 1.4 FileSystemView not detected");
            }
        }
    }

    public String getParentOfPath(String path) {
        return "roots:";
    }

    public VFS.DirectoryEntry[] _listDirectory(Object session, String url, Component comp) {
        File[] roots = FileRootsVFS.listRoots();
        if (roots == null) {
            return null;
        }
        VFS.DirectoryEntry[] rootDE = new VFS.DirectoryEntry[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            rootDE[i] = new RootsEntry(roots[i]);
        }
        return rootDE;
    }

    public VFS.DirectoryEntry _getDirectoryEntry(Object session, String path, Component comp) {
        return new RootsEntry(new File(path));
    }

    private static File[] listRoots() {
        if (OperatingSystem.isMacOS()) {
            File[] volumes = new File("/Volumes").listFiles();
            LinkedList<File> roots = new LinkedList<File>();
            roots.add(new File("/"));
            for (int i = 0; i < volumes.length; ++i) {
                if (!volumes[i].isDirectory()) continue;
                roots.add(volumes[i]);
            }
            return roots.toArray(new File[0]);
        }
        File[] roots = File.listRoots();
        File[] desktop = null;
        if (getRoots != null) {
            try {
                desktop = (File[])getRoots.invoke((Object)fsView, new Object[0]);
            }
            catch (Exception e) {
                Log.log(9, class$org$gjt$sp$jedit$io$FileRootsVFS == null ? (class$org$gjt$sp$jedit$io$FileRootsVFS = FileRootsVFS.class$("org.gjt.sp.jedit.io.FileRootsVFS")) : class$org$gjt$sp$jedit$io$FileRootsVFS, "Error getting Desktop: " + e.getMessage());
                desktop = null;
            }
        }
        if (desktop == null) {
            return roots;
        }
        File[] rootsPlus = new File[roots.length + desktop.length];
        System.arraycopy(desktop, 0, rootsPlus, 0, desktop.length);
        System.arraycopy(roots, 0, rootsPlus, 1, roots.length);
        return rootsPlus;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class RootsEntry
    extends VFS.DirectoryEntry {
        RootsEntry(File file) {
            this.deletePath = this.symlinkPath = file.getPath();
            this.path = this.symlinkPath;
            if (this.isFloppy(file)) {
                this.type = 2;
                this.name = this.path;
            } else if (this.isDrive(file)) {
                this.type = 2;
                if (getSystemDisplayName != null) {
                    try {
                        this.name = this.path + " " + (String)getSystemDisplayName.invoke((Object)fsView, file);
                    }
                    catch (Exception e) {
                        Log.log(9, this, e);
                        this.name = this.path;
                    }
                }
            } else if (file.isDirectory()) {
                this.type = 2;
                if (isFileSystemRoot != null) {
                    try {
                        if (Boolean.FALSE.equals(isFileSystemRoot.invoke((Object)fsView, file))) {
                            this.type = 1;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.name = OperatingSystem.isMacOS() ? MiscUtilities.getFileName(this.path) : this.path;
            } else {
                this.type = 0;
            }
        }

        public String getExtendedAttribute(String name) {
            if (name.equals("type")) {
                return super.getExtendedAttribute(name);
            }
            return null;
        }

        private boolean isFloppy(File file) {
            if (isFloppyDrive != null) {
                try {
                    return Boolean.TRUE.equals(isFloppyDrive.invoke((Object)fsView, file));
                }
                catch (Exception e) {
                    Log.log(9, this, e);
                    return false;
                }
            }
            return this.path.startsWith("A:") || this.path.startsWith("B:");
        }

        private boolean isDrive(File file) {
            if (isDrive != null) {
                try {
                    return Boolean.TRUE.equals(isDrive.invoke((Object)fsView, file));
                }
                catch (Exception e) {
                    Log.log(9, this, e);
                    return false;
                }
            }
            return true;
        }
    }
}

