/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindowContainer;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;

public class PanelWindowContainer
implements DockableWindowContainer {
    static final int SPLITTER_WIDTH = 10;
    DockablePanel dockablePanel;
    JPanel buttonPanel;
    private DockableWindowManager wm;
    private String position;
    private JButton closeBox;
    private JButton menuBtn;
    private ButtonGroup buttonGroup;
    private JToggleButton nullButton;
    private int dimension;
    private ArrayList dockables;
    private ArrayList buttons;
    private DockableWindowManager.Entry current;
    private JPopupMenu popup;
    private String mostRecent;

    public PanelWindowContainer(DockableWindowManager wm, String position, int dimension) {
        this.wm = wm;
        this.position = position;
        this.buttonPanel = new JPanel(new ButtonLayout());
        this.buttonPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.closeBox = new JButton(GUIUtilities.loadIcon("closebox.gif"));
        this.closeBox.setRequestFocusEnabled(false);
        this.closeBox.setToolTipText(jEdit.getProperty("view.docking.close-tooltip"));
        if (OperatingSystem.isMacOSLF()) {
            this.closeBox.putClientProperty("JButton.buttonType", "toolbar");
        }
        this.closeBox.setMargin(new Insets(0, 0, 0, 0));
        this.closeBox.addActionListener(new ActionHandler());
        this.menuBtn = new JButton(GUIUtilities.loadIcon("ToolbarMenu.gif"));
        this.menuBtn.setRequestFocusEnabled(false);
        this.menuBtn.setToolTipText(jEdit.getProperty("view.docking.menu-tooltip"));
        if (OperatingSystem.isMacOSLF()) {
            this.menuBtn.putClientProperty("JButton.buttonType", "toolbar");
        }
        this.menuBtn.setMargin(new Insets(0, 0, 0, 0));
        this.menuBtn.addMouseListener(new MenuMouseHandler());
        this.buttonGroup = new ButtonGroup();
        this.nullButton = new JToggleButton();
        this.buttonGroup.add(this.nullButton);
        this.dockables = new ArrayList();
        this.buttons = new ArrayList();
        this.dockablePanel = new DockablePanel();
        this.dimension = dimension;
    }

    /*
     * WARNING - void declaration
     */
    public void register(DockableWindowManager.Entry entry) {
        void var2_2;
        int rotation;
        this.dockables.add(entry);
        if (this.position.equals("top") || this.position.equals("bottom")) {
            rotation = 0;
        } else if (this.position.equals("left")) {
            rotation = 2;
        } else if (this.position.equals("right")) {
            rotation = 1;
        } else {
            throw new InternalError("Invalid position: " + this.position);
        }
        JToggleButton button = new JToggleButton();
        button.setMargin(new Insets(1, 1, 1, 1));
        button.setRequestFocusEnabled(false);
        button.setIcon(new RotatedTextIcon((int)var2_2, button.getFont(), entry.title));
        button.setActionCommand(entry.factory.name);
        button.addActionListener(new ActionHandler());
        button.addMouseListener(new MenuMouseHandler());
        if (OperatingSystem.isMacOSLF()) {
            button.putClientProperty("JButton.buttonType", "toolbar");
        }
        this.buttonGroup.add(button);
        this.buttons.add(button);
        entry.btn = button;
        this.wm.revalidate();
    }

    public void unregister(DockableWindowManager.Entry entry) {
        if (entry.factory.name.equals(this.mostRecent)) {
            this.mostRecent = null;
        }
        this.buttonPanel.remove(entry.btn);
        this.buttons.remove(entry.btn);
        entry.btn = null;
        this.dockables.remove(entry);
        if (entry.win != null) {
            this.dockablePanel.remove(entry.win);
        }
        if (this.current == entry) {
            this.current = null;
            this.show(null);
        } else {
            this.wm.revalidate();
            this.dockablePanel.repaint();
            this.buttonPanel.repaint();
        }
    }

    public void remove(DockableWindowManager.Entry entry) {
        if (entry.factory.name.equals(this.mostRecent)) {
            this.mostRecent = null;
        }
        if (entry.win != null) {
            this.dockablePanel.remove(entry.win);
            entry.win = null;
        }
        if (this.current == entry) {
            this.current = null;
            this.show(null);
        } else {
            this.wm.revalidate();
            this.dockablePanel.repaint();
        }
    }

    public void showMostRecent() {
        if (this.dockables.size() == 0) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (this.mostRecent == null) {
            this.mostRecent = ((DockableWindowManager.Entry)this.dockables.get((int)0)).factory.name;
        }
        this.wm.showDockableWindow(this.mostRecent);
    }

    public void show(DockableWindowManager.Entry entry) {
        if (this.current == entry) {
            if (entry != null) {
                if (entry.win instanceof DefaultFocusComponent) {
                    ((DefaultFocusComponent)((Object)entry.win)).focusOnDefaultComponent();
                } else {
                    entry.win.requestDefaultFocus();
                }
            }
            return;
        }
        if (entry != null) {
            if (this.current == null) {
                this.dockablePanel.setBorder(new DockBorder(this.position));
            }
            this.mostRecent = entry.factory.name;
            this.current = entry;
            if (entry.win.getParent() != this.dockablePanel) {
                this.dockablePanel.add(entry.factory.name, entry.win);
            }
            this.dockablePanel.showDockable(entry.factory.name);
            entry.btn.setSelected(true);
            if (entry.win instanceof DefaultFocusComponent) {
                ((DefaultFocusComponent)((Object)entry.win)).focusOnDefaultComponent();
            } else {
                entry.win.requestDefaultFocus();
            }
        } else {
            this.current = null;
            this.nullButton.setSelected(true);
            this.dockablePanel.setBorder(null);
            this.wm.getView().getTextArea().requestFocus();
        }
        this.wm.revalidate();
        this.dockablePanel.repaint();
    }

    public boolean isVisible(DockableWindowManager.Entry entry) {
        return this.current == entry;
    }

    public String getCurrent() {
        if (this.current == null) {
            return null;
        }
        return this.current.factory.name;
    }

    public int getDimension() {
        return this.dimension;
    }

    public String[] getDockables() {
        String[] retVal = new String[this.dockables.size()];
        for (int i = 0; i < this.dockables.size(); ++i) {
            DockableWindowManager.Entry entry = (DockableWindowManager.Entry)this.dockables.get(i);
            retVal[i] = entry.factory.name;
        }
        return retVal;
    }

    void save() {
        jEdit.setIntegerProperty("view.dock." + this.position + ".dimension", this.dimension);
        if (this.current == null) {
            jEdit.unsetProperty("view.dock." + this.position + ".last");
        } else {
            jEdit.setProperty("view.dock." + this.position + ".last", this.current.factory.name);
        }
    }

    void setDimension(int dimension) {
        if (dimension != 0) {
            this.dimension = dimension - 10;
        }
    }

    void sortDockables() {
        this.buttonPanel.removeAll();
        this.buttonPanel.add(this.closeBox);
        this.buttonPanel.add(this.menuBtn);
        Collections.sort(this.buttons, new DockableWindowCompare());
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttonPanel.add((AbstractButton)this.buttons.get(i));
        }
    }

    int getWrappedDimension(int dimension) {
        return ((ButtonLayout)this.buttonPanel.getLayout()).getWrappedDimension(this.buttonPanel, dimension);
    }

    class DockablePanel
    extends JPanel {
        DockablePanel() {
            super(new CardLayout());
            ResizeMouseHandler resizeMouseHandler = new ResizeMouseHandler();
            this.addMouseListener(resizeMouseHandler);
            this.addMouseMotionListener(resizeMouseHandler);
        }

        PanelWindowContainer getWindowContainer() {
            return PanelWindowContainer.this;
        }

        void showDockable(String name) {
            ((CardLayout)this.getLayout()).show(this, name);
        }

        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }

        public Dimension getPreferredSize() {
            if (PanelWindowContainer.this.current == null) {
                return new Dimension(0, 0);
            }
            if (PanelWindowContainer.this.position.equals("top") || PanelWindowContainer.this.position.equals("bottom")) {
                if (PanelWindowContainer.this.dimension <= 0) {
                    int height = super.getPreferredSize().height;
                    PanelWindowContainer.this.dimension = height - 10;
                }
                return new Dimension(0, PanelWindowContainer.this.dimension + 10);
            }
            if (PanelWindowContainer.this.dimension <= 0) {
                int width = super.getPreferredSize().width;
                PanelWindowContainer.this.dimension = width - 10;
            }
            return new Dimension(PanelWindowContainer.this.dimension + 10, 0);
        }

        public void setBounds(int x, int y, int width, int height) {
            if (PanelWindowContainer.this.position.equals("top") || PanelWindowContainer.this.position.equals("bottom")) {
                if (PanelWindowContainer.this.dimension != 0 && height <= 10) {
                    PanelWindowContainer.this.show(null);
                } else {
                    PanelWindowContainer.this.dimension = height - 10;
                }
            } else if (PanelWindowContainer.this.dimension != 0 && width <= 10) {
                PanelWindowContainer.this.show(null);
            } else {
                PanelWindowContainer.this.dimension = width - 10;
            }
            super.setBounds(x, y, width, height);
        }

        class ResizeMouseHandler
        extends MouseAdapter
        implements MouseMotionListener {
            boolean canDrag;
            Point dragStart;

            ResizeMouseHandler() {
            }

            public void mousePressed(MouseEvent evt) {
                if (this.canDrag) {
                    PanelWindowContainer.this.wm.setResizePos(PanelWindowContainer.this.dimension, PanelWindowContainer.this);
                    this.dragStart = evt.getPoint();
                }
            }

            public void mouseReleased(MouseEvent evt) {
                if (this.canDrag) {
                    PanelWindowContainer.this.dimension = ((PanelWindowContainer)((DockablePanel)DockablePanel.this).PanelWindowContainer.this).wm.resizePos;
                    PanelWindowContainer.this.wm.finishResizing();
                    this.dragStart = null;
                    PanelWindowContainer.this.wm.revalidate();
                }
            }

            public void mouseMoved(MouseEvent evt) {
                Border border = DockablePanel.this.getBorder();
                if (border == null) {
                    return;
                }
                Insets insets = border.getBorderInsets(DockablePanel.this);
                this.canDrag = false;
                if (PanelWindowContainer.this.position.equals("top")) {
                    if (evt.getY() >= DockablePanel.this.getHeight() - insets.bottom) {
                        this.canDrag = true;
                    }
                } else if (PanelWindowContainer.this.position.equals("left")) {
                    if (evt.getX() >= DockablePanel.this.getWidth() - insets.right) {
                        this.canDrag = true;
                    }
                } else if (PanelWindowContainer.this.position.equals("bottom")) {
                    if (evt.getY() <= insets.top) {
                        this.canDrag = true;
                    }
                } else if (PanelWindowContainer.this.position.equals("right") && evt.getX() <= insets.left) {
                    this.canDrag = true;
                }
                if (this.canDrag) {
                    PanelWindowContainer.this.wm.setCursor(Cursor.getPredefinedCursor(this.getAppropriateCursor()));
                } else {
                    PanelWindowContainer.this.wm.setCursor(Cursor.getPredefinedCursor(0));
                }
            }

            public void mouseDragged(MouseEvent evt) {
                if (!this.canDrag) {
                    return;
                }
                if (this.dragStart == null) {
                    return;
                }
                PanelWindowContainer.this.wm.setCursor(Cursor.getPredefinedCursor(this.getAppropriateCursor()));
                if (PanelWindowContainer.this.position.equals("top")) {
                    PanelWindowContainer.this.wm.setResizePos(evt.getY() - this.dragStart.y + PanelWindowContainer.this.dimension, PanelWindowContainer.this);
                } else if (PanelWindowContainer.this.position.equals("left")) {
                    PanelWindowContainer.this.wm.setResizePos(evt.getX() - this.dragStart.x + PanelWindowContainer.this.dimension, PanelWindowContainer.this);
                } else if (PanelWindowContainer.this.position.equals("bottom")) {
                    PanelWindowContainer.this.wm.setResizePos(PanelWindowContainer.this.dimension - evt.getY() + this.dragStart.y, PanelWindowContainer.this);
                } else if (PanelWindowContainer.this.position.equals("right")) {
                    PanelWindowContainer.this.wm.setResizePos(PanelWindowContainer.this.dimension - evt.getX() + this.dragStart.x, PanelWindowContainer.this);
                }
            }

            public void mouseExited(MouseEvent evt) {
                PanelWindowContainer.this.wm.setCursor(Cursor.getPredefinedCursor(0));
            }

            private int getAppropriateCursor() {
                if (PanelWindowContainer.this.position.equals("top")) {
                    return 8;
                }
                if (PanelWindowContainer.this.position.equals("left")) {
                    return 10;
                }
                if (PanelWindowContainer.this.position.equals("bottom")) {
                    return 9;
                }
                if (PanelWindowContainer.this.position.equals("right")) {
                    return 11;
                }
                throw new InternalError();
            }
        }
    }

    class ButtonLayout
    implements LayoutManager {
        ButtonLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        int getWrappedDimension(JComponent parent, int dimension) {
            Insets insets = parent.getBorder().getBorderInsets(parent);
            Component[] comp = parent.getComponents();
            if (comp.length <= 2) {
                return 0;
            }
            Dimension dim = comp[2].getPreferredSize();
            if (PanelWindowContainer.this.position.equals("top") || PanelWindowContainer.this.position.equals("bottom")) {
                int width = dimension - insets.right;
                int rowHeight = Math.max(dim.height, ((PanelWindowContainer)PanelWindowContainer.this).closeBox.getPreferredSize().width);
                int x = rowHeight * 2 + insets.left;
                Dimension returnValue = new Dimension(0, rowHeight + insets.top + insets.bottom);
                for (int i = 2; i < comp.length; ++i) {
                    int btnWidth = comp[i].getPreferredSize().width;
                    if (btnWidth + x > width) {
                        returnValue.height += rowHeight;
                        x = insets.left;
                    }
                    x += btnWidth;
                }
                return returnValue.height;
            }
            int height = dimension - insets.bottom;
            int colWidth = Math.max(dim.width, ((PanelWindowContainer)PanelWindowContainer.this).closeBox.getPreferredSize().height);
            int y = colWidth * 2 + insets.top;
            Dimension returnValue = new Dimension(colWidth + insets.left + insets.right, 0);
            for (int i = 2; i < comp.length; ++i) {
                int btnHeight = comp[i].getPreferredSize().height;
                if (btnHeight + y > height) {
                    returnValue.width += colWidth;
                    y = insets.top;
                }
                y += btnHeight;
            }
            return returnValue.width;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = ((JComponent)parent).getBorder().getBorderInsets((JComponent)parent);
            Component[] comp = parent.getComponents();
            if (comp.length <= 2) {
                return new Dimension(0, 0);
            }
            Dimension dim = comp[2].getPreferredSize();
            if (PanelWindowContainer.this.position.equals("top") || PanelWindowContainer.this.position.equals("bottom")) {
                int width = parent.getWidth() - insets.right;
                int rowHeight = Math.max(dim.height, ((PanelWindowContainer)PanelWindowContainer.this).closeBox.getPreferredSize().width);
                int x = rowHeight * 2 + insets.left;
                Dimension returnValue = new Dimension(0, rowHeight + insets.top + insets.bottom);
                for (int i = 2; i < comp.length; ++i) {
                    int btnWidth = comp[i].getPreferredSize().width;
                    if (btnWidth + x > width) {
                        returnValue.height += rowHeight;
                        x = insets.left;
                    }
                    x += btnWidth;
                }
                return returnValue;
            }
            int height = parent.getHeight() - insets.bottom;
            int colWidth = Math.max(dim.width, ((PanelWindowContainer)PanelWindowContainer.this).closeBox.getPreferredSize().height);
            int y = colWidth * 2 + insets.top;
            Dimension returnValue = new Dimension(colWidth + insets.left + insets.right, 0);
            for (int i = 2; i < comp.length; ++i) {
                int btnHeight = comp[i].getPreferredSize().height;
                if (btnHeight + y > height) {
                    returnValue.width += colWidth;
                    y = insets.top;
                }
                y += btnHeight;
            }
            return returnValue;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            Insets insets = ((JComponent)parent).getBorder().getBorderInsets((JComponent)parent);
            Component[] comp = parent.getComponents();
            if (comp.length <= 2) {
                for (int i = 0; i < comp.length; ++i) {
                    comp[i].setVisible(false);
                }
                return;
            }
            comp[0].setVisible(true);
            comp[1].setVisible(true);
            Dimension dim = comp[2].getPreferredSize();
            if (PanelWindowContainer.this.position.equals("top") || PanelWindowContainer.this.position.equals("bottom")) {
                int width = parent.getWidth() - insets.right;
                int rowHeight = Math.max(dim.height, ((PanelWindowContainer)PanelWindowContainer.this).closeBox.getPreferredSize().width);
                int x = rowHeight * 2 + insets.left;
                int y = insets.top;
                PanelWindowContainer.this.closeBox.setBounds(insets.left, insets.top, rowHeight, rowHeight);
                PanelWindowContainer.this.menuBtn.setBounds(insets.left + rowHeight, insets.top, rowHeight, rowHeight);
                for (int i = 2; i < comp.length; ++i) {
                    int btnWidth = comp[i].getPreferredSize().width;
                    if (btnWidth + x > width) {
                        x = insets.left;
                        y += rowHeight;
                    }
                    comp[i].setBounds(x, y, btnWidth, rowHeight);
                    x += btnWidth;
                }
            } else {
                int height = parent.getHeight() - insets.bottom;
                int colWidth = Math.max(dim.width, ((PanelWindowContainer)PanelWindowContainer.this).closeBox.getPreferredSize().height);
                int x = insets.left;
                int y = colWidth * 2 + insets.top;
                PanelWindowContainer.this.closeBox.setBounds(insets.left, insets.top, colWidth, colWidth);
                PanelWindowContainer.this.menuBtn.setBounds(insets.left, insets.top + colWidth, colWidth, colWidth);
                for (int i = 2; i < comp.length; ++i) {
                    int btnHeight = comp[i].getPreferredSize().height;
                    if (btnHeight + y > height) {
                        x += colWidth;
                        y = insets.top;
                    }
                    comp[i].setBounds(x, y, colWidth, btnHeight);
                    y += btnHeight;
                }
            }
        }
    }

    public static class RotatedTextIcon
    implements Icon {
        public static final int NONE = 0;
        public static final int CW = 1;
        public static final int CCW = 2;
        private int rotate;
        private Font font;
        private String text;
        private GlyphVector glyphs;
        private float width;
        private float height;
        private float ascent;
        private RenderingHints renderHints;

        public RotatedTextIcon(int rotate, Font font, String text) {
            this.rotate = rotate;
            this.font = font;
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
            this.text = text;
            this.glyphs = font.createGlyphVector(fontRenderContext, text);
            this.width = (int)this.glyphs.getLogicalBounds().getWidth() + 4;
            LineMetrics lineMetrics = font.getLineMetrics(text, fontRenderContext);
            this.ascent = lineMetrics.getAscent();
            this.height = (int)lineMetrics.getHeight();
            this.renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.renderHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            this.renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }

        public int getIconWidth() {
            return (int)(this.rotate == 1 || this.rotate == 2 ? this.height : this.width);
        }

        public int getIconHeight() {
            return (int)(this.rotate == 1 || this.rotate == 2 ? this.width : this.height);
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setFont(this.font);
            AffineTransform oldTransform = g2d.getTransform();
            RenderingHints oldHints = g2d.getRenderingHints();
            g2d.setRenderingHints(this.renderHints);
            g2d.setColor(c.getForeground());
            if (this.rotate == 0) {
                g2d.drawGlyphVector(this.glyphs, x + 2, (float)y + this.ascent);
            } else if (this.rotate == 1) {
                AffineTransform trans = new AffineTransform();
                trans.concatenate(oldTransform);
                trans.translate(x, y + 2);
                trans.rotate(1.5707963267948966, this.height / 2.0f, this.width / 2.0f);
                g2d.setTransform(trans);
                g2d.drawGlyphVector(this.glyphs, (this.height - this.width) / 2.0f, (this.width - this.height) / 2.0f + this.ascent);
            } else if (this.rotate == 2) {
                AffineTransform trans = new AffineTransform();
                trans.concatenate(oldTransform);
                trans.translate(x, y - 2);
                trans.rotate(4.71238898038469, this.height / 2.0f, this.width / 2.0f);
                g2d.setTransform(trans);
                g2d.drawGlyphVector(this.glyphs, (this.height - this.width) / 2.0f, (this.width - this.height) / 2.0f + this.ascent);
            }
            g2d.setTransform(oldTransform);
            g2d.setRenderingHints(oldHints);
        }
    }

    static class DockBorder
    implements Border {
        String position;
        Insets insets;
        Color color1;
        Color color2;
        Color color3;

        DockBorder(String position) {
            this.position = position;
            this.insets = new Insets(position.equals("bottom") ? 10 : 0, position.equals("right") ? 10 : 0, position.equals("top") ? 10 : 0, position.equals("left") ? 10 : 0);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.updateColors();
            if (this.color1 == null || this.color2 == null || this.color3 == null) {
                return;
            }
            if (this.position.equals("bottom")) {
                this.paintHorizBorder(g, x, y, width);
            } else if (this.position.equals("right")) {
                this.paintVertBorder(g, x, y, height);
            } else if (this.position.equals("top")) {
                this.paintHorizBorder(g, x, y + height - 10, width);
            } else if (this.position.equals("left")) {
                this.paintVertBorder(g, x + width - 10, y, height);
            }
        }

        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }

        private void paintHorizBorder(Graphics g, int x, int y, int width) {
            g.setColor(this.color3);
            g.fillRect(x, y, width, 10);
            for (int i = 0; i < width / 4 - 1; ++i) {
                g.setColor(this.color1);
                g.drawLine(x + i * 4 + 2, y + 3, x + i * 4 + 2, y + 3);
                g.setColor(this.color2);
                g.drawLine(x + i * 4 + 3, y + 4, x + i * 4 + 3, y + 4);
                g.setColor(this.color1);
                g.drawLine(x + i * 4 + 4, y + 5, x + i * 4 + 4, y + 5);
                g.setColor(this.color2);
                g.drawLine(x + i * 4 + 5, y + 6, x + i * 4 + 5, y + 6);
            }
        }

        private void paintVertBorder(Graphics g, int x, int y, int height) {
            g.setColor(this.color3);
            g.fillRect(x, y, 10, height);
            for (int i = 0; i < height / 4 - 1; ++i) {
                g.setColor(this.color1);
                g.drawLine(x + 3, y + i * 4 + 2, x + 3, y + i * 4 + 2);
                g.setColor(this.color2);
                g.drawLine(x + 4, y + i * 4 + 3, x + 4, y + i * 4 + 3);
                g.setColor(this.color1);
                g.drawLine(x + 5, y + i * 4 + 4, x + 5, y + i * 4 + 4);
                g.setColor(this.color2);
                g.drawLine(x + 6, y + i * 4 + 5, x + 6, y + i * 4 + 5);
            }
        }

        private void updateColors() {
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                this.color1 = MetalLookAndFeel.getControlHighlight();
                this.color2 = MetalLookAndFeel.getControlDarkShadow();
                this.color3 = MetalLookAndFeel.getControl();
            } else {
                this.color3 = null;
                this.color2 = null;
                this.color1 = null;
            }
        }
    }

    class MenuMouseHandler
    extends MouseAdapter {
        MenuMouseHandler() {
        }

        public void mousePressed(MouseEvent evt) {
            if (PanelWindowContainer.this.popup != null && PanelWindowContainer.this.popup.isVisible()) {
                PanelWindowContainer.this.popup.setVisible(false);
                return;
            }
            Component comp = (Component)evt.getSource();
            String dockable = comp instanceof JToggleButton ? ((JToggleButton)comp).getActionCommand() : PanelWindowContainer.this.getCurrent();
            if (comp == PanelWindowContainer.this.menuBtn || GUIUtilities.isPopupTrigger(evt)) {
                boolean point;
                int y;
                int x;
                if (dockable == null) {
                    PanelWindowContainer.this.popup = PanelWindowContainer.this.wm.createPopupMenu(PanelWindowContainer.this, null, false);
                } else {
                    PanelWindowContainer.this.popup = PanelWindowContainer.this.wm.createPopupMenu(PanelWindowContainer.this, dockable, false);
                }
                if (comp == PanelWindowContainer.this.menuBtn) {
                    x = 0;
                    y = PanelWindowContainer.this.menuBtn.getHeight();
                    point = false;
                } else {
                    x = evt.getX();
                    y = evt.getY();
                    point = true;
                }
                GUIUtilities.showPopupMenu(PanelWindowContainer.this.popup, comp, x, y, point);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (PanelWindowContainer.this.popup != null && PanelWindowContainer.this.popup.isVisible()) {
                PanelWindowContainer.this.popup.setVisible(false);
            }
            if (evt.getSource() == PanelWindowContainer.this.closeBox) {
                PanelWindowContainer.this.show(null);
            } else if (PanelWindowContainer.this.wm.isDockableWindowVisible(evt.getActionCommand())) {
                PanelWindowContainer.this.show(null);
            } else {
                PanelWindowContainer.this.wm.showDockableWindow(evt.getActionCommand());
            }
        }
    }

    static class DockableWindowCompare
    implements Comparator {
        DockableWindowCompare() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ((AbstractButton)o1).getActionCommand();
            String name2 = ((AbstractButton)o2).getActionCommand();
            return MiscUtilities.compareStrings(jEdit.getProperty(name1 + ".title", ""), jEdit.getProperty(name2 + ".title", ""), true);
        }
    }
}

