/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;

public class LogViewer
extends JPanel
implements DefaultFocusComponent,
EBComponent {
    private JList list;
    private JButton copy;
    private JCheckBox tail;
    private boolean tailIsOn;

    public LogViewer() {
        super(new BorderLayout());
        JPanel caption = new JPanel();
        caption.setLayout(new BoxLayout(caption, 0));
        caption.setBorder(new EmptyBorder(6, 6, 6, 6));
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory != null) {
            Object[] args = new String[]{MiscUtilities.constructPath(settingsDirectory, "activity.log")};
            JLabel label = new JLabel(jEdit.getProperty("log-viewer.caption", args));
            caption.add(label);
        }
        caption.add(Box.createHorizontalGlue());
        this.tailIsOn = jEdit.getBooleanProperty("log-viewer.tail", false);
        this.tail = new JCheckBox(jEdit.getProperty("log-viewer.tail.label"), this.tailIsOn);
        this.tail.addActionListener(new ActionHandler());
        caption.add(this.tail);
        caption.add(Box.createHorizontalStrut(12));
        this.copy = new JButton(jEdit.getProperty("log-viewer.copy"));
        this.copy.addActionListener(new ActionHandler());
        caption.add(this.copy);
        ListModel model = Log.getLogListModel();
        model.addListDataListener(new ListHandler());
        this.list = new LogList(model);
        this.add("North", caption);
        JScrollPane scroller = new JScrollPane(this.list);
        Dimension dim = scroller.getPreferredSize();
        dim.width = Math.min(600, dim.width);
        scroller.setPreferredSize(dim);
        this.add("Center", scroller);
        this.propertiesChanged();
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof PropertiesChanged) {
            this.propertiesChanged();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.tailIsOn) {
            int index = this.list.getModel().getSize() - 1;
            this.list.ensureIndexIsVisible(index);
        }
        EditBus.addToBus(this);
    }

    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus(this);
    }

    public void focusOnDefaultComponent() {
        this.list.requestFocus();
    }

    private void propertiesChanged() {
        this.list.setFont(jEdit.getFontProperty("view.font"));
        this.list.setFixedCellHeight(this.list.getFontMetrics(this.list.getFont()).getHeight());
    }

    class LogList
    extends JList {
        private int startIndex;

        LogList(ListModel model) {
            super(model);
            this.setVisibleRowCount(24);
            this.getSelectionModel().setSelectionMode(1);
            this.setAutoscrolls(true);
        }

        public void processMouseEvent(MouseEvent evt) {
            if (evt.getID() == 501) {
                this.startIndex = LogViewer.this.list.locationToIndex(evt.getPoint());
            }
            super.processMouseEvent(evt);
        }

        public void processMouseMotionEvent(MouseEvent evt) {
            if (evt.getID() == 506) {
                int row = LogViewer.this.list.locationToIndex(evt.getPoint());
                if (row != -1) {
                    if (this.startIndex == -1) {
                        LogViewer.this.list.setSelectionInterval(row, row);
                        this.startIndex = row;
                    } else {
                        LogViewer.this.list.setSelectionInterval(this.startIndex, row);
                    }
                    LogViewer.this.list.ensureIndexIsVisible(row);
                    evt.consume();
                }
            } else {
                super.processMouseMotionEvent(evt);
            }
        }
    }

    class ListHandler
    implements ListDataListener {
        ListHandler() {
        }

        public void intervalAdded(ListDataEvent e) {
            this.contentsChanged(e);
        }

        public void intervalRemoved(ListDataEvent e) {
            this.contentsChanged(e);
        }

        public void contentsChanged(ListDataEvent e) {
            if (LogViewer.this.tailIsOn) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ ListHandler this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        int index = LogViewer.access$200(ListHandler.access$400(this.this$1)).getModel().getSize() - 1;
                        LogViewer.access$200(ListHandler.access$400(this.this$1)).ensureIndexIsVisible(index);
                    }
                });
            }
        }

        static /* synthetic */ LogViewer access$400(ListHandler x0) {
            return x0.LogViewer.this;
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == LogViewer.this.tail) {
                int index;
                LogViewer.this.tailIsOn = !LogViewer.this.tailIsOn;
                jEdit.setBooleanProperty("log-viewer.tail", LogViewer.this.tailIsOn);
                if (LogViewer.this.tailIsOn && (index = LogViewer.this.list.getModel().getSize()) != 0) {
                    LogViewer.this.list.ensureIndexIsVisible(index - 1);
                }
            } else if (src == LogViewer.this.copy) {
                StringBuffer buf = new StringBuffer();
                Object[] selected = LogViewer.this.list.getSelectedValues();
                if (selected != null && selected.length != 0) {
                    for (int i = 0; i < selected.length; ++i) {
                        buf.append(selected[i]);
                        buf.append('\n');
                    }
                } else {
                    ListModel model = LogViewer.this.list.getModel();
                    for (int i = 0; i < model.getSize(); ++i) {
                        buf.append(model.getElementAt(i));
                        buf.append('\n');
                    }
                }
                Registers.setRegister('$', buf.toString());
            }
        }
    }
}

