/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import bsh.NameSpace;
import bsh.UtilEvalError;
import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowContainer;
import org.gjt.sp.jedit.gui.FloatingWindowContainer;
import org.gjt.sp.jedit.gui.PanelWindowContainer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DockableWindowUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;

public class DockableWindowManager
extends JPanel
implements EBComponent {
    public static final String FLOATING = "floating";
    public static final String TOP = "top";
    public static final String LEFT = "left";
    public static final String BOTTOM = "bottom";
    public static final String RIGHT = "right";
    private static HashMap dockableWindowFactories = new HashMap();
    int resizePos;
    Rectangle resizeRect;
    private View view;
    private Hashtable windows;
    private boolean alternateLayout;
    private PanelWindowContainer left;
    private PanelWindowContainer right;
    private PanelWindowContainer top;
    private PanelWindowContainer bottom;
    private ArrayList clones;
    static /* synthetic */ Class class$org$gjt$sp$jedit$gui$DockableWindowManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void loadDockableWindows(PluginJAR plugin, URL uri, PluginJAR.PluginCacheEntry cache) {
        block15: {
            Reader in;
            block14: {
                in = null;
                Log.log(1, class$org$gjt$sp$jedit$gui$DockableWindowManager == null ? (class$org$gjt$sp$jedit$gui$DockableWindowManager = DockableWindowManager.class$("org.gjt.sp.jedit.gui.DockableWindowManager")) : class$org$gjt$sp$jedit$gui$DockableWindowManager, "Loading dockables from " + uri);
                DockableListHandler dh = new DockableListHandler(plugin, uri);
                in = new BufferedReader(new InputStreamReader(uri.openStream()));
                XmlParser parser = new XmlParser();
                parser.setHandler(dh);
                parser.parse(null, null, in);
                if (cache == null) break block14;
                cache.cachedDockableNames = dh.getCachedDockableNames();
                cache.cachedDockableActionFlags = dh.getCachedDockableActionFlags();
            }
            Object var8_9 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block15;
            }
            catch (IOException io) {
                Log.log(9, class$org$gjt$sp$jedit$gui$DockableWindowManager == null ? (class$org$gjt$sp$jedit$gui$DockableWindowManager = DockableWindowManager.class$("org.gjt.sp.jedit.gui.DockableWindowManager")) : class$org$gjt$sp$jedit$gui$DockableWindowManager, io);
            }
            break block15;
            {
                catch (XmlException xe) {
                    int line = xe.getLine();
                    String message = xe.getMessage();
                    Log.log(9, class$org$gjt$sp$jedit$gui$DockableWindowManager == null ? (class$org$gjt$sp$jedit$gui$DockableWindowManager = DockableWindowManager.class$("org.gjt.sp.jedit.gui.DockableWindowManager")) : class$org$gjt$sp$jedit$gui$DockableWindowManager, uri + ":" + line + ": " + message);
                    Object var8_10 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block15;
                    }
                    catch (IOException io) {
                        Log.log(9, class$org$gjt$sp$jedit$gui$DockableWindowManager == null ? (class$org$gjt$sp$jedit$gui$DockableWindowManager = DockableWindowManager.class$("org.gjt.sp.jedit.gui.DockableWindowManager")) : class$org$gjt$sp$jedit$gui$DockableWindowManager, io);
                    }
                    break block15;
                }
                catch (Exception e) {
                    Log.log(9, class$org$gjt$sp$jedit$gui$DockableWindowManager == null ? (class$org$gjt$sp$jedit$gui$DockableWindowManager = DockableWindowManager.class$("org.gjt.sp.jedit.gui.DockableWindowManager")) : class$org$gjt$sp$jedit$gui$DockableWindowManager, e);
                    Object var8_11 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block15;
                    }
                    catch (IOException io) {
                        Log.log(9, class$org$gjt$sp$jedit$gui$DockableWindowManager == null ? (class$org$gjt$sp$jedit$gui$DockableWindowManager = DockableWindowManager.class$("org.gjt.sp.jedit.gui.DockableWindowManager")) : class$org$gjt$sp$jedit$gui$DockableWindowManager, io);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException io) {
                    Log.log(9, class$org$gjt$sp$jedit$gui$DockableWindowManager == null ? (class$org$gjt$sp$jedit$gui$DockableWindowManager = DockableWindowManager.class$("org.gjt.sp.jedit.gui.DockableWindowManager")) : class$org$gjt$sp$jedit$gui$DockableWindowManager, io);
                }
                throw throwable;
            }
        }
    }

    public static void unloadDockableWindows(PluginJAR plugin) {
        Iterator entries = dockableWindowFactories.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Factory factory = (Factory)entry.getValue();
            if (factory.plugin != plugin) continue;
            entries.remove();
        }
    }

    public static void cacheDockableWindows(PluginJAR plugin, String[] name, boolean[] actions) {
        for (int i = 0; i < name.length; ++i) {
            Factory factory = new Factory(plugin, name[i], null, actions[i]);
            dockableWindowFactories.put(name[i], factory);
        }
    }

    public static void registerDockableWindow(PluginJAR plugin, String name, String code, boolean actions) {
        Factory factory = (Factory)dockableWindowFactories.get(name);
        if (factory != null) {
            factory.code = code;
            factory.loaded = true;
        } else {
            factory = new Factory(plugin, name, code, actions);
            dockableWindowFactories.put(name, factory);
        }
    }

    public static String[] getRegisteredDockableWindows() {
        String[] retVal = new String[dockableWindowFactories.size()];
        Iterator entries = dockableWindowFactories.values().iterator();
        int i = 0;
        while (entries.hasNext()) {
            Factory factory = (Factory)entries.next();
            retVal[i++] = factory.name;
        }
        return retVal;
    }

    public DockableWindowManager(View view, View.ViewConfig config) {
        this.setLayout(new DockableLayout());
        this.view = view;
        this.windows = new Hashtable();
        this.clones = new ArrayList();
        this.top = new PanelWindowContainer(this, TOP, config.topPos);
        this.left = new PanelWindowContainer(this, LEFT, config.leftPos);
        this.bottom = new PanelWindowContainer(this, BOTTOM, config.bottomPos);
        this.right = new PanelWindowContainer(this, RIGHT, config.rightPos);
        this.add("top-buttons", this.top.buttonPanel);
        this.add("left-buttons", this.left.buttonPanel);
        this.add("bottom-buttons", this.bottom.buttonPanel);
        this.add("right-buttons", this.right.buttonPanel);
        this.add(TOP, this.top.dockablePanel);
        this.add(LEFT, this.left.dockablePanel);
        this.add(BOTTOM, this.bottom.dockablePanel);
        this.add(RIGHT, this.right.dockablePanel);
    }

    public void init() {
        EditBus.addToBus(this);
        Iterator entries = dockableWindowFactories.values().iterator();
        while (entries.hasNext()) {
            this.addEntry((Factory)entries.next());
        }
        this.propertiesChanged();
    }

    public View getView() {
        return this.view;
    }

    public JComponent floatDockableWindow(String name) {
        Entry entry = (Entry)this.windows.get(name);
        if (entry == null) {
            Log.log(9, this, "Unknown dockable window: " + name);
            return null;
        }
        Entry newEntry = new Entry(entry.factory, FLOATING);
        newEntry.win = newEntry.factory.createDockableWindow(this.view, FLOATING);
        if (newEntry.win != null) {
            newEntry.container = new FloatingWindowContainer(this, true);
            newEntry.container.register(newEntry);
            newEntry.container.show(newEntry);
        }
        this.clones.add(newEntry);
        return newEntry.win;
    }

    public void showDockableWindow(String name) {
        Entry entry = (Entry)this.windows.get(name);
        if (entry == null) {
            Log.log(9, this, "Unknown dockable window: " + name);
            return;
        }
        if (entry.win == null) {
            entry.win = entry.factory.createDockableWindow(this.view, entry.position);
        }
        if (entry.win != null) {
            if (entry.position.equals(FLOATING) && entry.container == null) {
                entry.container = new FloatingWindowContainer(this, this.view.isPlainView());
                entry.container.register(entry);
            }
            entry.container.show(entry);
        }
    }

    public void addDockableWindow(String name) {
        this.showDockableWindow(name);
    }

    public void hideDockableWindow(String name) {
        Entry entry = (Entry)this.windows.get(name);
        if (entry == null) {
            Log.log(9, this, "Unknown dockable window: " + name);
            return;
        }
        if (entry.win == null) {
            return;
        }
        entry.container.show(null);
    }

    public void removeDockableWindow(String name) {
        this.hideDockableWindow(name);
    }

    public void toggleDockableWindow(String name) {
        if (this.isDockableWindowVisible(name)) {
            this.removeDockableWindow(name);
        } else {
            this.addDockableWindow(name);
        }
    }

    public JComponent getDockableWindow(String name) {
        return this.getDockable(name);
    }

    public JComponent getDockable(String name) {
        Entry entry = (Entry)this.windows.get(name);
        if (entry == null || entry.win == null) {
            return null;
        }
        return entry.win;
    }

    public String getDockableTitle(String name) {
        String title = jEdit.getProperty(name + ".title");
        if (title == null) {
            return "NO TITLE PROPERTY: " + name;
        }
        return title;
    }

    public boolean isDockableWindowVisible(String name) {
        Entry entry = (Entry)this.windows.get(name);
        if (entry == null || entry.win == null) {
            return false;
        }
        return entry.container.isVisible(entry);
    }

    public boolean isDockableWindowDocked(String name) {
        Entry entry = (Entry)this.windows.get(name);
        if (entry == null) {
            return false;
        }
        return !entry.position.equals(FLOATING);
    }

    public void closeCurrentArea() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (Component comp = DockableWindowManager.this.view.getFocusOwner(); comp != null; comp = comp.getParent()) {
                    if (!(comp instanceof PanelWindowContainer.DockablePanel)) continue;
                    PanelWindowContainer container = ((PanelWindowContainer.DockablePanel)comp).getWindowContainer();
                    container.show(null);
                    return;
                }
                DockableWindowManager.this.getToolkit().beep();
            }
        });
    }

    public void close() {
        Entry entry;
        EditBus.removeFromBus(this);
        Iterator<Object> iter = this.windows.values().iterator();
        while (iter.hasNext()) {
            entry = (Entry)iter.next();
            if (entry.win == null) continue;
            entry.container.unregister(entry);
        }
        iter = this.clones.iterator();
        while (iter.hasNext()) {
            entry = (Entry)iter.next();
            if (entry.win == null) continue;
            entry.container.unregister(entry);
        }
    }

    public PanelWindowContainer getTopDockingArea() {
        return this.top;
    }

    public PanelWindowContainer getLeftDockingArea() {
        return this.left;
    }

    public PanelWindowContainer getBottomDockingArea() {
        return this.bottom;
    }

    public PanelWindowContainer getRightDockingArea() {
        return this.right;
    }

    public JPopupMenu createPopupMenu(final DockableWindowContainer container, final String dockable, final boolean clone) {
        JPopupMenu popup = new JPopupMenu();
        if (dockable == null && container instanceof PanelWindowContainer) {
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DockableWindowManager.this.showDockableWindow(evt.getActionCommand());
                }
            };
            String[] dockables = ((PanelWindowContainer)container).getDockables();
            for (int i = 0; i < dockables.length; ++i) {
                String name = dockables[i];
                JMenuItem item = new JMenuItem(this.getDockableTitle(name));
                item.setActionCommand(name);
                item.addActionListener(listener);
                popup.add(item);
            }
        } else {
            JMenuItem caption = new JMenuItem(this.getDockableTitle(dockable));
            caption.setEnabled(false);
            popup.add(caption);
            popup.addSeparator();
            String currentPos = jEdit.getProperty(dockable + ".dock-position", FLOATING);
            if (!clone) {
                String[] positions = new String[]{FLOATING, TOP, LEFT, BOTTOM, RIGHT};
                for (int i = 0; i < positions.length; ++i) {
                    final String pos = positions[i];
                    if (pos.equals(currentPos)) continue;
                    JMenuItem moveMenuItem = new JMenuItem(jEdit.getProperty("view.docking.menu-" + pos));
                    moveMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            jEdit.setProperty(dockable + ".dock-position", pos);
                            EditBus.send(new DockableWindowUpdate(DockableWindowManager.this, DockableWindowUpdate.PROPERTIES_CHANGED, null));
                            DockableWindowManager.this.showDockableWindow(dockable);
                        }
                    });
                    popup.add(moveMenuItem);
                }
                popup.addSeparator();
            }
            JMenuItem cloneMenuItem = new JMenuItem(jEdit.getProperty("view.docking.menu-clone"));
            cloneMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DockableWindowManager.this.floatDockableWindow(dockable);
                }
            });
            popup.add(cloneMenuItem);
            popup.addSeparator();
            JMenuItem closeMenuItem = new JMenuItem(jEdit.getProperty("view.docking.menu-close"));
            closeMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (clone) {
                        ((FloatingWindowContainer)container).dispose();
                    } else {
                        DockableWindowManager.this.removeDockableWindow(dockable);
                    }
                }
            });
            popup.add(closeMenuItem);
            if (!clone && !currentPos.equals(FLOATING)) {
                JMenuItem undockMenuItem = new JMenuItem(jEdit.getProperty("view.docking.menu-undock"));
                undockMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        jEdit.setProperty(dockable + ".dock-position", DockableWindowManager.FLOATING);
                        EditBus.send(new DockableWindowUpdate(DockableWindowManager.this, DockableWindowUpdate.PROPERTIES_CHANGED, null));
                    }
                });
                popup.add(undockMenuItem);
            }
        }
        return popup;
    }

    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.resizeRect != null) {
            g.setColor(Color.darkGray);
            g.fillRect(this.resizeRect.x, this.resizeRect.y, this.resizeRect.width, this.resizeRect.height);
        }
    }

    public void handleMessage(EBMessage msg) {
        block10: {
            block11: {
                block9: {
                    if (!(msg instanceof DockableWindowUpdate)) break block9;
                    if (((DockableWindowUpdate)msg).getWhat() != DockableWindowUpdate.PROPERTIES_CHANGED) break block10;
                    this.propertiesChanged();
                    break block10;
                }
                if (!(msg instanceof PropertiesChanged)) break block11;
                this.propertiesChanged();
                break block10;
            }
            if (!(msg instanceof PluginUpdate)) break block10;
            PluginUpdate pmsg = (PluginUpdate)msg;
            if (pmsg.getWhat() == PluginUpdate.LOADED) {
                Iterator iter = dockableWindowFactories.values().iterator();
                while (iter.hasNext()) {
                    Factory factory = (Factory)iter.next();
                    if (factory.plugin != pmsg.getPluginJAR()) continue;
                    this.addEntry(factory);
                }
                this.propertiesChanged();
            } else if (!pmsg.isExiting()) {
                if (pmsg.getWhat() == PluginUpdate.DEACTIVATED) {
                    Iterator iter = this.getAllPluginEntries(pmsg.getPluginJAR(), false);
                    while (iter.hasNext()) {
                        Entry entry = (Entry)iter.next();
                        if (entry.container == null) continue;
                        entry.container.remove(entry);
                    }
                } else if (pmsg.getWhat() == PluginUpdate.UNLOADED) {
                    Iterator iter = this.getAllPluginEntries(pmsg.getPluginJAR(), true);
                    while (iter.hasNext()) {
                        Entry entry = (Entry)iter.next();
                        if (entry.container == null) continue;
                        entry.container.unregister(entry);
                        entry.win = null;
                        entry.container = null;
                    }
                }
            }
        }
    }

    void setResizePos(int resizePos, PanelWindowContainer resizing) {
        this.resizePos = resizePos;
        if (resizePos < 0) {
            resizePos = 0;
        }
        Rectangle newResizeRect = new Rectangle(0, 0, 8, 8);
        if (resizing == this.top) {
            resizePos = Math.min(resizePos, this.getHeight() - this.top.buttonPanel.getHeight() - this.bottom.dockablePanel.getHeight() - this.bottom.buttonPanel.getHeight() - 10);
            newResizeRect.x = this.top.dockablePanel.getX() + 1;
            newResizeRect.y = resizePos + this.top.buttonPanel.getHeight() + 1;
            newResizeRect.width = this.top.dockablePanel.getWidth() - 2;
        } else if (resizing == this.left) {
            resizePos = Math.min(resizePos, this.getWidth() - this.left.buttonPanel.getWidth() - this.right.dockablePanel.getWidth() - this.right.buttonPanel.getWidth() - 10);
            newResizeRect.x = resizePos + this.left.buttonPanel.getWidth() + 1;
            newResizeRect.y = this.left.dockablePanel.getY() + 1;
            newResizeRect.height = this.left.dockablePanel.getHeight() - 2;
        } else if (resizing == this.bottom) {
            resizePos = Math.min(resizePos, this.getHeight() - this.bottom.buttonPanel.getHeight() - this.top.dockablePanel.getHeight() - this.top.buttonPanel.getHeight() - 10);
            newResizeRect.x = this.bottom.dockablePanel.getX() + 1;
            newResizeRect.y = this.getHeight() - this.bottom.buttonPanel.getHeight() - resizePos - 10 + 2;
            newResizeRect.width = this.bottom.dockablePanel.getWidth() - 2;
        } else if (resizing == this.right) {
            resizePos = Math.min(resizePos, this.getWidth() - this.right.buttonPanel.getWidth() - this.left.dockablePanel.getWidth() - this.left.buttonPanel.getWidth() - 10);
            newResizeRect.x = this.getWidth() - this.right.buttonPanel.getWidth() - resizePos - 10 + 1;
            newResizeRect.y = this.right.dockablePanel.getY() + 1;
            newResizeRect.height = this.right.dockablePanel.getHeight() - 2;
        }
        Rectangle toRepaint = this.resizeRect == null ? newResizeRect : this.resizeRect.union(newResizeRect);
        this.resizeRect = newResizeRect;
        this.repaint(toRepaint);
    }

    void finishResizing() {
        this.resizeRect = null;
        this.repaint();
    }

    private void propertiesChanged() {
        if (this.view.isPlainView()) {
            return;
        }
        this.alternateLayout = jEdit.getBooleanProperty("view.docking.alternateLayout");
        String[] windowList = DockableWindowManager.getRegisteredDockableWindows();
        for (int i = 0; i < windowList.length; ++i) {
            String dockable = windowList[i];
            Entry entry = (Entry)this.windows.get(dockable);
            String newPosition = jEdit.getProperty(dockable + ".dock-position", FLOATING);
            if (newPosition.equals(entry.position)) continue;
            entry.position = newPosition;
            if (entry.container != null) {
                entry.container.unregister(entry);
                entry.container = null;
                entry.win = null;
            }
            if (newPosition.equals(FLOATING)) continue;
            if (newPosition.equals(TOP)) {
                entry.container = this.top;
            } else if (newPosition.equals(LEFT)) {
                entry.container = this.left;
            } else if (newPosition.equals(BOTTOM)) {
                entry.container = this.bottom;
            } else if (newPosition.equals(RIGHT)) {
                entry.container = this.right;
            } else {
                Log.log(7, this, "Unknown position: " + newPosition);
                continue;
            }
            entry.container.register(entry);
        }
        this.top.sortDockables();
        this.left.sortDockables();
        this.bottom.sortDockables();
        this.right.sortDockables();
        this.revalidate();
        this.repaint();
    }

    private void addEntry(Factory factory) {
        Entry e;
        if (this.view.isPlainView()) {
            e = new Entry(factory, FLOATING);
        } else {
            e = new Entry(factory);
            if (!e.position.equals(FLOATING)) {
                if (e.position.equals(TOP)) {
                    e.container = this.top;
                } else if (e.position.equals(LEFT)) {
                    e.container = this.left;
                } else if (e.position.equals(BOTTOM)) {
                    e.container = this.bottom;
                } else if (e.position.equals(RIGHT)) {
                    e.container = this.right;
                } else {
                    Log.log(7, this, "Unknown position: " + e.position);
                }
            }
            if (e.container != null) {
                e.container.register(e);
            }
        }
        this.windows.put(factory.name, e);
    }

    private Iterator getAllPluginEntries(PluginJAR plugin, boolean remove) {
        Entry entry;
        LinkedList<Entry> returnValue = new LinkedList<Entry>();
        Iterator<Object> iter = this.windows.values().iterator();
        while (iter.hasNext()) {
            entry = (Entry)iter.next();
            if (entry.factory.plugin != plugin) continue;
            returnValue.add(entry);
            if (!remove) continue;
            iter.remove();
        }
        iter = this.clones.iterator();
        while (iter.hasNext()) {
            entry = (Entry)iter.next();
            if (entry.factory.plugin != plugin) continue;
            returnValue.add(entry);
            iter.remove();
        }
        return returnValue.iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Entry {
        Factory factory;
        String title;
        String position;
        DockableWindowContainer container;
        JComponent win;
        AbstractButton btn;

        Entry(Factory factory) {
            this(factory, jEdit.getProperty(factory.name + ".dock-position", DockableWindowManager.FLOATING));
        }

        Entry(Factory factory, String position) {
            this.factory = factory;
            this.position = position;
            this.title = DockableWindowManager.this.getDockableTitle(factory.name);
        }
    }

    public class DockableLayout
    implements LayoutManager2 {
        static final String CENTER = "Center";
        public static final String TOP_TOOLBARS = "top-toolbars";
        public static final String BOTTOM_TOOLBARS = "bottom-toolbars";
        static final String TOP_BUTTONS = "top-buttons";
        static final String LEFT_BUTTONS = "left-buttons";
        static final String BOTTOM_BUTTONS = "bottom-buttons";
        static final String RIGHT_BUTTONS = "right-buttons";
        Component topToolbars;
        Component bottomToolbars;
        Component center;
        Component top;
        Component left;
        Component bottom;
        Component right;
        Component topButtons;
        Component leftButtons;
        Component bottomButtons;
        Component rightButtons;

        public void addLayoutComponent(String name, Component comp) {
            this.addLayoutComponent(comp, name);
        }

        public void addLayoutComponent(Component comp, Object cons) {
            if (cons == null || CENTER.equals(cons)) {
                this.center = comp;
            } else if (TOP_TOOLBARS.equals(cons)) {
                this.topToolbars = comp;
            } else if (BOTTOM_TOOLBARS.equals(cons)) {
                this.bottomToolbars = comp;
            } else if (DockableWindowManager.TOP.equals(cons)) {
                this.top = comp;
            } else if (DockableWindowManager.LEFT.equals(cons)) {
                this.left = comp;
            } else if (DockableWindowManager.BOTTOM.equals(cons)) {
                this.bottom = comp;
            } else if (DockableWindowManager.RIGHT.equals(cons)) {
                this.right = comp;
            } else if (TOP_BUTTONS.equals(cons)) {
                this.topButtons = comp;
            } else if (LEFT_BUTTONS.equals(cons)) {
                this.leftButtons = comp;
            } else if (BOTTOM_BUTTONS.equals(cons)) {
                this.bottomButtons = comp;
            } else if (RIGHT_BUTTONS.equals(cons)) {
                this.rightButtons = comp;
            }
        }

        public void removeLayoutComponent(Component comp) {
            if (this.center == comp) {
                this.center = null;
            }
            if (comp == this.topToolbars) {
                this.topToolbars = null;
            }
            if (comp == this.bottomToolbars) {
                this.bottomToolbars = null;
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension prefSize = new Dimension(0, 0);
            Dimension _top = this.top.getPreferredSize();
            Dimension _left = this.left.getPreferredSize();
            Dimension _bottom = this.bottom.getPreferredSize();
            Dimension _right = this.right.getPreferredSize();
            Dimension _topButtons = this.topButtons.getPreferredSize();
            Dimension _leftButtons = this.leftButtons.getPreferredSize();
            Dimension _bottomButtons = this.bottomButtons.getPreferredSize();
            Dimension _rightButtons = this.rightButtons.getPreferredSize();
            Dimension _center = this.center == null ? new Dimension(0, 0) : this.center.getPreferredSize();
            Dimension _topToolbars = this.topToolbars == null ? new Dimension(0, 0) : this.topToolbars.getPreferredSize();
            Dimension _bottomToolbars = this.bottomToolbars == null ? new Dimension(0, 0) : this.bottomToolbars.getPreferredSize();
            prefSize.height = _top.height + _bottom.height + _center.height + _topButtons.height + _bottomButtons.height + _topToolbars.height + _bottomToolbars.height;
            prefSize.width = _left.width + _right.width + Math.max(_center.width, Math.max(_topToolbars.width, _bottomToolbars.width)) + _leftButtons.width + _rightButtons.width;
            return prefSize;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension maximumLayoutSize(Container parent) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            Dimension _topToolbars = this.topToolbars == null ? new Dimension(0, 0) : this.topToolbars.getPreferredSize();
            Dimension _bottomToolbars = this.bottomToolbars == null ? new Dimension(0, 0) : this.bottomToolbars.getPreferredSize();
            int topButtonHeight = -1;
            int bottomButtonHeight = -1;
            int leftButtonWidth = -1;
            int rightButtonWidth = -1;
            Dimension _top = this.top.getPreferredSize();
            Dimension _left = this.left.getPreferredSize();
            Dimension _bottom = this.bottom.getPreferredSize();
            Dimension _right = this.right.getPreferredSize();
            int topHeight = _top.height;
            int bottomHeight = _bottom.height;
            int leftWidth = _left.width;
            int rightWidth = _right.width;
            boolean topEmpty = ((Container)this.topButtons).getComponentCount() <= 2;
            boolean leftEmpty = ((Container)this.leftButtons).getComponentCount() <= 2;
            boolean bottomEmpty = ((Container)this.bottomButtons).getComponentCount() <= 2;
            boolean rightEmpty = ((Container)this.rightButtons).getComponentCount() <= 2;
            Dimension closeBoxSize = ((Container)this.topButtons).getComponentCount() == 0 ? new Dimension(0, 0) : ((Container)this.topButtons).getComponent(0).getPreferredSize();
            int closeBoxWidth = Math.max(closeBoxSize.width, closeBoxSize.height) + 1;
            if (DockableWindowManager.this.alternateLayout) {
                int _width = size.width;
                int padding = leftEmpty && rightEmpty ? 0 : closeBoxWidth;
                topButtonHeight = DockableWindowManager.this.top.getWrappedDimension(_width - closeBoxWidth * 2);
                this.topButtons.setBounds(padding, 0, size.width - padding * 2, topButtonHeight);
                bottomButtonHeight = DockableWindowManager.this.bottom.getWrappedDimension(_width);
                this.bottomButtons.setBounds(padding, size.height - bottomButtonHeight, size.width - padding * 2, bottomButtonHeight);
                int _height = size.height - topButtonHeight - bottomButtonHeight;
                leftButtonWidth = DockableWindowManager.this.left.getWrappedDimension(_height);
                this.leftButtons.setBounds(0, topHeight + topButtonHeight, leftButtonWidth, _height - topHeight - bottomHeight);
                rightButtonWidth = DockableWindowManager.this.right.getWrappedDimension(_height);
                this.rightButtons.setBounds(size.width - rightButtonWidth, topHeight + topButtonHeight, rightButtonWidth, _height - topHeight - bottomHeight);
                int[] dimensions = this.adjustDockingAreasToFit(size, topHeight, leftWidth, bottomHeight, rightWidth, topButtonHeight, leftButtonWidth, bottomButtonHeight, rightButtonWidth, _topToolbars, _bottomToolbars);
                topHeight = dimensions[0];
                leftWidth = dimensions[1];
                bottomHeight = dimensions[2];
                rightWidth = dimensions[3];
                this.top.setBounds(0, topButtonHeight, size.width, topHeight);
                this.bottom.setBounds(0, size.height - bottomHeight - bottomButtonHeight, size.width, bottomHeight);
                this.left.setBounds(leftButtonWidth, topButtonHeight + topHeight, leftWidth, _height - topHeight - bottomHeight);
                this.right.setBounds(_width - rightButtonWidth - rightWidth, topButtonHeight + topHeight, rightWidth, _height - topHeight - bottomHeight);
            } else {
                int _height = size.height;
                int padding = topEmpty && bottomEmpty ? 0 : closeBoxWidth;
                leftButtonWidth = DockableWindowManager.this.left.getWrappedDimension(_height - closeBoxWidth * 2);
                this.leftButtons.setBounds(0, padding, leftButtonWidth, _height - padding * 2);
                rightButtonWidth = DockableWindowManager.this.right.getWrappedDimension(_height);
                this.rightButtons.setBounds(size.width - rightButtonWidth, padding, rightButtonWidth, _height - padding * 2);
                int _width = size.width - leftButtonWidth - rightButtonWidth;
                topButtonHeight = DockableWindowManager.this.top.getWrappedDimension(_width);
                this.topButtons.setBounds(leftButtonWidth + leftWidth, 0, _width - leftWidth - rightWidth, topButtonHeight);
                bottomButtonHeight = DockableWindowManager.this.bottom.getWrappedDimension(_width);
                this.bottomButtons.setBounds(leftButtonWidth + leftWidth, _height - bottomButtonHeight, _width - leftWidth - rightWidth, bottomButtonHeight);
                int[] dimensions = this.adjustDockingAreasToFit(size, topHeight, leftWidth, bottomHeight, rightWidth, topButtonHeight, leftButtonWidth, bottomButtonHeight, rightButtonWidth, _topToolbars, _bottomToolbars);
                topHeight = dimensions[0];
                leftWidth = dimensions[1];
                bottomHeight = dimensions[2];
                rightWidth = dimensions[3];
                this.top.setBounds(leftButtonWidth + leftWidth, topButtonHeight, _width - leftWidth - rightWidth, topHeight);
                this.bottom.setBounds(leftButtonWidth + leftWidth, size.height - bottomHeight - bottomButtonHeight, _width - leftWidth - rightWidth, bottomHeight);
                this.left.setBounds(leftButtonWidth, 0, leftWidth, _height);
                this.right.setBounds(size.width - rightWidth - rightButtonWidth, 0, rightWidth, _height);
            }
            if (this.topToolbars != null) {
                this.topToolbars.setBounds(leftButtonWidth + leftWidth, topButtonHeight + topHeight, size.width - leftWidth - rightWidth - leftButtonWidth - rightButtonWidth, _topToolbars.height);
            }
            if (this.bottomToolbars != null) {
                this.bottomToolbars.setBounds(leftButtonWidth + leftWidth, size.height - bottomHeight - bottomButtonHeight - _bottomToolbars.height + topButtonHeight + topHeight, size.width - leftWidth - rightWidth - leftButtonWidth - rightButtonWidth, _bottomToolbars.height);
            }
            if (this.center != null) {
                this.center.setBounds(leftButtonWidth + leftWidth, topButtonHeight + topHeight + _topToolbars.height, size.width - leftWidth - rightWidth - leftButtonWidth - rightButtonWidth, size.height - topHeight - topButtonHeight - bottomHeight - bottomButtonHeight - _topToolbars.height - _bottomToolbars.height);
            }
        }

        private int[] adjustDockingAreasToFit(Dimension size, int topHeight, int leftWidth, int bottomHeight, int rightWidth, int topButtonHeight, int leftButtonWidth, int bottomButtonHeight, int rightButtonWidth, Dimension _topToolbars, Dimension _bottomToolbars) {
            int maxTopHeight = size.height - bottomHeight - topButtonHeight - bottomButtonHeight - _topToolbars.height - _bottomToolbars.height;
            topHeight = Math.min(Math.max(0, maxTopHeight), topHeight);
            leftWidth = Math.min(Math.max(0, size.width - leftButtonWidth - rightButtonWidth - rightWidth), leftWidth);
            int maxBottomHeight = size.height - topHeight - topButtonHeight - bottomButtonHeight - _topToolbars.height - _bottomToolbars.height;
            bottomHeight = Math.min(Math.max(0, maxBottomHeight), bottomHeight);
            rightWidth = Math.min(Math.max(0, size.width - leftButtonWidth - rightButtonWidth - leftWidth), rightWidth);
            DockableWindowManager.this.top.setDimension(topHeight);
            DockableWindowManager.this.left.setDimension(leftWidth);
            DockableWindowManager.this.bottom.setDimension(bottomHeight);
            DockableWindowManager.this.right.setDimension(rightWidth);
            return new int[]{topHeight, leftWidth, bottomHeight, rightWidth};
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        public void invalidateLayout(Container target) {
        }
    }

    static class Factory {
        PluginJAR plugin;
        String name;
        String code;
        boolean loaded;

        Factory(PluginJAR plugin, String name, String code, boolean actions) {
            this.plugin = plugin;
            this.name = name;
            this.code = code;
            if (code != null) {
                this.loaded = true;
            }
            if (actions) {
                ActionSet actionSet = plugin == null ? jEdit.getBuiltInActionSet() : plugin.getActionSet();
                actionSet.addAction(new OpenAction(name));
                actionSet.addAction(new ToggleAction(name));
                actionSet.addAction(new FloatAction(name));
                String label = jEdit.getProperty(name + ".label");
                if (label == null) {
                    label = "NO LABEL PROPERTY: " + name;
                }
                Object[] args = new String[]{label};
                jEdit.setTemporaryProperty(name + ".label", label);
                jEdit.setTemporaryProperty(name + "-toggle.label", jEdit.getProperty("view.docking.toggle.label", args));
                jEdit.setTemporaryProperty(name + "-toggle.toggle", "true");
                jEdit.setTemporaryProperty(name + "-float.label", jEdit.getProperty("view.docking.float.label", args));
            }
        }

        void load() {
            if (this.loaded) {
                return;
            }
            DockableWindowManager.loadDockableWindows(this.plugin, this.plugin.getDockablesURI(), null);
        }

        JComponent createDockableWindow(View view, String position) {
            this.load();
            if (!this.loaded) {
                Log.log(7, this, "Outdated cache");
                return null;
            }
            NameSpace nameSpace = new NameSpace(BeanShell.getNameSpace(), "DockableWindowManager.Factory.createDockableWindow()");
            try {
                nameSpace.setVariable("position", position);
            }
            catch (UtilEvalError e) {
                Log.log(9, this, e);
            }
            JComponent win = (JComponent)BeanShell.eval(view, nameSpace, this.code);
            return win;
        }

        static class FloatAction
        extends EditAction {
            private String dockable;

            FloatAction(String name) {
                super(name + "-float");
                this.dockable = name;
            }

            public void invoke(View view) {
                view.getDockableWindowManager().floatDockableWindow(this.dockable);
            }

            public String getCode() {
                return "view.getDockableWindowManager().floatDockableWindow(\"" + this.dockable + "\");";
            }
        }

        static class ToggleAction
        extends EditAction {
            private String dockable;

            ToggleAction(String name) {
                super(name + "-toggle");
                this.dockable = name;
            }

            public void invoke(View view) {
                view.getDockableWindowManager().toggleDockableWindow(this.dockable);
            }

            public boolean isSelected(View view) {
                return view.getDockableWindowManager().isDockableWindowVisible(this.dockable);
            }

            public String getCode() {
                return "view.getDockableWindowManager().toggleDockableWindow(\"" + this.dockable + "\");";
            }
        }

        static class OpenAction
        extends EditAction {
            private String dockable;

            OpenAction(String name) {
                super(name);
                this.dockable = name;
            }

            public void invoke(View view) {
                view.getDockableWindowManager().showDockableWindow(this.dockable);
            }

            public String getCode() {
                return "view.getDockableWindowManager().showDockableWindow(\"" + this.dockable + "\");";
            }
        }
    }

    static class DockableListHandler
    extends HandlerBase {
        private PluginJAR plugin;
        private URL uri;
        private List cachedDockableNames;
        private List cachedDockableActionFlags;
        private String dockableName;
        private String code;
        private boolean actions;
        private Stack stateStack;

        DockableListHandler(PluginJAR plugin, URL uri) {
            this.plugin = plugin;
            this.uri = uri;
            this.stateStack = new Stack();
            this.actions = true;
            this.cachedDockableNames = new LinkedList();
            this.cachedDockableActionFlags = new LinkedList();
        }

        public Object resolveEntity(String publicId, String systemId) {
            if ("dockables.dtd".equals(systemId)) {
                return new StringReader("<!-- -->");
            }
            return null;
        }

        public void attribute(String aname, String value, boolean isSpecified) {
            aname = aname == null ? null : aname.intern();
            String string = value = value == null ? null : value.intern();
            if (aname == "NAME") {
                this.dockableName = value;
            } else if (aname == "NO_ACTIONS") {
                this.actions = value == "FALSE";
            }
        }

        public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
            if ("DOCKABLES".equals(name)) {
                return;
            }
            Log.log(9, this, this.uri + ": DOCTYPE must be DOCKABLES");
        }

        public void charData(char[] c, int off, int len) {
            String tag = this.peekElement();
            String text = new String(c, off, len);
            if (tag == "DOCKABLE") {
                this.code = text;
            }
        }

        public void startElement(String tag) {
            tag = this.pushElement(tag);
        }

        public void endElement(String name) {
            if (name == null) {
                return;
            }
            String tag = this.peekElement();
            if (name.equals(tag)) {
                if (tag == "DOCKABLE") {
                    DockableWindowManager.registerDockableWindow(this.plugin, this.dockableName, this.code, this.actions);
                    this.cachedDockableNames.add(this.dockableName);
                    this.cachedDockableActionFlags.add(new Boolean(this.actions));
                    this.actions = true;
                }
            } else {
                throw new InternalError();
            }
            this.popElement();
        }

        public void startDocument() {
            try {
                this.pushElement(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String[] getCachedDockableNames() {
            return this.cachedDockableNames.toArray(new String[this.cachedDockableNames.size()]);
        }

        public boolean[] getCachedDockableActionFlags() {
            boolean[] returnValue = new boolean[this.cachedDockableActionFlags.size()];
            Iterator iter = this.cachedDockableActionFlags.iterator();
            int i = 0;
            while (iter.hasNext()) {
                boolean flag = (Boolean)iter.next();
                returnValue[i++] = flag;
            }
            return returnValue;
        }

        private String pushElement(String name) {
            name = name == null ? null : name.intern();
            this.stateStack.push(name);
            return name;
        }

        private String peekElement() {
            return (String)this.stateStack.peek();
        }

        private String popElement() {
            return (String)this.stateStack.pop();
        }
    }
}

