/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.text.Position;
import org.gjt.sp.util.Log;

public class PositionManager {
    boolean iteration;
    private SortedMap positions = new TreeMap();

    public synchronized Position createPosition(int offset) {
        PosBottomHalf bh = new PosBottomHalf(offset);
        PosBottomHalf existing = (PosBottomHalf)this.positions.get(bh);
        if (existing == null) {
            this.positions.put(bh, bh);
            existing = bh;
        }
        return new PosTopHalf(existing);
    }

    public synchronized void contentInserted(int offset, int length) {
        if (this.positions.size() == 0) {
            return;
        }
        Iterator<PosBottomHalf> iter = this.positions.tailMap(new PosBottomHalf(offset)).keySet().iterator();
        this.iteration = true;
        while (iter.hasNext()) {
            PosBottomHalf bh = iter.next();
            bh.offset += length;
        }
        this.iteration = false;
    }

    public synchronized void contentRemoved(int offset, int length) {
        if (this.positions.size() == 0) {
            return;
        }
        Iterator<PosBottomHalf> iter = this.positions.tailMap(new PosBottomHalf(offset)).keySet().iterator();
        this.iteration = true;
        while (iter.hasNext()) {
            PosBottomHalf bh = iter.next();
            if (bh.offset <= offset + length) {
                bh.offset = offset;
                continue;
            }
            bh.offset -= length;
        }
        this.iteration = false;
    }

    class PosBottomHalf
    implements Comparable {
        int offset;
        int ref;

        PosBottomHalf(int offset) {
            this.offset = offset;
        }

        void ref() {
            ++this.ref;
        }

        void unref() {
            if (--this.ref == 0) {
                PositionManager.this.positions.remove(this);
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof PosBottomHalf)) {
                return false;
            }
            return ((PosBottomHalf)o).offset == this.offset;
        }

        public int compareTo(Object o) {
            if (PositionManager.this.iteration) {
                Log.log(9, this, "Consistency failure");
            }
            return this.offset - ((PosBottomHalf)o).offset;
        }
    }

    class PosTopHalf
    implements Position {
        PosBottomHalf bh;

        PosTopHalf(PosBottomHalf bh) {
            this.bh = bh;
            bh.ref();
        }

        public int getOffset() {
            return this.bh.offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            PositionManager positionManager = PositionManager.this;
            synchronized (positionManager) {
                this.bh.unref();
            }
        }
    }
}

