/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.BrowserListener;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.browser.VFSFileNameField;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkThreadPool;
import org.gjt.sp.util.WorkThreadProgressListener;

public class VFSFileChooserDialog
extends EnhancedDialog {
    private VFSBrowser browser;
    private VFSFileNameField filenameField;
    private String filename;
    private JButton ok;
    private JButton cancel;
    private boolean isOK;
    private WorkThreadHandler workThreadHandler;

    public VFSFileChooserDialog(View view, String path, int mode, boolean multipleSelection) {
        super(view, jEdit.getProperty("vfs.browser.title"), true);
        String name;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        if (mode == 3) {
            name = null;
        } else if (path == null || path.endsWith(File.separator) || path.endsWith("/")) {
            name = null;
        } else {
            VFS vfs = VFSManager.getVFSForPath(path);
            name = vfs.getFileName(path);
            path = vfs.getParentOfPath(path);
        }
        this.browser = new VFSBrowser(view, path, mode, multipleSelection, null);
        this.browser.getBrowserView().getTable().setRequestFocusEnabled(false);
        this.browser.getBrowserView().getParentDirectoryList().setRequestFocusEnabled(false);
        this.browser.addBrowserListener(new BrowserHandler());
        content.add("Center", this.browser);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.filenameField = new VFSFileNameField(this.browser, null);
        this.filenameField.setText(name);
        this.filenameField.selectAll();
        Box box = new Box(1);
        box.add(Box.createGlue());
        box.add(this.filenameField);
        box.add(Box.createGlue());
        JLabel label = new JLabel(jEdit.getProperty("vfs.browser.dialog.filename"));
        label.setDisplayedMnemonic(jEdit.getProperty("vfs.browser.dialog.filename.mnemonic").charAt(0));
        label.setLabelFor(this.filenameField);
        panel.add(label);
        panel.add(Box.createHorizontalStrut(12));
        panel.add(box);
        panel.add(Box.createHorizontalStrut(12));
        GUIUtilities.requestFocus(this, this.filenameField);
        this.ok = new JButton();
        this.getRootPane().setDefaultButton(this.ok);
        switch (mode) {
            case 0: 
            case 4: {
                this.ok.setText(jEdit.getProperty("vfs.browser.dialog.open"));
                break;
            }
            case 3: {
                this.ok.setText(jEdit.getProperty("vfs.browser.dialog.choose-dir"));
                Dimension dim = this.ok.getPreferredSize();
                this.ok.setPreferredSize(dim);
                break;
            }
            case 1: {
                this.ok.setText(jEdit.getProperty("vfs.browser.dialog.save"));
            }
        }
        this.ok.addActionListener(new ActionHandler());
        panel.add(this.ok);
        panel.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        panel.add(this.cancel);
        content.add("South", panel);
        this.workThreadHandler = new WorkThreadHandler();
        VFSManager.getIOThreadPool().addProgressListener(this.workThreadHandler);
        this.pack();
        GUIUtilities.loadGeometry(this, "vfs.browser.dialog");
        this.setVisible(true);
    }

    public void dispose() {
        GUIUtilities.saveGeometry(this, "vfs.browser.dialog");
        VFSManager.getIOThreadPool().removeProgressListener(this.workThreadHandler);
        super.dispose();
    }

    public void ok() {
        VFS.DirectoryEntry[] files = this.browser.getSelectedFiles();
        this.filename = this.filenameField.getText();
        if (files.length != 0) {
            this.browser.filesActivated(0, false);
            return;
        }
        if (this.browser.getMode() == 3 && (this.filename == null || this.filename.length() == 0)) {
            this.isOK = true;
            this.dispose();
            return;
        }
        if (this.filename == null || this.filename.length() == 0) {
            this.getToolkit().beep();
            return;
        }
        String bufferDir = this.browser.getView().getBuffer().getDirectory();
        if (this.filename.equals("-")) {
            this.filename = bufferDir;
        } else if (this.filename.startsWith("-/") || this.filename.startsWith("-" + File.separator)) {
            this.filename = MiscUtilities.constructPath(bufferDir, this.filename.substring(2));
        }
        final int[] type = new int[]{-1};
        final String path = MiscUtilities.constructPath(this.browser.getDirectory(), this.filename);
        final VFS vfs = VFSManager.getVFSForPath(path);
        Object session = vfs.createVFSSession(path, this);
        if (session == null) {
            return;
        }
        VFSManager.runInWorkThread(new GetFileTypeRequest(vfs, session, path, type));
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                switch (type[0]) {
                    case 0: {
                        if (VFSFileChooserDialog.this.browser.getMode() == 3 || vfs instanceof FileVFS && VFSFileChooserDialog.this.doFileExistsWarning(path)) break;
                        VFSFileChooserDialog.this.isOK = true;
                        if (VFSFileChooserDialog.this.browser.getMode() == 4) {
                            Hashtable<String, String> props = new Hashtable<String, String>();
                            props.put("encoding", ((VFSFileChooserDialog)VFSFileChooserDialog.this).browser.currentEncoding);
                            jEdit.openFile(VFSFileChooserDialog.this.browser.getView(), VFSFileChooserDialog.this.browser.getDirectory(), path, false, props);
                        }
                        VFSFileChooserDialog.this.dispose();
                        break;
                    }
                    case 1: 
                    case 2: {
                        VFSFileChooserDialog.this.browser.setDirectory(path);
                    }
                }
            }
        });
    }

    public void cancel() {
        this.dispose();
    }

    public String[] getSelectedFiles() {
        if (!this.isOK) {
            return null;
        }
        if (this.browser.getMode() == 3) {
            return new String[]{this.browser.getDirectory()};
        }
        if (this.filename != null && this.filename.length() != 0) {
            String path = this.browser.getDirectory();
            return new String[]{MiscUtilities.constructPath(path, this.filename)};
        }
        Vector<String> vector = new Vector<String>();
        VFS.DirectoryEntry[] selectedFiles = this.browser.getSelectedFiles();
        for (int i = 0; i < selectedFiles.length; ++i) {
            VFS.DirectoryEntry file = selectedFiles[i];
            if (file.type != 0) continue;
            vector.addElement(file.path);
        }
        Object[] retVal = new String[vector.size()];
        vector.copyInto(retVal);
        return retVal;
    }

    private boolean doFileExistsWarning(String filename) {
        Object[] args;
        int result;
        return this.browser.getMode() == 1 && new File(filename).exists() && (result = GUIUtilities.confirm(this.browser, "fileexists", args = new String[]{MiscUtilities.getFileName(filename)}, 0, 2)) != 0;
    }

    class GetFileTypeRequest
    implements Runnable {
        VFS vfs;
        Object session;
        String path;
        int[] type;

        GetFileTypeRequest(VFS vfs, Object session, String path, int[] type) {
            this.vfs = vfs;
            this.session = session;
            this.path = path;
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    VFS.DirectoryEntry entry = this.vfs._getDirectoryEntry(this.session, this.path, VFSFileChooserDialog.this.browser);
                    this.type[0] = entry == null ? 0 : entry.type;
                }
                catch (IOException e) {
                    Log.log(9, this, e);
                    VFSManager.error(VFSFileChooserDialog.this.browser, this.path, "ioerror", new String[]{e.toString()});
                    Object var3_4 = null;
                    try {
                        this.vfs._endVFSSession(this.session, VFSFileChooserDialog.this.browser);
                        return;
                    }
                    catch (IOException e2) {
                        Log.log(9, this, e2);
                        VFSManager.error(VFSFileChooserDialog.this.browser, this.path, "ioerror", new String[]{e2.toString()});
                        return;
                    }
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                try {}
                catch (IOException e2) {
                    Log.log(9, this, e2);
                    VFSManager.error(VFSFileChooserDialog.this.browser, this.path, "ioerror", new String[]{e2.toString()});
                    return;
                }
                this.vfs._endVFSSession(this.session, VFSFileChooserDialog.this.browser);
                throw throwable;
            }
            try {}
            catch (IOException e2) {
                Log.log(9, this, e2);
                VFSManager.error(VFSFileChooserDialog.this.browser, this.path, "ioerror", new String[]{e2.toString()});
                return;
            }
            this.vfs._endVFSSession(this.session, VFSFileChooserDialog.this.browser);
        }
    }

    class WorkThreadHandler
    implements WorkThreadProgressListener {
        WorkThreadHandler() {
        }

        public void statusUpdate(WorkThreadPool threadPool, int threadIndex) {
            SwingUtilities.invokeLater(new Runnable(this, threadPool){
                private final /* synthetic */ WorkThreadPool val$threadPool;
                private final /* synthetic */ WorkThreadHandler this$1;
                {
                    this.this$1 = this$1;
                    this.val$threadPool = val$threadPool;
                }

                public void run() {
                    int requestCount = this.val$threadPool.getRequestCount();
                    if (requestCount == 0) {
                        WorkThreadHandler.access$600(this.this$1).getContentPane().setCursor(Cursor.getDefaultCursor());
                    } else if (requestCount >= 1) {
                        WorkThreadHandler.access$600(this.this$1).getContentPane().setCursor(Cursor.getPredefinedCursor(3));
                    }
                }
            });
        }

        public void progressUpdate(WorkThreadPool threadPool, int threadIndex) {
        }

        static /* synthetic */ VFSFileChooserDialog access$600(WorkThreadHandler x0) {
            return x0.VFSFileChooserDialog.this;
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyTyped(KeyEvent evt) {
            switch (evt.getKeyChar()) {
                case '-': 
                case '/': 
                case '~': {
                    VFSFileChooserDialog.this.filenameField.processKeyEvent(evt);
                    VFSFileChooserDialog.this.filenameField.requestFocus();
                }
            }
        }
    }

    class BrowserHandler
    implements BrowserListener {
        BrowserHandler() {
        }

        public void filesSelected(VFSBrowser browser, VFS.DirectoryEntry[] files) {
            if (files.length == 0) {
                if (browser.getMode() == 3) {
                    VFSFileChooserDialog.this.ok.setText(jEdit.getProperty("vfs.browser.dialog.choose-dir"));
                }
                return;
            }
            if (files.length == 1) {
                if (browser.getMode() == 3) {
                    VFSFileChooserDialog.this.ok.setText(jEdit.getProperty("vfs.browser.dialog.open"));
                }
                VFS.DirectoryEntry file = files[0];
                if (file.type == 0) {
                    String path = file.path;
                    String directory = browser.getDirectory();
                    String parent = MiscUtilities.getParentOfPath(path);
                    if (VFSBrowser.pathsEqual(parent, directory)) {
                        path = file.name;
                    }
                    VFSFileChooserDialog.this.filenameField.setText(path);
                    VFSFileChooserDialog.this.filenameField.selectAll();
                }
            } else {
                if (browser.getMode() == 3) {
                    VFSFileChooserDialog.this.ok.setText(jEdit.getProperty("vfs.browser.dialog.open"));
                }
                VFSFileChooserDialog.this.filenameField.setText(null);
            }
        }

        public void filesActivated(VFSBrowser browser, VFS.DirectoryEntry[] files) {
            VFSFileChooserDialog.this.filenameField.selectAll();
            if (files.length == 0) {
                VFSFileChooserDialog.this.ok();
                return;
            }
            int i = 0;
            if (i < files.length) {
                if (files[i].type == 0) {
                    String path = files[i].path;
                    VFS vfs = VFSManager.getVFSForPath(path);
                    if (browser.getMode() == 1 && vfs instanceof FileVFS && VFSFileChooserDialog.this.doFileExistsWarning(path)) {
                        return;
                    }
                    VFSFileChooserDialog.this.isOK = true;
                    VFSFileChooserDialog.this.filenameField.setText(null);
                    if (browser.getMode() != 3) {
                        VFSFileChooserDialog.this.dispose();
                    }
                    return;
                }
                return;
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == VFSFileChooserDialog.this.ok) {
                if (!VFSFileChooserDialog.this.browser.getDirectory().equals(VFSFileChooserDialog.this.browser.getDirectoryField().getText())) {
                    VFSFileChooserDialog.this.browser.setDirectory(VFSFileChooserDialog.this.browser.getDirectoryField().getText());
                } else {
                    VFSFileChooserDialog.this.ok();
                }
            } else if (evt.getSource() == VFSFileChooserDialog.this.cancel) {
                VFSFileChooserDialog.this.cancel();
            }
        }
    }
}

