/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.JTableHeader;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.BrowserView;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;

public class VFSDirectoryEntryTable
extends JTable {
    private BrowserView browserView;
    private FileCellRenderer renderer;
    private StringBuffer typeSelectBuffer = new StringBuffer();
    private Timer timer = new Timer(0, new ClearTypeSelect());
    static /* synthetic */ Class class$org$gjt$sp$jedit$browser$VFSDirectoryEntryTableModel$Entry;

    public VFSDirectoryEntryTable(BrowserView browserView) {
        super(new VFSDirectoryEntryTableModel());
        this.browserView = browserView;
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.renderer = new FileCellRenderer();
        this.setDefaultRenderer(class$org$gjt$sp$jedit$browser$VFSDirectoryEntryTableModel$Entry == null ? (class$org$gjt$sp$jedit$browser$VFSDirectoryEntryTableModel$Entry = VFSDirectoryEntryTable.class$("org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel$Entry")) : class$org$gjt$sp$jedit$browser$VFSDirectoryEntryTableModel$Entry, this.renderer);
        JTableHeader header = this.getTableHeader();
        header.setReorderingAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setAutoResizeMode(0);
    }

    public boolean selectFile(String path) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)this.getValueAt(i, 1);
            if (!entry.dirEntry.path.equals(path)) continue;
            this.setSelectedRow(i);
            return true;
        }
        return false;
    }

    public void doTypeSelect(String str, boolean dirsOnly) {
        if (str.length() == 0) {
            this.clearSelection();
        } else if (this.getSelectedRow() == -1) {
            this.doTypeSelect(str, 0, this.getRowCount(), dirsOnly);
        } else {
            int start = this.getSelectionModel().getMaxSelectionIndex();
            boolean retVal = this.doTypeSelect(str, start, this.getRowCount(), dirsOnly);
            if (!retVal) {
                this.doTypeSelect(str, 0, start, dirsOnly);
            }
        }
    }

    public VFS.DirectoryEntry[] getSelectedFiles() {
        VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)this.getModel();
        LinkedList<VFS.DirectoryEntry> returnValue = new LinkedList<VFS.DirectoryEntry>();
        int[] selectedRows = this.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            returnValue.add(model.files[selectedRows[i]].dirEntry);
        }
        return returnValue.toArray(new VFS.DirectoryEntry[returnValue.size()]);
    }

    public void getExpandedDirectories(Set set) {
        VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)this.getModel();
        if (model.files != null) {
            for (int i = 0; i < model.files.length; ++i) {
                if (!model.files[i].expanded) continue;
                set.add(model.files[i].dirEntry.path);
            }
        }
    }

    public void toggleExpanded(final int row) {
        VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)this.getModel();
        VFSDirectoryEntryTableModel.Entry entry = model.files[row];
        if (entry.dirEntry.type == 0) {
            return;
        }
        if (entry.expanded) {
            model.collapse(VFSManager.getVFSForPath(entry.dirEntry.path), row);
            this.resizeColumnsAppropriately();
        } else {
            this.browserView.clearExpansionState();
            this.browserView.loadDirectory(entry, entry.dirEntry.path);
        }
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSDirectoryEntryTable.this.setSelectedRow(row);
            }
        });
    }

    public void setDirectory(VFS vfs, Object node, ArrayList list, Set tmpExpanded) {
        int startIndex;
        this.timer.stop();
        this.typeSelectBuffer.setLength(0);
        VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)this.getModel();
        if (node == null) {
            startIndex = 0;
            model.setRoot(vfs, list);
        } else {
            startIndex = model.expand(vfs, (VFSDirectoryEntryTableModel.Entry)node, list);
            ++startIndex;
        }
        for (int i = 0; i < list.size(); ++i) {
            VFSDirectoryEntryTableModel.Entry e = model.files[startIndex + i];
            String path = e.dirEntry.path;
            if (!tmpExpanded.contains(path)) continue;
            this.browserView.loadDirectory(e, path);
            tmpExpanded.remove(path);
        }
        this.resizeColumnsAppropriately();
    }

    public void maybeReloadDirectory(String path) {
        VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)this.getModel();
        for (int i = 0; i < model.files.length; ++i) {
            VFSDirectoryEntryTableModel.Entry e = model.files[i];
            if (!e.expanded || e.dirEntry.type == 0) continue;
            VFS.DirectoryEntry dirEntry = e.dirEntry;
            String otherPath = dirEntry.symlinkPath == null ? dirEntry.path : dirEntry.symlinkPath;
            if (!VFSBrowser.pathsEqual(path, otherPath)) continue;
            this.browserView.saveExpansionState();
            this.browserView.loadDirectory(e, path);
            return;
        }
    }

    public void propertiesChanged() {
        this.renderer.propertiesChanged();
        VFS.DirectoryEntry template = new VFS.DirectoryEntry("foo", "foo", "foo", 0, 0L, false);
        this.setRowHeight(this.renderer.getTableCellRendererComponent((JTable)this, (Object)new VFSDirectoryEntryTableModel.Entry((VFS.DirectoryEntry)template, (int)0), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height);
        Dimension prefSize = this.getPreferredSize();
        this.setPreferredScrollableViewportSize(new Dimension(prefSize.width, this.getRowHeight() * 12));
    }

    public void scrollRectToVisible(Rectangle rect) {
        rect.width = 0;
        super.scrollRectToVisible(rect);
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 401) {
            VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)this.getModel();
            int row = this.getSelectedRow();
            switch (evt.getKeyCode()) {
                case 37: {
                    evt.consume();
                    if (row != -1) {
                        if (model.files[row].expanded) {
                            model.collapse(VFSManager.getVFSForPath(model.files[row].dirEntry.path), row);
                            break;
                        }
                        for (int i = row - 1; i >= 0; --i) {
                            if (!model.files[i].expanded) continue;
                            this.setSelectedRow(i);
                            break;
                        }
                    }
                    String dir2 = this.browserView.getBrowser().getDirectory();
                    dir2 = MiscUtilities.getParentOfPath(dir2);
                    this.browserView.getBrowser().setDirectory(dir2);
                    break;
                }
                case 39: {
                    if (row != -1 && !model.files[row].expanded) {
                        this.toggleExpanded(row);
                    }
                    evt.consume();
                    break;
                }
                case 40: {
                    if (row != -1 || this.getModel().getRowCount() == 0) break;
                    this.setSelectedRow(0);
                    evt.consume();
                    break;
                }
                case 10: {
                    this.browserView.getBrowser().filesActivated(evt.isShiftDown() ? 1 : 0, false);
                    evt.consume();
                }
            }
        } else if (evt.getID() == 400) {
            if (evt.isControlDown() || evt.isAltDown() || evt.isMetaDown()) {
                return;
            }
            if (evt.isShiftDown() && evt.getKeyChar() == '\n') {
                return;
            }
            VFSBrowser browser = this.browserView.getBrowser();
            switch (evt.getKeyChar()) {
                case '~': {
                    if (browser.getMode() != 2) break;
                    browser.setDirectory(System.getProperty("user.home"));
                    break;
                }
                case '/': {
                    if (browser.getMode() != 2) break;
                    browser.rootDirectory();
                    break;
                }
                case '-': {
                    if (browser.getMode() != 2) break;
                    browser.setDirectory(browser.getView().getBuffer().getDirectory());
                    break;
                }
                default: {
                    this.typeSelectBuffer.append(evt.getKeyChar());
                    this.doTypeSelect(this.typeSelectBuffer.toString(), browser.getMode() == 3);
                    this.timer.stop();
                    this.timer.setInitialDelay(750);
                    this.timer.setRepeats(false);
                    this.timer.start();
                    return;
                }
            }
        }
        if (!evt.isConsumed()) {
            super.processKeyEvent(evt);
        }
    }

    public void setSelectedRow(int row) {
        this.getSelectionModel().setSelectionInterval(row, row);
        this.scrollRectToVisible(this.getCellRect(row, 0, true));
    }

    private boolean doTypeSelect(String str, int start, int end, boolean dirsOnly) {
        for (int i = start; i < end; ++i) {
            String matchAgainst;
            VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)this.getValueAt(i, 1);
            if (dirsOnly && entry.dirEntry.type == 0) continue;
            String string = matchAgainst = MiscUtilities.isAbsolutePath(str) ? entry.dirEntry.path : entry.dirEntry.name;
            if (!matchAgainst.regionMatches(true, 0, str, 0, str.length())) continue;
            this.setSelectedRow(i);
            return true;
        }
        return false;
    }

    private void resizeColumnsAppropriately() {
        int i;
        VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)this.getModel();
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        int[] widths = new int[model.getColumnCount()];
        for (i = 0; i < widths.length; ++i) {
            String columnName = model.getColumnName(i);
            if (columnName == null) continue;
            widths[i] = (int)this.renderer.plainFont.getStringBounds(columnName, fontRenderContext).getWidth();
        }
        for (i = 0; i < model.files.length; ++i) {
            VFSDirectoryEntryTableModel.Entry entry = model.files[i];
            Font font = entry.dirEntry.type == 0 ? this.renderer.plainFont : this.renderer.boldFont;
            widths[0] = Math.max(widths[0], this.renderer.getEntryWidth(entry, font, fontRenderContext));
            for (int j = 1; j < widths.length; ++j) {
                String extAttr = model.getExtendedAttribute(j - 1);
                String attr = entry.dirEntry.getExtendedAttribute(extAttr);
                if (attr == null) continue;
                widths[j] = Math.max(widths[j], (int)font.getStringBounds(attr, fontRenderContext).getWidth());
            }
        }
        for (i = 0; i < widths.length; ++i) {
            int width = widths[i];
            width = i != widths.length - 1 && width != 0 ? (width += 10) : (width += 2);
            this.getColumnModel().getColumn(i).setPreferredWidth(width);
            this.getColumnModel().getColumn(i).setMinWidth(width);
            this.getColumnModel().getColumn(i).setMaxWidth(width);
            this.getColumnModel().getColumn(i).setWidth(width);
        }
        this.doLayout();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ClearTypeSelect
    implements ActionListener {
        ClearTypeSelect() {
        }

        public void actionPerformed(ActionEvent evt) {
            VFSDirectoryEntryTable.this.typeSelectBuffer.setLength(0);
        }
    }
}

