/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.jEdit;

public class FileCellRenderer
extends DefaultTableCellRenderer {
    public static Icon fileIcon = GUIUtilities.loadIcon("File.png");
    public static Icon openFileIcon = GUIUtilities.loadIcon("OpenFile.png");
    public static Icon dirIcon = GUIUtilities.loadIcon("Folder.png");
    public static Icon openDirIcon = GUIUtilities.loadIcon("OpenFolder.png");
    public static Icon filesystemIcon = GUIUtilities.loadIcon("DriveSmall.png");
    public static Icon loadingIcon = GUIUtilities.loadIcon("ReloadSmall.png");
    Font plainFont = UIManager.getFont("Tree.font");
    Font boldFont;
    boolean showIcons;
    private boolean openBuffer;
    private boolean isSelected;
    private VFS.DirectoryEntry file;

    public FileCellRenderer() {
        if (this.plainFont == null) {
            this.plainFont = jEdit.getFontProperty("metal.secondary.font");
        }
        this.boldFont = this.plainFont.deriveFont(1);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof VFSDirectoryEntryTableModel.Entry) {
            VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)value;
            VFS.DirectoryEntry file = entry.dirEntry;
            this.setFont(file.type == 0 ? this.plainFont : this.boldFont);
            this.isSelected = isSelected;
            this.file = file;
            if (column == 0) {
                String path = file.symlinkPath == null ? file.path : file.symlinkPath;
                this.openBuffer = jEdit._getBuffer(path) != null;
                this.setIcon(this.showIcons ? FileCellRenderer.getIconForFile(file, entry.expanded, this.openBuffer) : null);
                this.setText(file.name);
                int state = file.type == 0 ? 0 : (entry.expanded ? 2 : 1);
                this.setBorder(new ExpansionToggleBorder(state, entry.level));
            } else {
                VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)table.getModel();
                String extAttr = model.getExtendedAttribute(column - 1);
                this.openBuffer = false;
                this.setIcon(null);
                this.setText(file.getExtendedAttribute(extAttr));
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
        }
        return this;
    }

    public void paintComponent(Graphics g) {
        if (!this.isSelected) {
            Color color = this.file.getColor();
            this.setForeground(color == null ? UIManager.getColor("Tree.foreground") : color);
        }
        super.paintComponent(g);
        if (this.openBuffer) {
            int y;
            int x;
            Font font = this.getFont();
            FontMetrics fm = this.getFontMetrics(font);
            if (this.getIcon() == null) {
                x = 0;
                y = fm.getAscent() + 2;
            } else {
                x = this.getIcon().getIconWidth() + this.getIconTextGap();
                y = Math.max(fm.getAscent() + 2, 16);
            }
            Insets border = this.getBorder().getBorderInsets(this);
            g.setColor(this.getForeground());
            g.drawLine(x += border.left, y, x + fm.stringWidth(this.getText()), y);
        }
    }

    public static Icon getIconForFile(VFS.DirectoryEntry file, boolean expanded) {
        return FileCellRenderer.getIconForFile(file, expanded, jEdit._getBuffer(file.symlinkPath) != null);
    }

    public static Icon getIconForFile(VFS.DirectoryEntry file, boolean expanded, boolean openBuffer) {
        if (file.type == 1) {
            return expanded ? openDirIcon : dirIcon;
        }
        if (file.type == 2) {
            return filesystemIcon;
        }
        if (openBuffer) {
            return openFileIcon;
        }
        return fileIcon;
    }

    void propertiesChanged() {
        this.showIcons = jEdit.getBooleanProperty("vfs.browser.showIcons");
    }

    int getEntryWidth(VFSDirectoryEntryTableModel.Entry entry, Font font, FontRenderContext fontRenderContext) {
        String name = entry.dirEntry.name;
        int width = (int)font.getStringBounds(name, fontRenderContext).getWidth();
        width += ExpansionToggleBorder.ICON_WIDTH + entry.level * 15 + 3;
        if (this.showIcons) {
            width += fileIcon.getIconWidth();
            width += this.getIconTextGap();
        }
        return width;
    }

    static class ExpansionToggleBorder
    implements Border {
        static final Icon COLLAPSED_ICON = GUIUtilities.loadIcon("arrow1.png");
        static final Icon EXPANDED_ICON = GUIUtilities.loadIcon("arrow2.png");
        static final int ICON_WIDTH = Math.max(COLLAPSED_ICON.getIconWidth(), EXPANDED_ICON.getIconWidth());
        static final int LEVEL_WIDTH = 15;
        static final int STATE_NONE = 0;
        static final int STATE_COLLAPSED = 1;
        static final int STATE_EXPANDED = 2;
        private int state;
        private int level;

        public ExpansionToggleBorder(int state, int level) {
            this.state = state;
            this.level = level;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            switch (this.state) {
                case 1: {
                    COLLAPSED_ICON.paintIcon(c, g, x + this.level * 15 + 2, y + (height - COLLAPSED_ICON.getIconHeight()) / 2);
                    break;
                }
                case 2: {
                    EXPANDED_ICON.paintIcon(c, g, x + this.level * 15 + 2, y + 2 + (height - EXPANDED_ICON.getIconHeight()) / 2);
                }
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, this.level * 15 + ICON_WIDTH + 4, 1, 1);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public static boolean isExpansionToggle(int level, int x) {
            return x >= level * 15 && x <= level * 15 + ICON_WIDTH;
        }
    }
}

