/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class PropertyManager {
    private Properties system = new Properties();
    private List plugins = new LinkedList();
    private Properties site = new Properties();
    private Properties user = new Properties();

    PropertyManager() {
    }

    Properties getProperties() {
        Properties total = new Properties();
        total.putAll((Map<?, ?>)this.system);
        Iterator iter = this.plugins.iterator();
        while (iter.hasNext()) {
            total.putAll((Map<?, ?>)((Properties)iter.next()));
        }
        total.putAll((Map<?, ?>)this.site);
        total.putAll((Map<?, ?>)this.user);
        return total;
    }

    void loadSystemProps(InputStream in) throws IOException {
        this.loadProps(this.system, in);
    }

    void loadSiteProps(InputStream in) throws IOException {
        this.loadProps(this.site, in);
    }

    void loadUserProps(InputStream in) throws IOException {
        this.loadProps(this.user, in);
    }

    void saveUserProps(OutputStream out) throws IOException {
        this.user.store(out, "jEdit properties");
        out.close();
    }

    Properties loadPluginProps(InputStream in) throws IOException {
        Properties plugin = new Properties();
        this.loadProps(plugin, in);
        this.plugins.add(plugin);
        return plugin;
    }

    void addPluginProps(Properties props) {
        this.plugins.add(props);
    }

    void removePluginProps(Properties props) {
        this.plugins.remove(props);
    }

    String getProperty(String name) {
        String value = this.user.getProperty(name);
        if (value != null) {
            return value;
        }
        return this.getDefaultProperty(name);
    }

    void setProperty(String name, String value) {
        String prop = this.getDefaultProperty(name);
        if (value == null) {
            if (prop == null || prop.length() == 0) {
                this.user.remove(name);
            } else {
                this.user.put(name, "");
            }
        } else if (value.equals(prop)) {
            this.user.remove(name);
        } else {
            this.user.put(name, value);
        }
    }

    public void setTemporaryProperty(String name, String value) {
        this.user.remove(name);
        this.system.put(name, value);
    }

    void unsetProperty(String name) {
        if (this.getDefaultProperty(name) != null) {
            this.user.put(name, "");
        } else {
            this.user.remove(name);
        }
    }

    public void resetProperty(String name) {
        this.user.remove(name);
    }

    private String getDefaultProperty(String name) {
        String value = this.site.getProperty(name);
        if (value != null) {
            return value;
        }
        Iterator iter = this.plugins.iterator();
        while (iter.hasNext()) {
            value = ((Properties)iter.next()).getProperty(name);
            if (value == null) continue;
            return value;
        }
        return this.system.getProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps(Properties into, InputStream in) throws IOException {
        try {
            into.load(in);
        }
        finally {
            in.close();
        }
    }
}

