/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.jEdit;

public class OptionGroup {
    private String name;
    private String label;
    private Vector members;
    private boolean sort;

    public OptionGroup(String name) {
        this.name = name;
        this.label = jEdit.getProperty("options." + name + ".label");
        this.members = new Vector();
    }

    public OptionGroup(String name, String label, String options) {
        this.name = name;
        this.label = label;
        this.members = new Vector();
        StringTokenizer st = new StringTokenizer(options);
        while (st.hasMoreTokens()) {
            String pane = st.nextToken();
            this.addOptionPane(pane);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public void addOptionGroup(OptionGroup group) {
        this.insertionSort(group.getLabel(), group);
    }

    public void addOptionPane(OptionPane pane) {
        String label = jEdit.getProperty("options." + pane.getName() + ".label", "NO LABEL PROPERTY: " + pane.getName());
        this.insertionSort(label, pane);
    }

    public void addOptionPane(String pane) {
        String label = jEdit.getProperty("options." + pane + ".label", "NO LABEL PROPERTY: " + pane);
        this.insertionSort(label, pane);
    }

    public Enumeration getMembers() {
        return this.members.elements();
    }

    public Object getMember(int index) {
        return index >= 0 && index < this.members.size() ? this.members.elementAt(index) : null;
    }

    public int getMemberIndex(Object member) {
        return this.members.indexOf(member);
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public void setSort(boolean sort) {
        this.sort = sort;
    }

    /*
     * WARNING - void declaration
     */
    private void insertionSort(String newLabel, Object newObj) {
        if (this.sort) {
            for (int i = 0; i < this.members.size(); ++i) {
                void var5_5;
                String label;
                Object obj = this.members.elementAt(i);
                if (obj instanceof OptionPane) {
                    String name = ((OptionPane)obj).getName();
                    label = jEdit.getProperty("options." + name + ".label", "NO LABEL PROPERTY: " + name);
                } else if (obj instanceof String) {
                    label = jEdit.getProperty("options." + obj + ".label", "NO LABEL PROPERTY: " + obj);
                } else if (obj instanceof OptionGroup) {
                    label = ((OptionGroup)obj).getLabel();
                } else {
                    throw new InternalError();
                }
                if (newLabel.compareTo((String)var5_5) >= 0) continue;
                this.members.insertElementAt(newObj, i);
                return;
            }
        }
        this.members.addElement(newObj);
    }
}

