/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.io.UrlVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class MiscUtilities {
    public static final String UTF_8_Y = "UTF-8Y";
    public static final DecimalFormat KB_FORMAT = new DecimalFormat("#.# KB");
    public static final DecimalFormat MB_FORMAT = new DecimalFormat("#.# MB");
    static /* synthetic */ Class class$org$gjt$sp$jedit$MiscUtilities;
    static /* synthetic */ Class class$java$lang$String;

    public static String canonPath(String path) {
        if (path.length() == 0) {
            return path;
        }
        if (path.startsWith("file://")) {
            path = path.substring("file://".length());
        } else if (path.startsWith("file:")) {
            path = path.substring("file:".length());
        } else if (MiscUtilities.isURL(path)) {
            return path;
        }
        if (File.separatorChar == '\\') {
            path = path.replace('/', '\\');
            int trim = path.length();
            while (path.charAt(trim - 1) == ' ') {
                --trim;
            }
            path = path.substring(0, trim);
        } else if (OperatingSystem.isMacOS()) {
            path = path.replace(':', '/');
        }
        if (path.startsWith("~" + File.separator)) {
            path = path.substring(2);
            String home = System.getProperty("user.home");
            if (home.endsWith(File.separator)) {
                return home + path;
            }
            return home + File.separator + path;
        }
        if (path.equals("~")) {
            return System.getProperty("user.home");
        }
        return path;
    }

    public static String resolveSymlinks(String path) {
        if (MiscUtilities.isURL(path)) {
            return path;
        }
        if (OperatingSystem.isOS2()) {
            return path;
        }
        if (OperatingSystem.isDOSDerived() && (path.length() == 2 || path.length() == 3) && path.charAt(1) == ':') {
            return path;
        }
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException io) {
            return path;
        }
    }

    public static boolean isAbsolutePath(String path) {
        if (MiscUtilities.isURL(path)) {
            return true;
        }
        if (path.startsWith("~/") || path.startsWith("~" + File.separator) || path.equals("~")) {
            return true;
        }
        if (OperatingSystem.isDOSDerived()) {
            if (path.length() == 2 && path.charAt(1) == ':') {
                return true;
            }
            if (path.length() > 2 && path.charAt(1) == ':' && (path.charAt(2) == '\\' || path.charAt(2) == '/')) {
                return true;
            }
            if (path.startsWith("\\\\") || path.startsWith("//")) {
                return true;
            }
        } else if ((OperatingSystem.isUnix() || OperatingSystem.isVMS()) && path.length() > 0 && path.charAt(0) == '/') {
            return true;
        }
        return false;
    }

    public static String constructPath(String parent, String path) {
        if (MiscUtilities.isAbsolutePath(path)) {
            return MiscUtilities.canonPath(path);
        }
        if (OperatingSystem.isDOSDerived()) {
            if (path.length() == 2 && path.charAt(1) == ':') {
                return path;
            }
            if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) != '\\') {
                path = path.substring(0, 2) + '\\' + path.substring(2);
                return MiscUtilities.canonPath(path);
            }
        }
        String dd = ".." + File.separator;
        String d = "." + File.separator;
        if (parent == null) {
            parent = System.getProperty("user.dir");
        }
        while (true) {
            if (path.equals(".")) {
                return parent;
            }
            if (path.equals("..")) {
                return MiscUtilities.getParentOfPath(parent);
            }
            if (path.startsWith(dd) || path.startsWith("../")) {
                parent = MiscUtilities.getParentOfPath(parent);
                path = path.substring(3);
                continue;
            }
            if (!path.startsWith(d) && !path.startsWith("./")) break;
            path = path.substring(2);
        }
        if (OperatingSystem.isDOSDerived() && !MiscUtilities.isURL(parent) && path.startsWith("\\")) {
            parent = parent.substring(0, 2);
        }
        VFS vfs = VFSManager.getVFSForPath(parent);
        return MiscUtilities.canonPath(vfs.constructPath(parent, path));
    }

    public static String constructPath(String parent, String path1, String path2) {
        return MiscUtilities.constructPath(MiscUtilities.constructPath(parent, path1), path2);
    }

    public static String concatPath(String parent, String path) {
        parent = MiscUtilities.canonPath(parent);
        if ((path = MiscUtilities.canonPath(path)).startsWith(File.separator)) {
            path = path.substring(1);
        } else if (path.length() >= 3 && path.charAt(1) == ':') {
            path = path.replace(':', File.separatorChar);
        }
        if (parent == null) {
            parent = System.getProperty("user.dir");
        }
        if (parent.endsWith(File.separator)) {
            return parent + path;
        }
        return parent + File.separator + path;
    }

    public static String getFileExtension(String name) {
        int fsIndex = Math.max(name.indexOf(47), name.indexOf(File.separatorChar));
        int index = name.indexOf(46, fsIndex);
        if (index == -1) {
            return "";
        }
        return name.substring(index);
    }

    public static String getFileName(String path) {
        return VFSManager.getVFSForPath(path).getFileName(path);
    }

    public static String getFileNameNoExtension(String path) {
        String name = MiscUtilities.getFileName(path);
        int index = name.indexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(0, index);
    }

    public static String getFileParent(String path) {
        return MiscUtilities.getParentOfPath(path);
    }

    public static String getParentOfPath(String path) {
        return VFSManager.getVFSForPath(path).getParentOfPath(path);
    }

    public static String getFileProtocol(String url) {
        return MiscUtilities.getProtocolOfURL(url);
    }

    public static String getProtocolOfURL(String url) {
        return url.substring(0, url.indexOf(58));
    }

    public static boolean isURL(String str) {
        int fsIndex = Math.max(str.indexOf(File.separatorChar), str.indexOf(47));
        if (fsIndex == 0) {
            return false;
        }
        if (fsIndex == 2) {
            return false;
        }
        int cIndex = str.indexOf(58);
        if (cIndex <= 1) {
            return false;
        }
        String protocol = str.substring(0, cIndex);
        VFS vfs = VFSManager.getVFSForProtocol(protocol);
        if (vfs != null && !(vfs instanceof UrlVFS)) {
            return true;
        }
        try {
            new URL(str);
            return true;
        }
        catch (MalformedURLException mf) {
            return false;
        }
    }

    public static void saveBackup(File file, int backups, String backupPrefix, String backupSuffix, String backupDirectory) {
        MiscUtilities.saveBackup(file, backups, backupPrefix, backupSuffix, backupDirectory, 0);
    }

    public static void saveBackup(File file, int backups, String backupPrefix, String backupSuffix, String backupDirectory, int backupTimeDistance) {
        if (backupPrefix == null) {
            backupPrefix = "";
        }
        if (backupSuffix == null) {
            backupSuffix = "";
        }
        String name = file.getName();
        if (backups == 1) {
            File backupFile = new File(backupDirectory, backupPrefix + name + backupSuffix);
            long modTime = backupFile.lastModified();
            if (System.currentTimeMillis() - modTime >= (long)backupTimeDistance) {
                backupFile.delete();
                file.renameTo(backupFile);
            }
        } else {
            new File(backupDirectory, backupPrefix + name + backupSuffix + backups + backupSuffix).delete();
            File firstBackup = new File(backupDirectory, backupPrefix + name + backupSuffix + "1" + backupSuffix);
            long modTime = firstBackup.lastModified();
            if (System.currentTimeMillis() - modTime >= (long)backupTimeDistance) {
                for (int i = backups - 1; i > 0; --i) {
                    File backup = new File(backupDirectory, backupPrefix + name + backupSuffix + i + backupSuffix);
                    backup.renameTo(new File(backupDirectory, backupPrefix + name + backupSuffix + (i + 1) + backupSuffix));
                }
                file.renameTo(new File(backupDirectory, backupPrefix + name + backupSuffix + "1" + backupSuffix));
            }
        }
    }

    public static String fileToClass(String name) {
        char[] clsName = name.toCharArray();
        for (int i = clsName.length - 6; i >= 0; --i) {
            if (clsName[i] != '/') continue;
            clsName[i] = 46;
        }
        return new String(clsName, 0, clsName.length - 6);
    }

    public static String classToFile(String name) {
        return name.replace('.', '/').concat(".class");
    }

    public static int getLeadingWhiteSpace(String str) {
        int whitespace;
        block3: for (whitespace = 0; whitespace < str.length(); ++whitespace) {
            switch (str.charAt(whitespace)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return whitespace;
    }

    public static int getTrailingWhiteSpace(String str) {
        int whitespace = 0;
        block3: for (int i = str.length() - 1; i >= 0; --i) {
            switch (str.charAt(i)) {
                case '\t': 
                case ' ': {
                    ++whitespace;
                    continue block3;
                }
            }
        }
        return whitespace;
    }

    public static int getLeadingWhiteSpaceWidth(String str, int tabSize) {
        int whitespace = 0;
        block4: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case ' ': {
                    ++whitespace;
                    continue block4;
                }
                case '\t': {
                    whitespace += tabSize - whitespace % tabSize;
                    continue block4;
                }
            }
        }
        return whitespace;
    }

    public static int getVirtualWidth(Segment seg, int tabSize) {
        int virtualPosition = 0;
        for (int i = 0; i < seg.count; ++i) {
            char ch = seg.array[seg.offset + i];
            if (ch == '\t') {
                virtualPosition += tabSize - virtualPosition % tabSize;
                continue;
            }
            ++virtualPosition;
        }
        return virtualPosition;
    }

    public static int getOffsetOfVirtualColumn(Segment seg, int tabSize, int column, int[] totalVirtualWidth) {
        int virtualPosition = 0;
        for (int i = 0; i < seg.count; ++i) {
            char ch = seg.array[seg.offset + i];
            if (ch == '\t') {
                int tabWidth = tabSize - virtualPosition % tabSize;
                if (virtualPosition >= column) {
                    return i;
                }
                virtualPosition += tabWidth;
                continue;
            }
            if (virtualPosition >= column) {
                return i;
            }
            ++virtualPosition;
        }
        if (totalVirtualWidth != null) {
            totalVirtualWidth[0] = virtualPosition;
        }
        return -1;
    }

    public static String createWhiteSpace(int len, int tabSize) {
        return MiscUtilities.createWhiteSpace(len, tabSize, 0);
    }

    public static String createWhiteSpace(int len, int tabSize, int start) {
        StringBuffer buf = new StringBuffer();
        if (tabSize == 0) {
            while (len-- > 0) {
                buf.append(' ');
            }
        } else if (len == 1) {
            buf.append(' ');
        } else {
            int count = (len + start % tabSize) / tabSize;
            if (count != 0) {
                len += start;
            }
            while (count-- > 0) {
                buf.append('\t');
            }
            count = len % tabSize;
            while (count-- > 0) {
                buf.append(' ');
            }
        }
        return buf.toString();
    }

    public static String globToRE(String glob) {
        Object NEG = new Object();
        Object GROUP = new Object();
        Stack<Object> state = new Stack<Object>();
        StringBuffer buf = new StringBuffer();
        boolean backslash = false;
        block10: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            if (backslash) {
                buf.append('\\');
                buf.append(c);
                backslash = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    backslash = true;
                    continue block10;
                }
                case '?': {
                    buf.append('.');
                    continue block10;
                }
                case '(': 
                case ')': 
                case '+': 
                case '.': {
                    buf.append('\\');
                    buf.append(c);
                    continue block10;
                }
                case '*': {
                    buf.append(".*");
                    continue block10;
                }
                case '|': {
                    if (backslash) {
                        buf.append("\\|");
                        continue block10;
                    }
                    buf.append('|');
                    continue block10;
                }
                case '{': {
                    buf.append('(');
                    if (i + 1 != glob.length() && glob.charAt(i + 1) == '!') {
                        buf.append('?');
                        state.push(NEG);
                        continue block10;
                    }
                    state.push(GROUP);
                    continue block10;
                }
                case ',': {
                    if (!state.isEmpty() && state.peek() == GROUP) {
                        buf.append('|');
                        continue block10;
                    }
                    buf.append(',');
                    continue block10;
                }
                case '}': {
                    if (!state.isEmpty()) {
                        buf.append(")");
                        if (state.pop() != NEG) continue block10;
                        buf.append(".*");
                        continue block10;
                    }
                    buf.append('}');
                    continue block10;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String escapesToChars(String str) {
        StringBuffer buf = new StringBuffer();
        block7: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    if (i == str.length() - 1) {
                        buf.append('\\');
                        continue block7;
                    }
                    c = str.charAt(++i);
                    switch (c) {
                        case 'n': {
                            buf.append('\n');
                            continue block7;
                        }
                        case 't': {
                            buf.append('\t');
                            continue block7;
                        }
                    }
                    buf.append(c);
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String charsToEscapes(String str) {
        return MiscUtilities.charsToEscapes(str, "\n\t\\\"'");
    }

    public static String charsToEscapes(String str, String toEscape) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (toEscape.indexOf(c) != -1) {
                if (c == '\n') {
                    buf.append("\\n");
                    continue;
                }
                if (c == '\t') {
                    buf.append("\\t");
                    continue;
                }
                buf.append('\\');
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static int compareVersions(String v1, String v2) {
        return MiscUtilities.compareStrings(v1, v2, false);
    }

    public static int compareStrings(String str1, String str2, boolean ignoreCase) {
        char[] char1 = str1.toCharArray();
        char[] char2 = str2.toCharArray();
        int len = Math.min(char1.length, char2.length);
        int i = 0;
        for (int j = 0; i < len && j < len; ++i, ++j) {
            char ch1 = char1[i];
            char ch2 = char2[j];
            if (Character.isDigit(ch1) && Character.isDigit(ch2) && ch1 != '0' && ch2 != '0') {
                int _i;
                int _j = j + 1;
                for (_i = i + 1; _i < char1.length && Character.isDigit(char1[_i]); ++_i) {
                }
                while (_j < char2.length && Character.isDigit(char2[_j])) {
                    ++_j;
                }
                int len1 = _i - i;
                int len2 = _j - j;
                if (len1 > len2) {
                    return 1;
                }
                if (len1 < len2) {
                    return -1;
                }
                for (int k = 0; k < len1; ++k) {
                    ch1 = char1[i + k];
                    ch2 = char2[j + k];
                    if (ch1 == ch2) continue;
                    return ch1 - ch2;
                }
                i = _i - 1;
                j = _j - 1;
                continue;
            }
            if (ignoreCase) {
                ch1 = Character.toLowerCase(ch1);
                ch2 = Character.toLowerCase(ch2);
            }
            if (ch1 == ch2) continue;
            return ch1 - ch2;
        }
        return char1.length - char2.length;
    }

    public static boolean stringsEqual(String s1, String s2) {
        return MiscUtilities.objectsEqual(s1, s2);
    }

    public static boolean objectsEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static String charsToEntities(String str) {
        StringBuffer buf = new StringBuffer(str.length());
        block5: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    buf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block5;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block5;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public static String formatFileSize(long length) {
        if (length < 1024L) {
            return length + " bytes";
        }
        if (length < 0x100000L) {
            return KB_FORMAT.format((double)length / 1024.0);
        }
        return MB_FORMAT.format((double)length / 1024.0 / 1024.0);
    }

    public static String getLongestPrefix(List str, boolean ignoreCase) {
        String s;
        int prefixLength;
        if (str.size() == 0) {
            return "";
        }
        block0: for (prefixLength = 0; prefixLength < (s = str.get(0).toString()).length(); ++prefixLength) {
            char ch = s.charAt(prefixLength);
            for (int i = 1; i < str.size(); ++i) {
                s = str.get(i).toString();
                if (prefixLength >= s.length() || !MiscUtilities.compareChars(s.charAt(prefixLength), ch, ignoreCase)) break block0;
            }
        }
        return str.get(0).toString().substring(0, prefixLength);
    }

    public static String getLongestPrefix(String[] str, boolean ignoreCase) {
        return MiscUtilities.getLongestPrefix((Object[])str, ignoreCase);
    }

    public static String getLongestPrefix(Object[] str, boolean ignoreCase) {
        int prefixLength;
        if (str.length == 0) {
            return "";
        }
        String first = str[0].toString();
        block0: for (prefixLength = 0; prefixLength < first.length(); ++prefixLength) {
            char ch = first.charAt(prefixLength);
            for (int i = 1; i < str.length; ++i) {
                String s = str[i].toString();
                if (prefixLength >= s.length() || !MiscUtilities.compareChars(s.charAt(prefixLength), ch, ignoreCase)) break block0;
            }
        }
        return first.substring(0, prefixLength);
    }

    public static void quicksort(Object[] obj, Comparator compare) {
        Arrays.sort(obj, compare);
    }

    public static void quicksort(Vector vector, Comparator compare) {
        Collections.sort(vector, compare);
    }

    public static void quicksort(List list, Comparator compare) {
        Collections.sort(list, compare);
    }

    public static void quicksort(Object[] obj, Compare compare) {
        Arrays.sort(obj, compare);
    }

    public static void quicksort(Vector vector, Compare compare) {
        Collections.sort(vector, compare);
    }

    public static String buildToVersion(String build) {
        if (build.length() != 11) {
            return "<unknown version: " + build + ">";
        }
        int major = Integer.parseInt(build.substring(0, 2));
        int minor = Integer.parseInt(build.substring(3, 5));
        int beta = Integer.parseInt(build.substring(6, 8));
        int bugfix = Integer.parseInt(build.substring(9, 11));
        return major + "." + minor + (beta != 99 ? "pre" + beta : (bugfix != 0 ? "." + bugfix : "final"));
    }

    public static boolean isToolsJarAvailable() {
        Log.log(1, class$org$gjt$sp$jedit$MiscUtilities == null ? (class$org$gjt$sp$jedit$MiscUtilities = MiscUtilities.class$("org.gjt.sp.jedit.MiscUtilities")) : class$org$gjt$sp$jedit$MiscUtilities, "Searching for tools.jar...");
        Vector<String> paths = new Vector<String>();
        paths.addElement("System classpath: " + System.getProperty("java.class.path"));
        try {
            try {
                Class.forName("sun.tools.javac.Main");
            }
            catch (ClassNotFoundException e1) {
                Class.forName("com.sun.tools.javac.Main");
            }
            Log.log(1, class$org$gjt$sp$jedit$MiscUtilities == null ? (class$org$gjt$sp$jedit$MiscUtilities = MiscUtilities.class$("org.gjt.sp.jedit.MiscUtilities")) : class$org$gjt$sp$jedit$MiscUtilities, "- is in classpath. Fine.");
            return true;
        }
        catch (ClassNotFoundException e) {
            String toolsPath;
            String jEditDir;
            String settingsDir = jEdit.getSettingsDirectory();
            if (settingsDir != null) {
                String toolsPath2 = MiscUtilities.constructPath(settingsDir, "jars", "tools.jar");
                paths.addElement(toolsPath2);
                if (new File(toolsPath2).exists()) {
                    Log.log(1, class$org$gjt$sp$jedit$MiscUtilities == null ? (class$org$gjt$sp$jedit$MiscUtilities = MiscUtilities.class$("org.gjt.sp.jedit.MiscUtilities")) : class$org$gjt$sp$jedit$MiscUtilities, "- is in the user's jars folder. Fine.");
                    return true;
                }
            }
            if ((jEditDir = jEdit.getJEditHome()) != null) {
                toolsPath = MiscUtilities.constructPath(jEditDir, "jars", "tools.jar");
                paths.addElement(toolsPath);
                if (new File(toolsPath).exists()) {
                    Log.log(1, class$org$gjt$sp$jedit$MiscUtilities == null ? (class$org$gjt$sp$jedit$MiscUtilities = MiscUtilities.class$("org.gjt.sp.jedit.MiscUtilities")) : class$org$gjt$sp$jedit$MiscUtilities, "- is in jEdit's system jars folder. Fine.");
                    return true;
                }
            }
            if ((toolsPath = System.getProperty("java.home")).toLowerCase().endsWith(File.separator + "jre")) {
                toolsPath = toolsPath.substring(0, toolsPath.length() - 4);
            }
            toolsPath = MiscUtilities.constructPath(toolsPath, "lib", "tools.jar");
            paths.addElement(toolsPath);
            if (!new File(toolsPath).exists()) {
                Log.log(7, class$org$gjt$sp$jedit$MiscUtilities == null ? (class$org$gjt$sp$jedit$MiscUtilities = MiscUtilities.class$("org.gjt.sp.jedit.MiscUtilities")) : class$org$gjt$sp$jedit$MiscUtilities, "Could not find tools.jar.\nI checked the following locations:\n" + paths.toString());
                return false;
            }
            PluginJAR jar = jEdit.getPluginJAR(toolsPath);
            if (jar == null) {
                Log.log(1, class$org$gjt$sp$jedit$MiscUtilities == null ? (class$org$gjt$sp$jedit$MiscUtilities = MiscUtilities.class$("org.gjt.sp.jedit.MiscUtilities")) : class$org$gjt$sp$jedit$MiscUtilities, "- adding " + toolsPath + " to jEdit plugins.");
                jEdit.addPluginJAR(toolsPath);
            } else {
                Log.log(1, class$org$gjt$sp$jedit$MiscUtilities == null ? (class$org$gjt$sp$jedit$MiscUtilities = MiscUtilities.class$("org.gjt.sp.jedit.MiscUtilities")) : class$org$gjt$sp$jedit$MiscUtilities, "- has been loaded before.");
            }
            return true;
        }
    }

    public static int parsePermissions(String s) {
        int permissions = 0;
        if (s.length() == 9) {
            if (s.charAt(0) == 'r') {
                permissions += 256;
            }
            if (s.charAt(1) == 'w') {
                permissions += 128;
            }
            if (s.charAt(2) == 'x') {
                permissions += 64;
            } else if (s.charAt(2) == 's') {
                permissions += 2112;
            } else if (s.charAt(2) == 'S') {
                permissions += 2048;
            }
            if (s.charAt(3) == 'r') {
                permissions += 32;
            }
            if (s.charAt(4) == 'w') {
                permissions += 16;
            }
            if (s.charAt(5) == 'x') {
                permissions += 8;
            } else if (s.charAt(5) == 's') {
                permissions += 1032;
            } else if (s.charAt(5) == 'S') {
                permissions += 1024;
            }
            if (s.charAt(6) == 'r') {
                permissions += 4;
            }
            if (s.charAt(7) == 'w') {
                permissions += 2;
            }
            if (s.charAt(8) == 'x') {
                ++permissions;
            } else if (s.charAt(8) == 't') {
                permissions += 513;
            } else if (s.charAt(8) == 'T') {
                permissions += 512;
            }
        }
        return permissions;
    }

    public static String[] getEncodings() {
        ArrayList<String> returnValue = new ArrayList<String>();
        if (OperatingSystem.hasJava14()) {
            try {
                Class<?> clazz = Class.forName("java.nio.charset.Charset");
                Method method = clazz.getMethod("availableCharsets", new Class[0]);
                Map map = (Map)method.invoke(null, new Object[0]);
                Iterator iter = map.keySet().iterator();
                returnValue.add(UTF_8_Y);
                while (iter.hasNext()) {
                    returnValue.add((String)iter.next());
                }
            }
            catch (Exception e) {
                Log.log(9, class$org$gjt$sp$jedit$MiscUtilities == null ? (class$org$gjt$sp$jedit$MiscUtilities = MiscUtilities.class$("org.gjt.sp.jedit.MiscUtilities")) : class$org$gjt$sp$jedit$MiscUtilities, e);
            }
        } else {
            StringTokenizer st = new StringTokenizer(jEdit.getProperty("encodings"));
            while (st.hasMoreTokens()) {
                returnValue.add(st.nextToken());
            }
        }
        return returnValue.toArray(new String[returnValue.size()]);
    }

    public static boolean isSupportedEncoding(String encoding) {
        if (OperatingSystem.hasJava14()) {
            try {
                Class<?> clazz = Class.forName("java.nio.charset.Charset");
                Method method = clazz.getMethod("isSupported", class$java$lang$String == null ? (class$java$lang$String = MiscUtilities.class$("java.lang.String")) : class$java$lang$String);
                return (Boolean)method.invoke(null, encoding);
            }
            catch (Exception e) {
                Log.log(9, class$org$gjt$sp$jedit$MiscUtilities == null ? (class$org$gjt$sp$jedit$MiscUtilities = MiscUtilities.class$("org.gjt.sp.jedit.MiscUtilities")) : class$org$gjt$sp$jedit$MiscUtilities, e);
            }
        }
        return true;
    }

    public static String throwableToString(Throwable t) {
        StringWriter s = new StringWriter();
        t.printStackTrace(new PrintWriter(s));
        return s.toString();
    }

    private MiscUtilities() {
    }

    private static boolean compareChars(char ch1, char ch2, boolean ignoreCase) {
        if (ignoreCase) {
            return Character.toUpperCase(ch1) == Character.toUpperCase(ch2);
        }
        return ch1 == ch2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MenuItemCompare
    implements Compare {
        public int compare(Object obj1, Object obj2) {
            return MiscUtilities.compareStrings(((JMenuItem)obj1).getText(), ((JMenuItem)obj2).getText(), true);
        }
    }

    public static class StringICaseCompare
    implements Compare {
        public int compare(Object obj1, Object obj2) {
            return MiscUtilities.compareStrings(obj1.toString(), obj2.toString(), true);
        }
    }

    public static class StringCompare
    implements Compare {
        public int compare(Object obj1, Object obj2) {
            return MiscUtilities.compareStrings(obj1.toString(), obj2.toString(), false);
        }
    }

    public static interface Compare
    extends Comparator {
        public int compare(Object var1, Object var2);
    }
}

