/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.util.Log;

public class JARClassLoader
extends ClassLoader {
    private static final Object NO_CLASS = new Object();
    private static int INDEX;
    private static int live;
    private static Hashtable classHash;
    private int id = INDEX++;
    private PluginJAR jar;
    static /* synthetic */ Class class$org$gjt$sp$jedit$JARClassLoader;

    public JARClassLoader() {
        ++live;
    }

    public Class loadClass(String clazz, boolean resolveIt) throws ClassNotFoundException {
        Object obj = classHash.get(clazz);
        if (obj == NO_CLASS) {
            throw new ClassNotFoundException(clazz);
        }
        if (obj instanceof JARClassLoader) {
            JARClassLoader classLoader = (JARClassLoader)obj;
            return classLoader._loadClass(clazz, resolveIt);
        }
        try {
            ClassLoader parentLoader = this.getClass().getClassLoader();
            Class<?> cls = parentLoader != null ? parentLoader.loadClass(clazz) : this.findSystemClass(clazz);
            return cls;
        }
        catch (ClassNotFoundException cnf) {
            classHash.put(clazz, NO_CLASS);
            throw cnf;
        }
    }

    public InputStream getResourceAsStream(String name) {
        if (this.jar == null) {
            return null;
        }
        try {
            ZipFile zipFile = this.jar.getZipFile();
            ZipEntry entry = zipFile.getEntry(name);
            if (entry == null) {
                return JARClassLoader.getSystemResourceAsStream(name);
            }
            return zipFile.getInputStream(entry);
        }
        catch (IOException io) {
            Log.log(9, this, io);
            return null;
        }
    }

    public URL getResource(String name) {
        if (this.jar == null) {
            return null;
        }
        try {
            ZipFile zipFile = this.jar.getZipFile();
            ZipEntry entry = zipFile.getEntry(name);
            if (entry == null) {
                return JARClassLoader.getSystemResource(name);
            }
            return new URL(this.getResourceAsPath(name));
        }
        catch (IOException io) {
            Log.log(9, this, io);
            return null;
        }
    }

    public String getResourceAsPath(String name) {
        if (this.jar == null) {
            return null;
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        return "jeditresource:/" + MiscUtilities.getFileName(this.jar.getPath()) + "!" + name;
    }

    public ZipFile getZipFile() {
        try {
            return this.jar.getZipFile();
        }
        catch (IOException io) {
            Log.log(9, this, io);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump() {
        Log.log(1, class$org$gjt$sp$jedit$JARClassLoader == null ? (class$org$gjt$sp$jedit$JARClassLoader = JARClassLoader.class$("org.gjt.sp.jedit.JARClassLoader")) : class$org$gjt$sp$jedit$JARClassLoader, "Total instances created: " + INDEX);
        Log.log(1, class$org$gjt$sp$jedit$JARClassLoader == null ? (class$org$gjt$sp$jedit$JARClassLoader = JARClassLoader.class$("org.gjt.sp.jedit.JARClassLoader")) : class$org$gjt$sp$jedit$JARClassLoader, "Live instances: " + live);
        Hashtable hashtable = classHash;
        synchronized (hashtable) {
            Iterator entries = classHash.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (entry.getValue() == NO_CLASS) continue;
                Log.log(1, class$org$gjt$sp$jedit$JARClassLoader == null ? JARClassLoader.class$("org.gjt.sp.jedit.JARClassLoader") : class$org$gjt$sp$jedit$JARClassLoader, entry.getKey() + " ==> " + entry.getValue());
            }
        }
    }

    public String toString() {
        if (this.jar == null) {
            return "<anonymous>(" + this.id + ")";
        }
        return this.jar.getPath() + " (" + this.id + ")";
    }

    protected void finalize() {
        --live;
    }

    JARClassLoader(PluginJAR jar) {
        this();
        this.jar = jar;
    }

    void activate() {
        String[] classes = this.jar.getClasses();
        if (classes != null) {
            for (int i = 0; i < classes.length; ++i) {
                classHash.put(classes[i], this);
            }
        }
    }

    void deactivate() {
        String[] classes = this.jar.getClasses();
        if (classes == null) {
            return;
        }
        for (int i = 0; i < classes.length; ++i) {
            Object loader = classHash.get(classes[i]);
            if (loader != this) continue;
            classHash.remove(classes[i]);
        }
    }

    private synchronized Class _loadClass(String clazz, boolean resolveIt) throws ClassNotFoundException {
        this.jar.activatePlugin();
        JARClassLoader jARClassLoader = this;
        synchronized (jARClassLoader) {
            Class<?> cls = this.findLoadedClass(clazz);
            if (cls != null) {
                if (resolveIt) {
                    this.resolveClass(cls);
                }
                return cls;
            }
            String name = MiscUtilities.classToFile(clazz);
            try {
                ZipFile zipFile = this.jar.getZipFile();
                ZipEntry entry = zipFile.getEntry(name);
                if (entry == null) {
                    throw new ClassNotFoundException(clazz);
                }
                InputStream in = zipFile.getInputStream(entry);
                int len = (int)entry.getSize();
                byte[] data = new byte[len];
                int success = 0;
                int offset = 0;
                while (success < len) {
                    if ((success = in.read(data, offset += success, len -= success)) != -1) continue;
                    Log.log(9, this, "Failed to load class " + clazz + " from " + zipFile.getName());
                    throw new ClassNotFoundException(clazz);
                }
                cls = this.defineClass(clazz, data, 0, data.length);
                if (resolveIt) {
                    this.resolveClass(cls);
                }
                return cls;
            }
            catch (IOException io) {
                Log.log(9, this, io);
                throw new ClassNotFoundException(clazz);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        classHash = new Hashtable();
    }
}

