/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.File;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.gui.OptionsDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.EnhancedMenu;

public abstract class EditPlugin {
    JAR jar;

    public void start() {
    }

    public void stop() {
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public PluginJAR getPluginJAR() {
        return this.jar;
    }

    public final JMenuItem createMenuItems() {
        if (this instanceof Broken) {
            return null;
        }
        String menuItemName = jEdit.getProperty("plugin." + this.getClassName() + ".menu-item");
        if (menuItemName != null) {
            return GUIUtilities.loadMenuItem(menuItemName);
        }
        String menuProperty = "plugin." + this.getClassName() + ".menu";
        String codeProperty = "plugin." + this.getClassName() + ".menu.code";
        if (jEdit.getProperty(menuProperty) != null || jEdit.getProperty(codeProperty) != null) {
            String pluginName = jEdit.getProperty("plugin." + this.getClassName() + ".name");
            return new EnhancedMenu(menuProperty, pluginName);
        }
        return null;
    }

    public final JMenuItem createBrowserMenuItems() {
        if (this instanceof Broken) {
            return null;
        }
        String menuItemName = jEdit.getProperty("plugin." + this.getClassName() + ".browser-menu-item");
        if (menuItemName != null) {
            return GUIUtilities.loadMenuItem(VFSBrowser.getActionContext(), menuItemName, false);
        }
        String menuProperty = "plugin." + this.getClassName() + ".browser-menu";
        if (jEdit.getProperty(menuProperty) != null) {
            String pluginName = jEdit.getProperty("plugin." + this.getClassName() + ".name");
            return new EnhancedMenu(menuProperty, pluginName, VFSBrowser.getActionContext());
        }
        return null;
    }

    public void createMenuItems(Vector menuItems) {
    }

    public void createOptionPanes(OptionsDialog optionsDialog) {
    }

    public JAR getJAR() {
        return this.jar;
    }

    public static class JAR
    extends PluginJAR {
        JAR(File file) {
            super(file);
        }
    }

    public static class Deferred
    extends EditPlugin {
        private String clazz;

        public String getClassName() {
            return this.clazz;
        }

        Deferred(String clazz) {
            this.clazz = clazz;
        }

        EditPlugin loadPluginClass() {
            return null;
        }

        public String toString() {
            return "Deferred[" + this.clazz + "]";
        }
    }

    public static class Broken
    extends EditPlugin {
        private String clazz;

        public String getClassName() {
            return this.clazz;
        }

        Broken(String clazz) {
            this.clazz = clazz;
        }
    }
}

