/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.EmptyStarTable;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.OnceRowPipe;
import uk.ac.starlink.table.RowListStarTable;
import uk.ac.starlink.table.RowPipe;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.SelectorStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;
import uk.ac.starlink.ttools.cone.ConeResultRowSequence;
import uk.ac.starlink.ttools.cone.ConeSearcher;
import uk.ac.starlink.ttools.cone.ParallelResultRowSequence;
import uk.ac.starlink.ttools.cone.QuerySequenceFactory;
import uk.ac.starlink.ttools.cone.SequentialResultRowSequence;
import uk.ac.starlink.ttools.filter.AddColumnsTable;
import uk.ac.starlink.ttools.func.Coords;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;
import uk.ac.starlink.ttools.task.TableProducer;

public class ConeMatcher
implements TableProducer {
    private final ConeSearcher coneSearcher_;
    private final TableProducer inProd_;
    private final QuerySequenceFactory qsFact_;
    private final int parallelism_;
    private final boolean bestOnly_;
    private final String copyColIdList_;
    private final JoinFixAction inFixAct_;
    private final JoinFixAction coneFixAct_;
    private final String distanceCol_;
    private boolean streamOutput_;
    private static final Logger logger_;
    private static final ValueInfo DISTANCE_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$String;

    public ConeMatcher(ConeSearcher coneSearcher, TableProducer inProd, QuerySequenceFactory qsFact, boolean bestOnly) {
        this(coneSearcher, inProd, qsFact, bestOnly, 1, "*", DISTANCE_INFO.getName(), JoinFixAction.NO_ACTION, JoinFixAction.makeRenameDuplicatesAction((String)"_1", (boolean)false, (boolean)false));
    }

    public ConeMatcher(ConeSearcher coneSearcher, TableProducer inProd, QuerySequenceFactory qsFact, boolean bestOnly, int parallelism, String copyColIdList, String distanceCol, JoinFixAction inFixAct, JoinFixAction coneFixAct) {
        this.coneSearcher_ = coneSearcher;
        this.inProd_ = inProd;
        this.qsFact_ = qsFact;
        this.bestOnly_ = bestOnly;
        this.parallelism_ = parallelism;
        this.copyColIdList_ = copyColIdList;
        this.distanceCol_ = distanceCol;
        this.inFixAct_ = inFixAct;
        this.coneFixAct_ = coneFixAct;
    }

    public void setStreamOutput(boolean streamOutput) {
        this.streamOutput_ = streamOutput;
    }

    public StarTable getTable() throws IOException, TaskException {
        StarTable inTable = this.inProd_.getTable();
        ConeQueryRowSequence querySeq = this.qsFact_.createQuerySequence(inTable);
        ConeResultRowSequence resultSeq = this.parallelism_ == 1 ? new SequentialResultRowSequence(querySeq, this.coneSearcher_, this.bestOnly_, this.distanceCol_){

            public void close() throws IOException {
                super.close();
                ConeMatcher.this.coneSearcher_.close();
            }
        } : new ParallelResultRowSequence(querySeq, this.coneSearcher_, this.bestOnly_, this.distanceCol_, this.parallelism_){

            public void close() throws IOException {
                super.close();
                ConeMatcher.this.coneSearcher_.close();
            }
        };
        int[] iCopyCols = this.copyColIdList_ == null || this.copyColIdList_.trim().length() == 0 ? new int[]{} : new ColumnIdentifier(inTable).getColumnIndices(this.copyColIdList_);
        OnceRowPipe rowPipe = new OnceRowPipe();
        ConeWorker coneWorker = new ConeWorker((RowPipe)rowPipe, inTable, resultSeq, iCopyCols, this.distanceCol_ != null && this.distanceCol_.trim().length() > 0 ? 1 : 0, this.inFixAct_, this.coneFixAct_, JoinFixAction.NO_ACTION);
        coneWorker.setDaemon(true);
        coneWorker.start();
        StarTable streamTable = rowPipe.waitForStarTable();
        return this.streamOutput_ ? streamTable : Tables.randomTable((StarTable)streamTable);
    }

    public static StarTable getConeResult(ConeSearcher coneSearcher, boolean bestOnly, String distanceCol, double ra0, double dec0, final double sr) throws IOException {
        Object filteredResultWithDistance;
        if (Double.isNaN(ra0) || Double.isNaN(dec0) || Double.isNaN(sr)) {
            logger_.warning("Invalid search parameters");
            return null;
        }
        logger_.info("Cone: ra=" + ra0 + "; dec=" + dec0 + "; sr=" + sr);
        StarTable result = coneSearcher.performSearch(ra0, dec0, sr);
        if (result == null) {
            return null;
        }
        int ira = coneSearcher.getRaIndex(result);
        int idec = coneSearcher.getDecIndex(result);
        ColumnInfo distInfo = new ColumnInfo(DISTANCE_INFO);
        if (distanceCol != null && distanceCol.trim().length() > 0) {
            distInfo.setName(distanceCol);
        }
        StarTable resultWithDistance = ConeMatcher.addDistanceColumn(result, ira, idec, ra0, dec0, distInfo);
        if (!$assertionsDisabled && resultWithDistance.getColumnCount() != result.getColumnCount() + 1) {
            throw new AssertionError();
        }
        final int idist = resultWithDistance.getColumnCount() - 1;
        if (!$assertionsDisabled && !resultWithDistance.getColumnInfo(idist).getName().equals(distInfo.getName())) {
            throw new AssertionError();
        }
        if (ira < 0 || idec < 0) {
            logger_.warning("Can't locate RA/DEC in output table - no post-filtering or distance calculation");
            filteredResultWithDistance = resultWithDistance;
        } else if (bestOnly) {
            RowSequence rseq = resultWithDistance.getRowSequence();
            double bestDist = Double.NaN;
            Object[] bestRow = null;
            while (rseq.next()) {
                double dist;
                Object distObj = rseq.getCell(idist);
                if (!$assertionsDisabled && distObj != null && !(distObj instanceof Double)) {
                    throw new AssertionError();
                }
                if (!(distObj instanceof Number) || !((dist = ((Number)distObj).doubleValue()) <= sr) || !(dist < bestDist) && !Double.isNaN(bestDist)) continue;
                bestDist = dist;
                bestRow = (Object[])rseq.getRow().clone();
            }
            filteredResultWithDistance = new RowListStarTable(resultWithDistance);
            if (!Double.isNaN(bestDist)) {
                ((RowListStarTable)filteredResultWithDistance).addRow(bestRow);
            }
        } else {
            filteredResultWithDistance = new SelectorStarTable(resultWithDistance){
                static final /* synthetic */ boolean $assertionsDisabled;

                public boolean isIncluded(RowSequence rseq) throws IOException {
                    Object distObj = rseq.getCell(idist);
                    if (!$assertionsDisabled && distObj != null && !(distObj instanceof Double)) {
                        throw new AssertionError();
                    }
                    return distObj instanceof Number && ((Number)distObj).doubleValue() <= sr;
                }

                static {
                    $assertionsDisabled = !(class$uk$ac$starlink$ttools$cone$ConeMatcher == null ? (class$uk$ac$starlink$ttools$cone$ConeMatcher = ConeMatcher.class$("uk.ac.starlink.ttools.cone.ConeMatcher")) : class$uk$ac$starlink$ttools$cone$ConeMatcher).desiredAssertionStatus();
                }
            };
        }
        if (distanceCol != null && distanceCol.trim().length() > 0) {
            return filteredResultWithDistance;
        }
        if (!$assertionsDisabled && idist != filteredResultWithDistance.getColumnCount() - 1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && idist != result.getColumnCount()) {
            throw new AssertionError();
        }
        int[] colMap = new int[idist];
        for (int icol = 0; icol < idist; ++icol) {
            colMap[icol] = icol;
        }
        return new ColumnPermutedStarTable(filteredResultWithDistance, colMap, true);
    }

    private static StarTable addDistanceColumn(StarTable inTable, int ira, int idec, final double ra0, final double dec0, ColumnInfo distInfo) {
        if (!distInfo.getContentClass().isAssignableFrom(Double.class)) {
            throw new IllegalArgumentException("Bad column info type");
        }
        int ncolIn = inTable.getColumnCount();
        ColumnInfo[] addCols = new ColumnInfo[]{distInfo};
        if (ira < 0 || idec < 0) {
            return new AddColumnsTable(inTable, new int[0], addCols, ncolIn){

                protected Object[] calculateValues(Object[] inValues) {
                    return new Object[]{new Double(Double.NaN)};
                }
            };
        }
        return new AddColumnsTable(inTable, new int[]{ira, idec}, addCols, ncolIn){

            protected Object[] calculateValues(Object[] inValues) {
                double ra1 = inValues[0] instanceof Number ? ((Number)inValues[0]).doubleValue() : Double.NaN;
                double dec1 = inValues[1] instanceof Number ? ((Number)inValues[1]).doubleValue() : Double.NaN;
                double dist = Coords.skyDistanceDegrees(ra0, dec0, ra1, dec1);
                return new Object[]{new Double(dist)};
            }
        };
    }

    static {
        $assertionsDisabled = !ConeMatcher.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.ttools.cone");
        DISTANCE_INFO = new DefaultValueInfo("Distance", Double.class, "Angular separation between query position and result position");
        ((DefaultValueInfo)DISTANCE_INFO).setUnitString("deg");
        ((DefaultValueInfo)DISTANCE_INFO).setUCD("pos.angDistance");
    }

    private static class ConeWorker
    extends Thread {
        private final RowPipe rowPipe_;
        private final StarTable inTable_;
        private final ConeResultRowSequence resultSeq_;
        private final int[] iCopyCols_;
        private final int extraCols_;
        private final JoinFixAction inFixAct_;
        private final JoinFixAction coneFixAct_;
        private final JoinFixAction extrasFixAct_;
        static final /* synthetic */ boolean $assertionsDisabled;

        ConeWorker(RowPipe rowPipe, StarTable inTable, ConeResultRowSequence resultSeq, int[] iCopyCols, int extraCols, JoinFixAction inFixAct, JoinFixAction coneFixAct, JoinFixAction extrasFixAct) {
            super("Cone searcher");
            this.rowPipe_ = rowPipe;
            this.inTable_ = inTable;
            this.resultSeq_ = resultSeq;
            this.iCopyCols_ = iCopyCols;
            this.extraCols_ = extraCols;
            this.inFixAct_ = inFixAct;
            this.coneFixAct_ = coneFixAct;
            this.extrasFixAct_ = extrasFixAct;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.multiCone();
            }
            catch (IOException e) {
                this.rowPipe_.setError(e);
            }
            catch (Throwable e) {
                this.rowPipe_.setError((IOException)new IOException("Read error: " + e.getMessage()).initCause(e));
            }
            finally {
                try {
                    this.rowPipe_.endRows();
                }
                catch (IOException e) {}
                try {
                    this.resultSeq_.close();
                }
                catch (IOException e) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void multiCone() throws IOException {
            int ncol = -1;
            int irow = 0;
            while (this.resultSeq_.next()) {
                StarTable result = this.resultSeq_.getConeResult();
                if (result != null) {
                    int nc = result.getColumnCount();
                    if (ncol < 0) {
                        ncol = nc;
                        this.rowPipe_.acceptMetadata(this.getMetadata(result));
                    } else if (nc != ncol) {
                        String msg = "Inconsistent column counts from different cone search invocations (" + nc + " != " + ncol + ")";
                        throw new IOException(msg);
                    }
                    RowSequence rSeq = result.getRowSequence();
                    int nr = 0;
                    try {
                        while (rSeq.next()) {
                            int ic;
                            ++nr;
                            int ncIn = this.iCopyCols_.length;
                            int ncCone = result.getColumnCount();
                            Object[] row = new Object[ncIn + ncCone];
                            for (ic = 0; ic < ncIn; ++ic) {
                                row[ic] = this.resultSeq_.getCell(this.iCopyCols_[ic]);
                            }
                            for (ic = 0; ic < ncCone; ++ic) {
                                row[ncIn + ic] = rSeq.getCell(ic);
                            }
                            this.rowPipe_.acceptRow(row);
                        }
                    }
                    finally {
                        rSeq.close();
                    }
                    logger_.info("Row " + irow + ": got " + nr + (nr == 1 ? " match" : " matches"));
                } else {
                    logger_.info("Row " + irow + ": got no matches");
                }
                ++irow;
            }
            if (ncol < 0) {
                String msg = "No results were found and no table metadata could be gathered.  Sorry.";
                logger_.warning(msg);
                EmptyStarTable result0 = new EmptyStarTable();
                DefaultValueInfo msgInfo = new DefaultValueInfo("Message", class$java$lang$String == null ? (class$java$lang$String = ConeMatcher.class$("java.lang.String")) : class$java$lang$String, "Multicone execution report");
                result0.getParameters().add(new DescribedValue((ValueInfo)msgInfo, (Object)msg));
                this.rowPipe_.acceptMetadata((StarTable)new EmptyStarTable());
            }
        }

        private StarTable getMetadata(StarTable coneResult) {
            int icol;
            int icol2;
            int ncol = this.iCopyCols_.length + coneResult.getColumnCount();
            ColumnInfo[] infos = new ColumnInfo[ncol];
            for (icol2 = 0; icol2 < this.iCopyCols_.length; ++icol2) {
                infos[icol2] = this.inTable_.getColumnInfo(this.iCopyCols_[icol2]);
            }
            for (icol2 = 0; icol2 < coneResult.getColumnCount(); ++icol2) {
                infos[icol2 + this.iCopyCols_.length] = coneResult.getColumnInfo(icol2);
            }
            ArrayList<String> colNames = new ArrayList<String>();
            for (icol = 0; icol < infos.length; ++icol) {
                colNames.add(infos[icol].getName());
            }
            for (icol = 0; icol < infos.length; ++icol) {
                JoinFixAction fixAct = icol < this.iCopyCols_.length ? this.inFixAct_ : (icol < infos.length - this.extraCols_ ? this.coneFixAct_ : this.extrasFixAct_);
                String name = infos[icol].getName();
                if (!$assertionsDisabled && !name.equals(colNames.get(icol))) {
                    throw new AssertionError();
                }
                colNames.set(icol, null);
                String fixName = fixAct.getFixedName(name, colNames);
                colNames.set(icol, name);
                if (fixName.equals(name)) continue;
                ColumnInfo info = new ColumnInfo(infos[icol]);
                info.setName(fixName);
                infos[icol] = info;
            }
            return new RowListStarTable(infos){

                public long getRowCount() {
                    return -1L;
                }

                public boolean isRandom() {
                    return false;
                }
            };
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$ttools$cone$ConeMatcher == null ? (class$uk$ac$starlink$ttools$cone$ConeMatcher = ConeMatcher.class$("uk.ac.starlink.ttools.cone.ConeMatcher")) : class$uk$ac$starlink$ttools$cone$ConeMatcher).desiredAssertionStatus();
        }
    }
}

