/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc.internal;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.xmlrpc.SampXmlRpcHandler;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServer;
import org.astrogrid.samp.xmlrpc.internal.XmlRpcFormatException;
import org.astrogrid.samp.xmlrpc.internal.XmlUtils;
import org.astrogrid.samp.xmlrpc.internal.XmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InternalServer
implements SampXmlRpcServer {
    private final HttpServer server_;
    private final URL endpoint_;
    private final List handlerList_;
    private static final Logger logger_ = Logger.getLogger(InternalServer.class.getName());

    public InternalServer(HttpServer httpServer, final String path) throws IOException {
        this.server_ = httpServer;
        this.endpoint_ = new URL(this.server_.getBaseUrl(), path);
        this.handlerList_ = new ArrayList();
        this.server_.addHandler(new HttpServer.Handler(){

            public HttpServer.Response serveRequest(HttpServer.Request req) {
                if (req.getUrl().equals(path) && req.getMethod().equals("POST")) {
                    return InternalServer.this.getXmlRpcResponse(req.getBody());
                }
                return null;
            }
        });
    }

    public InternalServer() throws IOException {
        this(new HttpServer(), "/xmlrpc");
        this.server_.setDaemon(true);
        this.server_.start();
    }

    public URL getEndpoint() {
        return this.endpoint_;
    }

    public void addHandler(SampXmlRpcHandler handler) {
        this.handlerList_.add(handler);
    }

    public void removeHandler(SampXmlRpcHandler handler) {
        this.handlerList_.remove(handler);
    }

    protected HttpServer.Response getXmlRpcResponse(byte[] body) {
        byte[] rbuf;
        try {
            rbuf = this.getResultBytes(this.getXmlRpcResult(body));
        }
        catch (Throwable e) {
            boolean isChecked = !(e instanceof RuntimeException) && !(e instanceof Error);
            logger_.log(isChecked ? Level.INFO : Level.WARNING, "XML-RPC fault return", e);
            try {
                rbuf = this.getFaultBytes(e);
            }
            catch (IOException e2) {
                return HttpServer.createErrorResponse(500, "Server error", e2);
            }
        }
        final byte[] replyBuf = rbuf;
        HashMap<String, String> hdrMap = new HashMap<String, String>();
        hdrMap.put("Content-Length", Integer.toString(replyBuf.length));
        hdrMap.put("Content-Type", "text/xml");
        return new HttpServer.Response(200, "OK", hdrMap){

            public void writeBody(OutputStream out) throws IOException {
                out.write(replyBuf);
            }
        };
    }

    private Object getXmlRpcResult(byte[] body) throws Exception {
        if (body == null || body.length == 0) {
            throw new XmlRpcFormatException("No body in POSTed request");
        }
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(body));
        Element call = XmlUtils.getChild(doc, "methodCall");
        String methodName = null;
        Element paramsEl = null;
        Element[] methodChildren = XmlUtils.getChildren(call);
        for (int i = 0; i < methodChildren.length; ++i) {
            Element el = methodChildren[i];
            String tagName = el.getTagName();
            if (tagName.equals("methodName")) {
                methodName = XmlUtils.getTextContent(el);
                continue;
            }
            if (!tagName.equals("params")) continue;
            paramsEl = el;
        }
        if (methodName == null) {
            throw new XmlRpcFormatException("No methodName element");
        }
        SampXmlRpcHandler handler = null;
        Iterator it = this.handlerList_.iterator();
        while (it.hasNext() && handler == null) {
            SampXmlRpcHandler h = (SampXmlRpcHandler)it.next();
            if (!h.canHandleCall(methodName)) continue;
            handler = h;
        }
        if (handler == null) {
            return new XmlRpcFormatException("Unknown XML-RPC method " + methodName);
        }
        Element[] paramEls = paramsEl == null ? new Element[]{} : XmlUtils.getChildren(paramsEl);
        int np = paramEls.length;
        ArrayList<Object> paramList = new ArrayList<Object>(np);
        for (int i = 0; i < np; ++i) {
            Element paramEl = paramEls[i];
            if (!"param".equals(paramEl.getTagName())) {
                return new XmlRpcFormatException("Non-param child of params");
            }
            Element valueEl = XmlUtils.getChild(paramEl, "value");
            paramList.add(XmlUtils.parseSampValue(valueEl));
        }
        return this.handleCall(handler, methodName, paramList);
    }

    protected Object handleCall(SampXmlRpcHandler handler, String methodName, List paramList) throws Exception {
        return handler.handleCall(methodName, paramList);
    }

    private byte[] getResultBytes(Object result) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bout = new BufferedOutputStream(out);
        XmlWriter xout = new XmlWriter(bout, 2);
        xout.start("methodResponse");
        xout.start("params");
        xout.start("param");
        xout.sampValue(result);
        xout.end("param");
        xout.end("params");
        xout.end("methodResponse");
        xout.close();
        return out.toByteArray();
    }

    private byte[] getFaultBytes(Throwable error) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bout = new BufferedOutputStream(out);
        XmlWriter xout = new XmlWriter(bout, 2);
        HashMap<String, String> faultMap = new HashMap<String, String>();
        faultMap.put("faultCode", "1");
        faultMap.put("faultString", error.toString());
        xout.start("methodResponse");
        xout.start("fault");
        xout.sampValue(faultMap);
        xout.end("fault");
        xout.end("methodResponse");
        xout.close();
        return out.toByteArray();
    }
}

