/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.astrogrid.samp.hub.HubService;
import org.astrogrid.samp.hub.HubServiceException;
import org.astrogrid.samp.xmlrpc.ActorHandler;
import org.astrogrid.samp.xmlrpc.HubActor;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClient;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClientFactory;
import org.astrogrid.samp.xmlrpc.XmlRpcReceiver;

class HubXmlRpcHandler
extends ActorHandler {
    public HubXmlRpcHandler(SampXmlRpcClientFactory xClientFactory, HubService service, String secret) {
        super("samp.hub", HubActor.class, new HubActorImpl(xClientFactory, service, secret));
    }

    private static class HubActorImpl
    implements HubActor {
        private final SampXmlRpcClientFactory xClientFactory_;
        private final HubService service_;
        private final String secret_;

        HubActorImpl(SampXmlRpcClientFactory xClientFactory, HubService service, String secret) {
            this.xClientFactory_ = xClientFactory;
            this.service_ = service;
            this.secret_ = secret;
        }

        public void ping() {
        }

        public void ping(String privateKey) {
        }

        public Map register(String secret) throws HubServiceException {
            if (this.secret_.equals(secret)) {
                return this.service_.register();
            }
            throw new HubServiceException("Bad password");
        }

        public void unregister(String privateKey) throws HubServiceException {
            this.service_.unregister(privateKey);
        }

        public void setXmlrpcCallback(String privateKey, String surl) throws HubServiceException {
            SampXmlRpcClient xClient;
            try {
                xClient = this.xClientFactory_.createClient(new URL(surl));
            }
            catch (MalformedURLException e) {
                throw new HubServiceException("Bad URL: " + surl, e);
            }
            catch (IOException e) {
                throw new HubServiceException("No connection: " + e.getMessage(), e);
            }
            this.service_.setReceiver(privateKey, new XmlRpcReceiver(xClient, privateKey));
        }

        public void declareMetadata(String privateKey, Map metadata) throws HubServiceException {
            this.service_.declareMetadata(privateKey, metadata);
        }

        public Map getMetadata(String privateKey, String clientId) throws HubServiceException {
            return this.service_.getMetadata(privateKey, clientId);
        }

        public void declareSubscriptions(String privateKey, Map subs) throws HubServiceException {
            this.service_.declareSubscriptions(privateKey, subs);
        }

        public Map getSubscriptions(String privateKey, String clientId) throws HubServiceException {
            return this.service_.getSubscriptions(privateKey, clientId);
        }

        public List getRegisteredClients(String privateKey) throws HubServiceException {
            return this.service_.getRegisteredClients(privateKey);
        }

        public Map getSubscribedClients(String privateKey, String mtype) throws HubServiceException {
            return this.service_.getSubscribedClients(privateKey, mtype);
        }

        public void notify(String privateKey, String recipientId, Map msg) throws HubServiceException {
            this.service_.notify(privateKey, recipientId, msg);
        }

        public List notifyAll(String privateKey, Map msg) throws HubServiceException {
            return this.service_.notifyAll(privateKey, msg);
        }

        public String call(String privateKey, String recipientId, String msgTag, Map msg) throws HubServiceException {
            return this.service_.call(privateKey, recipientId, msgTag, msg);
        }

        public Map callAll(String privateKey, String msgTag, Map msg) throws HubServiceException {
            return this.service_.callAll(privateKey, msgTag, msg);
        }

        public Map callAndWait(String privateKey, String recipientId, Map msg, String timeout) throws HubServiceException {
            return this.service_.callAndWait(privateKey, recipientId, msg, timeout);
        }

        public void reply(String privateKey, String msgId, Map response) throws HubServiceException {
            this.service_.reply(privateKey, msgId, response);
        }
    }
}

