/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFrame;
import org.astrogrid.samp.gui.GuiHubService;
import org.astrogrid.samp.gui.MessageTrackerHubService;
import org.astrogrid.samp.hub.BasicHubService;
import org.astrogrid.samp.hub.HubService;
import org.astrogrid.samp.xmlrpc.HubRunner;

public abstract class HubMode {
    private final String name_;
    private final boolean isDaemon_;
    public static final HubMode NO_GUI = HubMode.createBasicHubMode("no-gui");
    public static final HubMode CLIENT_GUI;
    public static HubMode MESSAGE_GUI;
    private static final HubMode[] KNOWN_MODES;

    HubMode(String name, boolean isDaemon) {
        this.name_ = name;
        this.isDaemon_ = isDaemon;
    }

    abstract HubService createHubService(Random var1, HubRunner[] var2);

    boolean isDaemon() {
        return this.isDaemon_;
    }

    String getName() {
        return this.name_;
    }

    public String toString() {
        return this.name_;
    }

    public static HubMode getModeFromName(String name) {
        HubMode[] modes = KNOWN_MODES;
        for (int im = 0; im < modes.length; ++im) {
            HubMode mode = modes[im];
            if (!mode.name_.equalsIgnoreCase(name)) continue;
            return mode;
        }
        return null;
    }

    public static HubMode[] getAvailableModes() {
        ArrayList<HubMode> modeList = new ArrayList<HubMode>();
        for (int i = 0; i < KNOWN_MODES.length; ++i) {
            HubMode mode = KNOWN_MODES[i];
            if (mode instanceof BrokenHubMode) continue;
            modeList.add(mode);
        }
        return modeList.toArray(new HubMode[0]);
    }

    static void configureHubWindow(JFrame frame, final HubRunner[] runners) {
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                HubRunner runner = runners[0];
                if (runner != null) {
                    runner.shutdown();
                }
            }
        });
        frame.setVisible(true);
    }

    private static HubMode createBasicHubMode(String name) {
        try {
            return new HubMode(name, true){

                HubService createHubService(Random random, HubRunner[] runners) {
                    return new BasicHubService(random);
                }
            };
        }
        catch (Throwable e) {
            return new BrokenHubMode(name, e);
        }
    }

    private static HubMode createGuiHubMode(String name) {
        try {
            GuiHubService.class.getName();
            return new HubMode(name, false){

                HubService createHubService(Random random, HubRunner[] runners) {
                    return new GuiHubService(this, random, runners){
                        private final /* synthetic */ HubRunner[] val$runners;
                        private final /* synthetic */ 3 this$0;
                        {
                            this.this$0 = this$0;
                            this.val$runners = val$runners;
                            super(x0);
                        }

                        public void start() {
                            super.start();
                            HubMode.configureHubWindow(this.createHubWindow(), this.val$runners);
                        }
                    };
                }
            };
        }
        catch (Throwable e) {
            return new BrokenHubMode(name, e);
        }
    }

    private static HubMode createMessageTrackerHubMode(String name) {
        try {
            MessageTrackerHubService.class.getName();
            return new HubMode(name, false){

                HubService createHubService(Random random, HubRunner[] runners) {
                    return new MessageTrackerHubService(this, random, runners){
                        private final /* synthetic */ HubRunner[] val$runners;
                        private final /* synthetic */ 5 this$0;
                        {
                            this.this$0 = this$0;
                            this.val$runners = val$runners;
                            super(x0);
                        }

                        public void start() {
                            super.start();
                            HubMode.configureHubWindow(this.createHubWindow(), this.val$runners);
                        }
                    };
                }
            };
        }
        catch (Throwable e) {
            return new BrokenHubMode(name, e);
        }
    }

    static {
        KNOWN_MODES = new HubMode[]{NO_GUI, CLIENT_GUI = HubMode.createGuiHubMode("client-gui"), MESSAGE_GUI = HubMode.createMessageTrackerHubMode("msg-gui")};
    }

    private static class BrokenHubMode
    extends HubMode {
        private final Throwable error_;

        BrokenHubMode(String name, Throwable error) {
            super(name, false);
            this.error_ = error;
        }

        HubService createHubService(Random random, HubRunner[] runners) {
            throw new RuntimeException("Hub mode " + this.getName() + " unavailable", this.error_);
        }
    }
}

