/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.test;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.ErrInfo;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.HubConnector;
import org.astrogrid.samp.client.MessageHandler;
import org.astrogrid.samp.xmlrpc.StandardClientProfile;
import org.astrogrid.samp.xmlrpc.XmlRpcKit;

public class Snooper {
    private final OutputStream out_;
    private final Map clientMap_;
    private static final byte[] newline_;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Snooper(ClientProfile profile, final Subscriptions subs, OutputStream out, int autoSec) {
        HubConnector connector = new HubConnector(profile);
        this.out_ = out;
        this.clientMap_ = connector.getClientMap();
        Metadata meta = new Metadata();
        meta.setName("Snooper");
        meta.setDescriptionText("Listens in to messages for logging purposes");
        meta.setIconUrl("http://www.star.bristol.ac.uk/~mbt/plastic/images/ears.png");
        meta.put("Author", "Mark Taylor");
        connector.declareMetadata(meta);
        final Response response = new Response();
        response.setStatus("samp.warning");
        response.setResult(new HashMap());
        response.setErrInfo(new ErrInfo("Message logged, not acted on"));
        connector.addMessageHandler(new MessageHandler(){

            public Map getSubscriptions() {
                return subs;
            }

            public void receiveNotification(HubConnection connection, String senderId, Message msg) throws IOException {
                Snooper.this.log(senderId, msg, null);
            }

            public void receiveCall(HubConnection connection, String senderId, String msgId, Message msg) throws IOException {
                Snooper.this.log(senderId, msg, msgId);
                connection.reply(msgId, response);
            }
        });
        connector.declareSubscriptions(connector.computeSubscriptions());
        connector.setActive(true);
        connector.setAutoconnect(autoSec);
    }

    private void log(String senderId, Message msg, String msgId) throws IOException {
        String name;
        Metadata meta;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(senderId);
        Client client = (Client)this.clientMap_.get(senderId);
        if (client != null && (meta = client.getMetadata()) != null && (name = meta.getName()) != null) {
            sbuf.append(" (").append(name).append(")");
        }
        sbuf.append(" --- ");
        if (msgId == null) {
            sbuf.append("notify");
        } else {
            sbuf.append("call").append(" (").append(msgId).append(")");
        }
        this.out_.write(newline_);
        this.out_.write(sbuf.toString().getBytes("UTF-8"));
        this.out_.write(newline_);
        this.out_.write(SampUtils.formatObject(msg, 3).getBytes("UTF-8"));
        this.out_.write(newline_);
    }

    public static void main(String[] args) throws IOException {
        int status = Snooper.runMain(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runMain(String[] args) throws IOException {
        String lock;
        String usage = "\n   Usage:" + "\n      " + Snooper.class.getName() + "\n         " + " [-help]" + " [-/+verbose]" + " [-xmlrpc internal|apache|xml-log|rpc-log]" + "\n         " + " [-mtype <pattern>]" + "\n";
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        int verbAdjust = 0;
        XmlRpcKit xmlrpc = null;
        Subscriptions subs = new Subscriptions();
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.startsWith("-mtype") && it.hasNext()) {
                it.remove();
                String mpat = (String)it.next();
                it.remove();
                subs.addMType(mpat);
                continue;
            }
            if (arg.equals("-xmlrpc") && it.hasNext()) {
                it.remove();
                String impl = (String)it.next();
                it.remove();
                try {
                    xmlrpc = XmlRpcKit.getInstanceByName(impl);
                    continue;
                }
                catch (Exception e) {
                    logger_.log(Level.INFO, "No XMLRPC implementation " + impl, e);
                    System.err.println(usage);
                    return 1;
                }
            }
            if (arg.startsWith("-v")) {
                it.remove();
                --verbAdjust;
                continue;
            }
            if (arg.startsWith("+v")) {
                it.remove();
                ++verbAdjust;
                continue;
            }
            if (arg.startsWith("-h")) {
                it.remove();
                System.out.println(usage);
                return 0;
            }
            it.remove();
            System.err.println(usage);
            return 1;
        }
        if (!$assertionsDisabled && !argList.isEmpty()) {
            throw new AssertionError();
        }
        if (subs.isEmpty()) {
            subs.addMType("*");
        }
        int logLevel = Level.WARNING.intValue() + 100 * verbAdjust;
        Logger.getLogger("org.astrogrid.samp").setLevel(Level.parse(Integer.toString(logLevel)));
        StandardClientProfile profile = xmlrpc == null ? StandardClientProfile.getInstance() : new StandardClientProfile(xmlrpc);
        new Snooper(profile, subs, System.out, 2);
        String string = lock = new String("Forever");
        synchronized (string) {
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return 0;
    }

    static {
        byte[] nl;
        $assertionsDisabled = !Snooper.class.desiredAssertionStatus();
        try {
            nl = System.getProperty("line.separator", "\n").getBytes("UTF-8");
        }
        catch (Exception e) {
            nl = new byte[]{10};
        }
        newline_ = nl;
        logger_ = Logger.getLogger(Snooper.class.getName());
    }
}

