/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.test.TestException;

abstract class ReplyCollector
implements CallableClient {
    private final HubConnection connection_;
    private final Set sentSet_;
    private final Map replyMap_;

    public ReplyCollector(HubConnection connection) {
        this.connection_ = connection;
        this.sentSet_ = Collections.synchronizedSet(new HashSet());
        this.replyMap_ = Collections.synchronizedMap(new HashMap());
    }

    public String call(String recipientId, String msgTag, Map msg) throws SampException {
        Object key = ReplyCollector.createKey(recipientId, msgTag);
        if (this.sentSet_.contains(key)) {
            throw new IllegalArgumentException("Key " + key + " reused");
        }
        this.sentSet_.add(ReplyCollector.createKey(recipientId, msgTag));
        return this.connection_.call(recipientId, msgTag, msg);
    }

    public Map callAll(String msgTag, Map msg) throws SampException {
        Object key = ReplyCollector.createKey(null, msgTag);
        if (this.sentSet_.contains(key)) {
            throw new IllegalArgumentException("Key " + key + " reused");
        }
        this.sentSet_.add(ReplyCollector.createKey(null, msgTag));
        return this.connection_.callAll(msgTag, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveResponse(String responderId, String msgTag, Response response) {
        Object result;
        Object key = ReplyCollector.createKey(responderId, msgTag);
        try {
            if (this.replyMap_.containsKey(key)) {
                throw new TestException("Response for " + key + " already received");
            }
            if (!this.sentSet_.contains(key) && !this.sentSet_.contains(ReplyCollector.createKey(null, msgTag))) {
                throw new TestException("Message " + key + " never sent");
            }
            result = response;
        }
        catch (TestException e) {
            result = e;
        }
        Map map = this.replyMap_;
        synchronized (map) {
            this.replyMap_.put(key, result);
            this.replyMap_.notifyAll();
        }
    }

    public int getReplyCount() {
        return this.replyMap_.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response waitForReply(String responderId, String msgTag) {
        Object key = ReplyCollector.createKey(responderId, msgTag);
        try {
            Map map = this.replyMap_;
            synchronized (map) {
                while (!this.replyMap_.containsKey(key)) {
                    this.replyMap_.wait();
                }
                Object result = this.replyMap_.get(key);
            }
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted", e);
        }
        return this.getReply(responderId, msgTag);
    }

    public Response getReply(String responderId, String msgTag) {
        Object result = this.replyMap_.remove(ReplyCollector.createKey(responderId, msgTag));
        if (result == null) {
            return null;
        }
        if (result instanceof Response) {
            return (Response)result;
        }
        if (result instanceof Throwable) {
            throw new TestException((Throwable)result);
        }
        throw new AssertionError();
    }

    private static Object createKey(String recipientId, String msgTag) {
        return Arrays.asList(recipientId, msgTag);
    }
}

