/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.test;

import java.io.IOException;
import java.io.PrintStream;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.xmlrpc.StandardClientProfile;
import org.astrogrid.samp.xmlrpc.XmlRpcKit;

public abstract class MessageSender {
    public static Logger logger_ = Logger.getLogger(MessageSender.class.getName());

    abstract Map getResponses(HubConnection var1, Message var2, String[] var3) throws IOException;

    void showResults(HubConnection connection, Message msg, String[] recipientIds, PrintStream out) throws IOException {
        Map responses = this.getResponses(connection, msg, recipientIds);
        Iterator it = responses.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String responderId = (String)entry.getKey();
            MetaClient responder = new MetaClient(responderId, connection);
            Object response = entry.getValue();
            out.println();
            out.println(responder);
            out.println(SampUtils.formatObject(response, 3));
        }
    }

    public static void main(String[] args) throws IOException {
        int status = MessageSender.runMain(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int runMain(String[] args) throws IOException {
        void var13_14;
        MessageSender sender;
        StandardClientProfile profile;
        String usage = "\n   Usage:" + ("\n      " + MessageSender.class.getName()) + "\n           " + " [-help]" + " [-/+verbose]" + " [-xmlrpc internal|apache|xml-log|rpc-log]" + "\n           " + " -mtype <mtype>" + " [-param <name> <value> ...]" + "\n           " + " [-target <receiverId> ...]" + " [-mode sync|async|notify]" + "\n           " + " [-sendername <appname>]" + " [-sendermeta <metaname> <metavalue>]" + "\n";
        String mtype = null;
        ArrayList<String> targetList = new ArrayList<String>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String mode = "sync";
        Metadata meta = new Metadata();
        int timeout = 0;
        int verbAdjust = 0;
        XmlRpcKit xmlrpc = null;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-mtype") && it.hasNext()) {
                it.remove();
                if (mtype != null) {
                    System.err.println(usage);
                    return 1;
                }
                mtype = (String)it.next();
                it.remove();
                continue;
            }
            if (arg.equals("-target") && it.hasNext()) {
                it.remove();
                targetList.add((String)it.next());
                it.remove();
                continue;
            }
            if (arg.equals("-param") && it.hasNext()) {
                it.remove();
                String pName = (String)it.next();
                it.remove();
                if (!it.hasNext()) {
                    System.err.println(usage);
                    return 1;
                }
                String pValue = (String)it.next();
                it.remove();
                paramMap.put(pName, MessageSender.parseValue(pValue));
                continue;
            }
            if (arg.equals("-mode") && it.hasNext()) {
                it.remove();
                mode = (String)it.next();
                it.remove();
                continue;
            }
            if (arg.equals("-sendername") && it.hasNext()) {
                it.remove();
                meta.setName((String)it.next());
                it.remove();
                continue;
            }
            if (arg.equals("-sendermeta") && it.hasNext()) {
                it.remove();
                String mName = (String)it.next();
                it.remove();
                if (!it.hasNext()) {
                    System.err.println(usage);
                    return 1;
                }
                String mValue = (String)it.next();
                it.remove();
                meta.put(mName, MessageSender.parseValue(mValue));
                continue;
            }
            if (arg.equals("-timeout") && it.hasNext()) {
                it.remove();
                String stimeout = (String)it.next();
                it.remove();
                try {
                    timeout = Integer.parseInt(stimeout);
                    continue;
                }
                catch (NumberFormatException e) {
                    System.err.println("Not numeric: " + stimeout);
                    System.err.println(usage);
                    return 1;
                }
            }
            if (arg.equals("-xmlrpc") && it.hasNext()) {
                it.remove();
                String impl = (String)it.next();
                it.remove();
                try {
                    xmlrpc = XmlRpcKit.getInstanceByName(impl);
                    continue;
                }
                catch (Exception e) {
                    logger_.log(Level.INFO, "No XMLRPC implementation " + impl, e);
                    System.err.println(usage);
                    return 1;
                }
            }
            if (arg.startsWith("-v")) {
                it.remove();
                --verbAdjust;
                continue;
            }
            if (arg.startsWith("+v")) {
                it.remove();
                ++verbAdjust;
                continue;
            }
            if (arg.startsWith("-h")) {
                it.remove();
                System.out.println(usage);
                return 0;
            }
            it.remove();
            System.err.println(usage);
            return 1;
        }
        if (!argList.isEmpty()) {
            System.err.println(usage);
            return 1;
        }
        if (mtype == null) {
            System.err.println(usage);
            return 1;
        }
        int logLevel = Level.WARNING.intValue() + 100 * verbAdjust;
        Logger.getLogger("org.astrogrid.samp").setLevel(Level.parse(Integer.toString(logLevel)));
        StandardClientProfile standardClientProfile = profile = xmlrpc == null ? StandardClientProfile.getInstance() : new StandardClientProfile(xmlrpc);
        if (mode.toLowerCase().startsWith("async")) {
            sender = new AsynchSender();
        } else if (mode.toLowerCase().startsWith("sync")) {
            sender = new SynchSender(timeout);
        } else if (mode.toLowerCase().startsWith("notif")) {
            sender = new NotifySender();
        } else {
            System.err.println(usage);
            return 1;
        }
        Message msg = new Message(mtype, paramMap);
        String[] targets = targetList.isEmpty() ? null : targetList.toArray(new String[0]);
        HubConnection connection = profile.register();
        if (connection == null) {
            System.err.println("No hub is running");
            return 1;
        }
        connection.declareMetadata(meta);
        var13_14.showResults(connection, msg, targets, System.out);
        connection.unregister();
        return 0;
    }

    private static Object parseValue(String str) {
        String sampObj = str;
        SampUtils.checkObject(sampObj);
        return sampObj;
    }

    private static class BlockingSet
    extends AbstractSet {
        private final List list_ = Collections.synchronizedList(new ArrayList());
        private boolean done_;
        static final /* synthetic */ boolean $assertionsDisabled;

        BlockingSet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object o) {
            if (!$assertionsDisabled && this.list_.contains(o)) {
                throw new AssertionError();
            }
            List list = this.list_;
            synchronized (list) {
                this.list_.add(o);
                this.list_.notifyAll();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.done_ = true;
            List list = this.list_;
            synchronized (list) {
                this.list_.notifyAll();
            }
        }

        public int size() {
            return this.list_.size();
        }

        public Iterator iterator() {
            return new Iterator(this){
                int index_;
                private final /* synthetic */ BlockingSet this$0;
                {
                    this.this$0 = this$0;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public Object next() {
                    return BlockingSet.access$300(this.this$0).get(this.index_++);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean hasNext() {
                    List list = BlockingSet.access$300(this.this$0);
                    synchronized (list) {
                        while (this.index_ >= BlockingSet.access$300(this.this$0).size() && !BlockingSet.access$400(this.this$0)) {
                            try {
                                BlockingSet.access$300(this.this$0).wait();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException("Interrupted", e);
                            }
                        }
                        return this.index_ < BlockingSet.access$300(this.this$0).size();
                    }
                }
            };
        }

        static /* synthetic */ List access$300(BlockingSet x0) {
            return x0.list_;
        }

        static /* synthetic */ boolean access$400(BlockingSet x0) {
            return x0.done_;
        }

        static {
            $assertionsDisabled = !(class$org$astrogrid$samp$test$MessageSender == null ? (class$org$astrogrid$samp$test$MessageSender = MessageSender.class$("org.astrogrid.samp.test.MessageSender")) : class$org$astrogrid$samp$test$MessageSender).desiredAssertionStatus();
        }
    }

    private static class BlockingMap
    extends AbstractMap {
        private final BlockingSet entrySet_ = new BlockingSet();

        BlockingMap() {
        }

        public Set entrySet() {
            return this.entrySet_;
        }

        public synchronized Object put(Object key, Object value) {
            this.entrySet_.add(new Map.Entry(this, key, value){
                private final /* synthetic */ Object val$key;
                private final /* synthetic */ Object val$value;
                private final /* synthetic */ BlockingMap this$0;
                {
                    this.this$0 = this$0;
                    this.val$key = val$key;
                    this.val$value = val$value;
                }

                public Object getKey() {
                    return this.val$key;
                }

                public Object getValue() {
                    return this.val$value;
                }

                public Object setValue(Object value) {
                    throw new UnsupportedOperationException();
                }
            });
            return null;
        }

        synchronized void done() {
            this.entrySet_.done();
        }
    }

    private static class MetaClient
    implements Client {
        private final String id_;
        private final Metadata meta_;

        public MetaClient(String id, HubConnection connection) throws SampException {
            this(id, connection.getMetadata(id));
        }

        public MetaClient(String id, Metadata meta) {
            this.id_ = id;
            this.meta_ = meta;
        }

        public String getId() {
            return this.id_;
        }

        public Metadata getMetadata() {
            return this.meta_;
        }

        public Subscriptions getSubscriptions() {
            return null;
        }

        public String toString() {
            String name;
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(this.getId());
            String string = name = this.meta_ == null ? null : this.meta_.getName();
            if (name != null) {
                sbuf.append(" (").append(name).append(')');
            }
            return sbuf.toString();
        }
    }

    private static class AsynchSender
    extends MessageSender {
        private int iseq_;

        private AsynchSender() {
        }

        public Map getResponses(HubConnection connection, Message msg, String[] recipientIds) throws IOException {
            String msgTag = "tag-" + ++this.iseq_;
            Collector collector = new Collector();
            connection.setCallable(collector);
            if (recipientIds == null) {
                Set recipientSet = connection.callAll(msgTag, msg).keySet();
                collector.setRecipients(recipientSet);
            } else {
                HashSet<String> recipientSet = new HashSet<String>(Arrays.asList(recipientIds));
                Iterator it = recipientSet.iterator();
                while (it.hasNext()) {
                    String recipientId = (String)it.next();
                    connection.call(recipientId, msgTag, msg);
                }
                collector.setRecipients(recipientSet);
            }
            return collector.map_;
        }

        private static class Collector
        implements CallableClient {
            final BlockingMap map_ = new BlockingMap();
            Collection recipients_;

            Collector() {
            }

            public void setRecipients(Collection recipients) {
                int nsend = recipients.size();
                logger_.log(nsend == 0 ? Level.WARNING : Level.INFO, "Waiting for " + nsend + " responses");
                this.recipients_ = recipients;
                if (this.map_.keySet().containsAll(this.recipients_)) {
                    this.map_.done();
                }
            }

            public void receiveCall(String senderId, String msgId, Message msg) {
                throw new UnsupportedOperationException();
            }

            public void receiveNotification(String senderId, Message msg) {
                throw new UnsupportedOperationException();
            }

            public void receiveResponse(String responderId, String msgTag, Response response) {
                this.map_.put(responderId, response);
                if (this.recipients_ != null && this.map_.keySet().containsAll(this.recipients_)) {
                    this.map_.done();
                }
            }
        }
    }

    private static class SynchSender
    extends MessageSender {
        private final int timeout_;

        SynchSender(int timeout) {
            this.timeout_ = timeout;
        }

        public Map getResponses(final HubConnection connection, final Message msg, String[] recIds) throws IOException {
            String[] recipientIds;
            String[] stringArray = recipientIds = recIds == null ? connection.getSubscribedClients(msg.getMType()).keySet().toArray(new String[0]) : recIds;
            if (recipientIds.length == 0) {
                logger_.warning("No clients subscribed to " + msg.getMType());
                return new HashMap();
            }
            int nsend = recipientIds.length;
            logger_.log(nsend == 0 ? Level.WARNING : Level.INFO, "Waiting for " + nsend + " responses");
            final BlockingMap map = new BlockingMap();
            for (int ir = 0; ir < recipientIds.length; ++ir) {
                final String id = recipientIds[ir];
                new Thread(){

                    public void run() {
                        Object result;
                        try {
                            result = connection.callAndWait(id, msg, timeout_);
                        }
                        catch (Throwable e) {
                            result = e;
                        }
                        map.put(id, result);
                        if (map.size() >= recipientIds.length) {
                            map.done();
                        }
                    }
                }.start();
            }
            return map;
        }
    }

    private static class NotifySender
    extends MessageSender {
        private NotifySender() {
        }

        public Map getResponses(HubConnection connection, Message msg, String[] recipientIds) throws IOException {
            List<String> recipientList;
            if (recipientIds == null) {
                recipientList = connection.notifyAll(msg);
                if (recipientList.size() == 0) {
                    logger_.warning("No clients subscribed to " + msg.getMType());
                }
            } else {
                for (int ir = 0; ir < recipientIds.length; ++ir) {
                    connection.notify(recipientIds[ir], msg);
                }
                recipientList = Arrays.asList(recipientIds);
            }
            HashMap<String, String> responseMap = new HashMap<String, String>();
            Iterator<String> it = recipientList.iterator();
            while (it.hasNext()) {
                responseMap.put(it.next(), "<no response from notify>");
            }
            return responseMap;
        }
    }
}

