/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.hub;

import java.util.Map;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.hub.HubServiceException;
import org.astrogrid.samp.hub.Receiver;

public class HubClient
implements Client {
    private final String publicId_;
    private final Object privateKey_;
    private Subscriptions subscriptions_;
    private Metadata metadata_;
    private Receiver receiver_;

    public HubClient(Object privateKey, String publicId) {
        this.privateKey_ = privateKey;
        this.publicId_ = publicId;
        this.subscriptions_ = new Subscriptions();
        this.metadata_ = new Metadata();
        this.receiver_ = new NoReceiver();
    }

    public String getId() {
        return this.publicId_;
    }

    public Metadata getMetadata() {
        return this.metadata_;
    }

    public Subscriptions getSubscriptions() {
        return this.subscriptions_;
    }

    public Object getPrivateKey() {
        return this.privateKey_;
    }

    public void setMetadata(Map meta) {
        this.metadata_ = new Metadata(meta);
    }

    public void setSubscriptions(Map subs) {
        this.subscriptions_ = Subscriptions.asSubscriptions(subs);
    }

    public boolean isSubscribed(String mtype) {
        return this.isCallable() && this.subscriptions_.isSubscribed(mtype);
    }

    public Map getSubscription(String mtype) {
        return this.isCallable() ? this.subscriptions_.getSubscription(mtype) : null;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver_ = receiver == null ? new NoReceiver() : receiver;
    }

    public Receiver getReceiver() {
        return this.receiver_;
    }

    public boolean isCallable() {
        return !(this.receiver_ instanceof NoReceiver);
    }

    public String toString() {
        return SampUtils.toString(this);
    }

    private class NoReceiver
    implements Receiver {
        private NoReceiver() {
        }

        public void receiveNotification(String senderId, Map message) throws HubServiceException {
            this.refuse();
        }

        public void receiveCall(String senderId, String msgId, Map message) throws HubServiceException {
            this.refuse();
        }

        public void receiveResponse(String responderId, String msgId, Map response) throws HubServiceException {
            this.refuse();
        }

        private void refuse() throws HubServiceException {
            throw new HubServiceException("Client " + HubClient.this.getId() + " is not callable");
        }
    }
}

